/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.interactive.client.impl;

import com.alibaba.graphscope.gaia.proto.GraphAlgebraPhysical;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.alibaba.graphscope.gaia.proto.StoredProcedure;
import com.alibaba.graphscope.interactive.ApiCallback;
import com.alibaba.graphscope.interactive.ApiClient;
import com.alibaba.graphscope.interactive.ApiException;
import com.alibaba.graphscope.interactive.ApiResponse;
import com.alibaba.graphscope.interactive.api.AdminServiceGraphManagementApi;
import com.alibaba.graphscope.interactive.api.AdminServiceJobManagementApi;
import com.alibaba.graphscope.interactive.api.AdminServiceProcedureManagementApi;
import com.alibaba.graphscope.interactive.api.AdminServiceServiceManagementApi;
import com.alibaba.graphscope.interactive.api.GraphServiceEdgeManagementApi;
import com.alibaba.graphscope.interactive.api.GraphServiceVertexManagementApi;
import com.alibaba.graphscope.interactive.api.QueryServiceApi;
import com.alibaba.graphscope.interactive.api.UtilsApi;
import com.alibaba.graphscope.interactive.client.Session;
import com.alibaba.graphscope.interactive.client.common.Result;
import com.alibaba.graphscope.interactive.client.common.Status;
import com.alibaba.graphscope.interactive.client.utils.InputFormat;
import com.alibaba.graphscope.interactive.models.CreateGraphRequest;
import com.alibaba.graphscope.interactive.models.CreateGraphResponse;
import com.alibaba.graphscope.interactive.models.CreateProcedureRequest;
import com.alibaba.graphscope.interactive.models.CreateProcedureResponse;
import com.alibaba.graphscope.interactive.models.EdgeData;
import com.alibaba.graphscope.interactive.models.EdgeMapping;
import com.alibaba.graphscope.interactive.models.EdgeRequest;
import com.alibaba.graphscope.interactive.models.GetGraphResponse;
import com.alibaba.graphscope.interactive.models.GetGraphSchemaResponse;
import com.alibaba.graphscope.interactive.models.GetGraphStatisticsResponse;
import com.alibaba.graphscope.interactive.models.GetProcedureResponse;
import com.alibaba.graphscope.interactive.models.JobResponse;
import com.alibaba.graphscope.interactive.models.JobStatus;
import com.alibaba.graphscope.interactive.models.QueryRequest;
import com.alibaba.graphscope.interactive.models.SchemaMapping;
import com.alibaba.graphscope.interactive.models.SchemaMappingLoadingConfig;
import com.alibaba.graphscope.interactive.models.SchemaMappingLoadingConfigDataSource;
import com.alibaba.graphscope.interactive.models.ServiceStatus;
import com.alibaba.graphscope.interactive.models.StartServiceRequest;
import com.alibaba.graphscope.interactive.models.UpdateProcedureRequest;
import com.alibaba.graphscope.interactive.models.UploadFileResponse;
import com.alibaba.graphscope.interactive.models.VertexData;
import com.alibaba.graphscope.interactive.models.VertexMapping;
import com.alibaba.graphscope.interactive.models.VertexRequest;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;

public class DefaultSession
implements Session {
    private static final int DEFAULT_READ_TIMEOUT = 30000;
    private static final int DEFAULT_WRITE_TIMEOUT = 30000;
    private final AdminServiceGraphManagementApi graphApi;
    private final AdminServiceJobManagementApi jobApi;
    private final AdminServiceProcedureManagementApi procedureApi;
    private final AdminServiceServiceManagementApi serviceApi;
    private final GraphServiceVertexManagementApi vertexApi;
    private final GraphServiceEdgeManagementApi edgeApi;
    private final QueryServiceApi queryApi;
    private final UtilsApi utilsApi;
    private final ApiClient client = new ApiClient();
    private final ApiClient queryClient;

    private DefaultSession(String uri, String storedProcUri) {
        this.client.setBasePath(uri);
        this.client.setReadTimeout(30000);
        this.client.setWriteTimeout(30000);
        this.graphApi = new AdminServiceGraphManagementApi(this.client);
        this.jobApi = new AdminServiceJobManagementApi(this.client);
        this.procedureApi = new AdminServiceProcedureManagementApi(this.client);
        this.serviceApi = new AdminServiceServiceManagementApi(this.client);
        this.vertexApi = new GraphServiceVertexManagementApi(this.client);
        this.edgeApi = new GraphServiceEdgeManagementApi(this.client);
        this.utilsApi = new UtilsApi(this.client);
        if (storedProcUri == null) {
            Result<ServiceStatus> status = this.getServiceStatus();
            if (!status.isOk()) {
                throw new RuntimeException("Failed to connect to the server: " + status.getStatusMessage());
            }
            Integer queryPort = status.getValue().getHqpsPort();
            storedProcUri = uri.replaceFirst(":[0-9]+", ":" + queryPort);
            System.out.println("Query URI: " + storedProcUri);
        }
        this.queryClient = new ApiClient();
        this.queryClient.setBasePath(storedProcUri);
        this.queryClient.setReadTimeout(30000);
        this.queryClient.setWriteTimeout(30000);
        this.queryApi = new QueryServiceApi(this.queryClient);
    }

    public static DefaultSession newInstance(String adminUri) {
        return new DefaultSession(adminUri, null);
    }

    public static DefaultSession newInstance(String adminUri, String storedProcUri) {
        return new DefaultSession(adminUri, storedProcUri);
    }

    private static Result<SchemaMapping> validateSchemaMapping(SchemaMapping schemaMapping) {
        String input;
        int i;
        if (schemaMapping == null) {
            return new Result<Object>(Status.badRequest("Schema mapping is null"), null);
        }
        boolean rootLocationMarkedUploaded = false;
        String location = null;
        SchemaMappingLoadingConfig config = schemaMapping.getLoadingConfig();
        if (config != null && config.getDataSource() != null && config.getDataSource().getScheme() != null) {
            if (config.getDataSource().getScheme().equals((Object)SchemaMappingLoadingConfigDataSource.SchemeEnum.FILE)) {
                location = config.getDataSource().getLocation();
            } else {
                return new Result<SchemaMapping>(Status.ok("Only FILE scheme is supported"), schemaMapping);
            }
        }
        if (location != null && location.startsWith("@")) {
            rootLocationMarkedUploaded = true;
        }
        ArrayList<String> extractedFiles = new ArrayList<String>();
        if (schemaMapping.getVertexMappings() != null) {
            for (VertexMapping vertexMapping : schemaMapping.getVertexMappings()) {
                if (vertexMapping.getInputs() == null) continue;
                for (i = 0; i < vertexMapping.getInputs().size(); ++i) {
                    input = vertexMapping.getInputs().get(i);
                    if (location != null && !rootLocationMarkedUploaded && input.startsWith("@")) {
                        return new Result<Object>(Status.badRequest("Root location given without @, but the input file starts with @" + input), null);
                    }
                    if (location != null) {
                        input = location + "/" + DefaultSession.trimPath(input);
                    }
                    vertexMapping.getInputs().set(i, input);
                    extractedFiles.add(input);
                }
            }
        }
        if (schemaMapping.getEdgeMappings() != null) {
            for (EdgeMapping edgeMapping : schemaMapping.getEdgeMappings()) {
                if (edgeMapping.getInputs() == null) continue;
                for (i = 0; i < edgeMapping.getInputs().size(); ++i) {
                    input = edgeMapping.getInputs().get(i);
                    if (location != null && !rootLocationMarkedUploaded && input.startsWith("@")) {
                        return new Result<Object>(Status.badRequest("Root location given without @, but the input file starts with @" + input), null);
                    }
                    if (location != null) {
                        input = location + "/" + DefaultSession.trimPath(input);
                    }
                    edgeMapping.getInputs().set(i, input);
                    extractedFiles.add(input);
                }
            }
        }
        int count = 0;
        for (String file : extractedFiles) {
            if (!file.startsWith("@")) continue;
            ++count;
        }
        if (count == 0) {
            System.out.println("No files to upload");
            return Result.ok(schemaMapping);
        }
        if (count != extractedFiles.size()) {
            System.err.println("Can not mix uploading file and not uploading file");
            return Result.error("Can not mix uploading file and not uploading file");
        }
        return Result.ok(schemaMapping);
    }

    private Result<SchemaMapping> uploadFilesAndUpdate(SchemaMapping schemaMapping) {
        Result<UploadFileResponse> uploadedFile;
        File file;
        String input;
        int i;
        if (schemaMapping.getVertexMappings() != null) {
            for (VertexMapping vertexMapping : schemaMapping.getVertexMappings()) {
                if (vertexMapping.getInputs() == null) continue;
                for (i = 0; i < vertexMapping.getInputs().size(); ++i) {
                    input = vertexMapping.getInputs().get(i);
                    if (!input.startsWith("@")) continue;
                    file = new File(input = input.substring(1));
                    if (!file.exists()) {
                        return new Result<SchemaMapping>(Status.badRequest("File does not exist: " + input), schemaMapping);
                    }
                    uploadedFile = this.uploadFile(file);
                    if (!uploadedFile.isOk()) {
                        return new Result<SchemaMapping>(Status.badRequest("Failed to upload file: " + input + ", " + uploadedFile.getStatusMessage()), schemaMapping);
                    }
                    vertexMapping.getInputs().set(i, uploadedFile.getValue().getFilePath());
                }
            }
        }
        if (schemaMapping.getEdgeMappings() != null) {
            for (EdgeMapping edgeMapping : schemaMapping.getEdgeMappings()) {
                if (edgeMapping.getInputs() == null) continue;
                for (i = 0; i < edgeMapping.getInputs().size(); ++i) {
                    input = edgeMapping.getInputs().get(i);
                    if (!input.startsWith("@")) continue;
                    file = new File(input = input.substring(1));
                    if (!file.exists()) {
                        return new Result<SchemaMapping>(Status.badRequest("File does not exist: " + input), schemaMapping);
                    }
                    uploadedFile = this.uploadFile(file);
                    if (!uploadedFile.isOk()) {
                        return new Result<SchemaMapping>(Status.badRequest("Failed to upload file: " + input + ", " + uploadedFile.getStatusMessage()), schemaMapping);
                    }
                    edgeMapping.getInputs().set(i, uploadedFile.getValue().getFilePath());
                }
            }
        }
        return Result.ok(schemaMapping);
    }

    private static String trimPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        return path.startsWith("@") ? path.substring(1) : path;
    }

    private Result<SchemaMapping> tryUploadFile(SchemaMapping schemaMapping) {
        Result<SchemaMapping> validateResult = DefaultSession.validateSchemaMapping(schemaMapping);
        if (!validateResult.isOk()) {
            return new Result<SchemaMapping>(Status.badRequest("validation failed for schema mapping"), schemaMapping);
        }
        SchemaMapping validatedSchemaMapping = validateResult.getValue();
        System.out.println("Schema mapping validated successfully");
        Result<SchemaMapping> uploadResult = this.uploadFilesAndUpdate(validatedSchemaMapping);
        if (!uploadResult.isOk()) {
            return new Result<SchemaMapping>(Status.badRequest("upload failed for schema mapping"), schemaMapping);
        }
        return uploadResult;
    }

    @Override
    public Result<EdgeData> getEdge(String graphName, String edgeLabel, String srcLabel, Object srcPrimaryKeyValue, String dstLabel, Object dstPrimaryKeyValue) {
        try {
            ApiResponse<EdgeData> response = this.edgeApi.getEdgeWithHttpInfo(graphName, edgeLabel, srcLabel, srcPrimaryKeyValue, dstLabel, dstPrimaryKeyValue);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<String> addEdge(String graphName, EdgeRequest edgeRequest) {
        try {
            ApiResponse<String> response = this.edgeApi.addEdgeWithHttpInfo(graphName, edgeRequest);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<String> deleteEdge(String graphName, String srcLabel, Object srcPrimaryKeyValue, String dstLabel, Object dstPrimaryKeyValue) {
        try {
            ApiResponse<String> response = this.edgeApi.deleteEdgeWithHttpInfo(graphName, srcLabel, srcPrimaryKeyValue, dstLabel, dstPrimaryKeyValue);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<String> updateEdge(String graphName, EdgeRequest edgeRequest) {
        try {
            ApiResponse<String> response = this.edgeApi.updateEdgeWithHttpInfo(graphName, edgeRequest);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<JobResponse> bulkLoading(String graphId, SchemaMapping mapping) {
        Result<SchemaMapping> result = this.tryUploadFile(mapping);
        if (!result.isOk()) {
            System.out.println("Failed to upload files" + result.getStatusMessage());
            return new Result<Object>(result.getStatus(), null);
        }
        try {
            ApiResponse<JobResponse> response = this.graphApi.createDataloadingJobWithHttpInfo(graphId, result.getValue());
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<CreateGraphResponse> createGraph(CreateGraphRequest graph) {
        try {
            ApiResponse<CreateGraphResponse> response = this.graphApi.createGraphWithHttpInfo(graph);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<String> deleteGraph(String graphId) {
        try {
            ApiResponse<String> response = this.graphApi.deleteGraphWithHttpInfo(graphId);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<GetGraphSchemaResponse> getGraphSchema(String graphId) {
        try {
            ApiResponse<GetGraphSchemaResponse> response = this.graphApi.getSchemaWithHttpInfo(graphId);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<GetGraphStatisticsResponse> getGraphStatistics(String graphId) {
        try {
            ApiResponse<GetGraphStatisticsResponse> response = this.graphApi.getGraphStatisticWithHttpInfo(graphId);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<GetGraphResponse> getGraphMeta(String graphId) {
        try {
            ApiResponse<GetGraphResponse> response = this.graphApi.getGraphWithHttpInfo(graphId);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<List<GetGraphResponse>> getAllGraphs() {
        try {
            ApiResponse<List<GetGraphResponse>> response = this.graphApi.listGraphsWithHttpInfo();
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<String> cancelJob(String jobId) {
        try {
            ApiResponse<String> response = this.jobApi.deleteJobByIdWithHttpInfo(jobId);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<JobStatus> getJobStatus(String jobId) {
        try {
            ApiResponse<JobStatus> response = this.jobApi.getJobByIdWithHttpInfo(jobId);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<List<JobStatus>> listJobs() {
        try {
            ApiResponse<List<JobStatus>> response = this.jobApi.listJobsWithHttpInfo();
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<CreateProcedureResponse> createProcedure(String graphId, CreateProcedureRequest procedure) {
        try {
            ApiResponse<CreateProcedureResponse> response = this.procedureApi.createProcedureWithHttpInfo(graphId, procedure);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<String> deleteProcedure(String graphId, String procedureName) {
        try {
            ApiResponse<String> response = this.procedureApi.deleteProcedureWithHttpInfo(graphId, procedureName);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<GetProcedureResponse> getProcedure(String graphId, String procedureId) {
        try {
            ApiResponse<GetProcedureResponse> response = this.procedureApi.getProcedureWithHttpInfo(graphId, procedureId);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<List<GetProcedureResponse>> listProcedures(String graphId) {
        try {
            ApiResponse<List<GetProcedureResponse>> response = this.procedureApi.listProceduresWithHttpInfo(graphId);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<String> updateProcedure(String graphId, String procedureId, UpdateProcedureRequest procedure) {
        try {
            ApiResponse<String> response = this.procedureApi.updateProcedureWithHttpInfo(graphId, procedureId, procedure);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<IrResult.CollectiveResults> callProcedure(String graphId, QueryRequest request) {
        try {
            ApiResponse<byte[]> response = this.queryApi.callProcWithHttpInfo(graphId, this.appendFormatByte(request.toJson().getBytes(), InputFormat.CYPHER_JSON));
            if (response.getStatusCode() != 200) {
                return Result.fromException(new ApiException(response.getStatusCode(), "Failed to call procedure"));
            }
            IrResult.CollectiveResults results = IrResult.CollectiveResults.parseFrom(response.getData());
            return new Result<IrResult.CollectiveResults>(results);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            return Result.error(e.getMessage());
        }
    }

    @Override
    public CompletableFuture<Result<IrResult.CollectiveResults>> callProcedureAsync(String graphId, QueryRequest request) {
        CompletableFuture<Result<IrResult.CollectiveResults>> future = new CompletableFuture<Result<IrResult.CollectiveResults>>();
        CollectiveResultsCallback callBack = new CollectiveResultsCallback(future);
        try {
            Call call = this.queryApi.callProcAsync(graphId, this.appendFormatByte(request.toJson().getBytes(), InputFormat.CYPHER_JSON), callBack);
        }
        catch (ApiException e) {
            e.printStackTrace();
            future.complete(Result.fromException(e));
        }
        return future;
    }

    @Override
    public Result<IrResult.CollectiveResults> callProcedure(QueryRequest request) {
        try {
            ApiResponse<byte[]> response = this.queryApi.callProcCurrentWithHttpInfo(this.appendFormatByte(request.toJson().getBytes(), InputFormat.CYPHER_JSON));
            if (response.getStatusCode() != 200) {
                return Result.fromException(new ApiException(response.getStatusCode(), "Failed to call procedure"));
            }
            IrResult.CollectiveResults results = IrResult.CollectiveResults.parseFrom(response.getData());
            return new Result<IrResult.CollectiveResults>(results);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            return Result.error(e.getMessage());
        }
    }

    @Override
    public CompletableFuture<Result<IrResult.CollectiveResults>> callProcedureAsync(QueryRequest request) {
        CompletableFuture<Result<IrResult.CollectiveResults>> future = new CompletableFuture<Result<IrResult.CollectiveResults>>();
        CollectiveResultsCallback callBack = new CollectiveResultsCallback(future);
        try {
            Call call = this.queryApi.callProcCurrentAsync(this.appendFormatByte(request.toJson().getBytes(), InputFormat.CYPHER_JSON), callBack);
        }
        catch (ApiException e) {
            e.printStackTrace();
            future.complete(Result.fromException(e));
        }
        return future;
    }

    @Override
    public Result<IrResult.CollectiveResults> callProcedure(String graphId, StoredProcedure.Query request) {
        try {
            ApiResponse<byte[]> response = this.queryApi.callProcWithHttpInfo(graphId, this.appendFormatByte(request.toByteArray(), InputFormat.CYPHER_PROCEDURE));
            if (response.getStatusCode() != 200) {
                return Result.fromException(new ApiException(response.getStatusCode(), "Failed to call procedure"));
            }
            IrResult.CollectiveResults results = IrResult.CollectiveResults.parseFrom(response.getData());
            return new Result<IrResult.CollectiveResults>(results);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            return Result.error(e.getMessage());
        }
    }

    @Override
    public CompletableFuture<Result<IrResult.CollectiveResults>> callProcedureAsync(String graphId, StoredProcedure.Query request) {
        CompletableFuture<Result<IrResult.CollectiveResults>> future = new CompletableFuture<Result<IrResult.CollectiveResults>>();
        CollectiveResultsCallback callBack = new CollectiveResultsCallback(future);
        try {
            Call call = this.queryApi.callProcAsync(graphId, this.appendFormatByte(request.toByteArray(), InputFormat.CYPHER_PROCEDURE), callBack);
        }
        catch (ApiException e) {
            e.printStackTrace();
            future.complete(Result.fromException(e));
        }
        return future;
    }

    @Override
    public Result<IrResult.CollectiveResults> callProcedure(StoredProcedure.Query request) {
        try {
            ApiResponse<byte[]> response = this.queryApi.callProcCurrentWithHttpInfo(this.appendFormatByte(request.toByteArray(), InputFormat.CYPHER_PROCEDURE));
            if (response.getStatusCode() != 200) {
                return Result.fromException(new ApiException(response.getStatusCode(), "Failed to call procedure"));
            }
            IrResult.CollectiveResults results = IrResult.CollectiveResults.parseFrom(response.getData());
            return new Result<IrResult.CollectiveResults>(results);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            return Result.error(e.getMessage());
        }
    }

    @Override
    public CompletableFuture<Result<IrResult.CollectiveResults>> callProcedureAsync(StoredProcedure.Query request) {
        CompletableFuture<Result<IrResult.CollectiveResults>> future = new CompletableFuture<Result<IrResult.CollectiveResults>>();
        CollectiveResultsCallback callBack = new CollectiveResultsCallback(future);
        try {
            Call call = this.queryApi.callProcCurrentAsync(this.appendFormatByte(request.toByteArray(), InputFormat.CYPHER_PROCEDURE), callBack);
        }
        catch (ApiException e) {
            e.printStackTrace();
            future.complete(Result.fromException(e));
        }
        return future;
    }

    @Override
    public Result<byte[]> callProcedureRaw(String graphId, byte[] request) {
        try {
            ApiResponse<byte[]> response = this.queryApi.callProcWithHttpInfo(graphId, this.appendFormatByte(request, InputFormat.CPP_ENCODER));
            if (response.getStatusCode() != 200) {
                return Result.fromException(new ApiException(response.getStatusCode(), "Failed to call procedure"));
            }
            return new Result<byte[]>(response.getData());
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public CompletableFuture<Result<byte[]>> callProcedureRawAsync(String graphId, byte[] request) {
        CompletableFuture<Result<byte[]>> future = new CompletableFuture<Result<byte[]>>();
        RawBytesCallback callBack = new RawBytesCallback(future);
        try {
            Call call = this.queryApi.callProcAsync(graphId, this.appendFormatByte(request, InputFormat.CPP_ENCODER), callBack);
        }
        catch (ApiException e) {
            e.printStackTrace();
            future.complete(Result.fromException(e));
        }
        return future;
    }

    @Override
    public Result<byte[]> callProcedureRaw(byte[] request) {
        try {
            ApiResponse<byte[]> response = this.queryApi.callProcCurrentWithHttpInfo(this.appendFormatByte(request, InputFormat.CPP_ENCODER));
            if (response.getStatusCode() != 200) {
                return Result.fromException(new ApiException(response.getStatusCode(), "Failed to call procedure"));
            }
            return new Result<byte[]>(response.getData());
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public CompletableFuture<Result<byte[]>> callProcedureRawAsync(byte[] request) {
        CompletableFuture<Result<byte[]>> future = new CompletableFuture<Result<byte[]>>();
        RawBytesCallback callBack = new RawBytesCallback(future);
        try {
            Call call = this.queryApi.callProcCurrentAsync(this.appendFormatByte(request, InputFormat.CPP_ENCODER), callBack);
        }
        catch (ApiException e) {
            e.printStackTrace();
            future.complete(Result.fromException(e));
        }
        return future;
    }

    @Override
    public Result<IrResult.CollectiveResults> runAdhocQuery(String graphId, GraphAlgebraPhysical.PhysicalPlan physicalPlan) {
        try {
            ApiResponse<byte[]> response = this.queryApi.runAdhocWithHttpInfo(graphId, physicalPlan.toByteArray());
            if (response.getStatusCode() != 200) {
                return Result.fromException(new ApiException(response.getStatusCode(), "Failed to call procedure"));
            }
            IrResult.CollectiveResults results = IrResult.CollectiveResults.parseFrom(response.getData());
            return new Result<IrResult.CollectiveResults>(results);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            return Result.error(e.getMessage());
        }
    }

    @Override
    public CompletableFuture<Result<IrResult.CollectiveResults>> runAdhocQueryAsync(String graphId, GraphAlgebraPhysical.PhysicalPlan physicalPlan) {
        CompletableFuture<Result<IrResult.CollectiveResults>> future = new CompletableFuture<Result<IrResult.CollectiveResults>>();
        CollectiveResultsCallback callBack = new CollectiveResultsCallback(future);
        try {
            Call call = this.queryApi.runAdhocAsync(graphId, physicalPlan.toByteArray(), callBack);
        }
        catch (ApiException e) {
            e.printStackTrace();
            future.complete(Result.fromException(e));
        }
        return future;
    }

    @Override
    public Result<IrResult.CollectiveResults> runAdhocQuery(GraphAlgebraPhysical.PhysicalPlan physicalPlan) {
        try {
            ApiResponse<byte[]> response = this.queryApi.runAdhocCurrentWithHttpInfo(physicalPlan.toByteArray());
            if (response.getStatusCode() != 200) {
                return Result.fromException(new ApiException(response.getStatusCode(), "Failed to call procedure"));
            }
            IrResult.CollectiveResults results = IrResult.CollectiveResults.parseFrom(response.getData());
            return new Result<IrResult.CollectiveResults>(results);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            return Result.error(e.getMessage());
        }
    }

    @Override
    public CompletableFuture<Result<IrResult.CollectiveResults>> runAdhocQueryAsync(GraphAlgebraPhysical.PhysicalPlan physicalPlan) {
        CompletableFuture<Result<IrResult.CollectiveResults>> future = new CompletableFuture<Result<IrResult.CollectiveResults>>();
        CollectiveResultsCallback callBack = new CollectiveResultsCallback(future);
        try {
            Call call = this.queryApi.runAdhocCurrentAsync(physicalPlan.toByteArray(), callBack);
        }
        catch (ApiException e) {
            e.printStackTrace();
            future.complete(Result.fromException(e));
        }
        return future;
    }

    @Override
    public Result<ServiceStatus> getServiceStatus() {
        try {
            ApiResponse<ServiceStatus> response = this.serviceApi.getServiceStatusWithHttpInfo();
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<String> restartService() {
        try {
            ApiResponse<String> response = this.serviceApi.restartServiceWithHttpInfo();
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<String> startService(StartServiceRequest service) {
        try {
            ApiResponse<String> response = this.serviceApi.startServiceWithHttpInfo(service);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<String> stopService() {
        try {
            ApiResponse<String> response = this.serviceApi.stopServiceWithHttpInfo();
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<String> addVertex(String graphId, VertexRequest request) {
        try {
            ApiResponse<String> response = this.vertexApi.addVertexWithHttpInfo(graphId, request);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<String> updateVertex(String graphId, VertexRequest request) {
        try {
            ApiResponse<String> response = this.vertexApi.updateVertexWithHttpInfo(graphId, request);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<VertexData> getVertex(String graphId, String label, Object primaryKey) {
        try {
            ApiResponse<VertexData> response = this.vertexApi.getVertexWithHttpInfo(graphId, label, primaryKey);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public Result<String> deleteVertex(String graphId, String label, Object primaryKey) {
        try {
            ApiResponse<String> response = this.vertexApi.deleteVertexWithHttpInfo(graphId, label, primaryKey);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public Result<UploadFileResponse> uploadFile(File fileStorage) {
        try {
            ApiResponse<UploadFileResponse> response = this.utilsApi.uploadFileWithHttpInfo(fileStorage);
            return Result.fromResponse(response);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.fromException(e);
        }
    }

    private byte[] appendFormatByte(byte[] payload, InputFormat inputFormat) {
        byte[] newBytes = new byte[payload.length + 1];
        if (payload.length > 0) {
            System.arraycopy(payload, 0, newBytes, 0, payload.length);
        }
        newBytes[payload.length] = (byte)inputFormat.ordinal();
        return newBytes;
    }

    private static class RawBytesCallback
    implements ApiCallback<byte[]> {
        private CompletableFuture<Result<byte[]>> future;

        public RawBytesCallback(CompletableFuture<Result<byte[]>> future) {
            this.future = future;
        }

        @Override
        public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
            this.future.complete(Result.fromException(e));
        }

        @Override
        public void onSuccess(byte[] result, int statusCode, Map<String, List<String>> responseHeaders) {
            this.future.complete(Result.ok(result));
        }

        @Override
        public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
        }

        @Override
        public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
        }
    }

    private static class CollectiveResultsCallback
    implements ApiCallback<byte[]> {
        private CompletableFuture<Result<IrResult.CollectiveResults>> future;

        CollectiveResultsCallback(CompletableFuture<Result<IrResult.CollectiveResults>> future) {
            this.future = future;
        }

        @Override
        public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
            this.future.complete(Result.fromException(e));
        }

        @Override
        public void onSuccess(byte[] result, int statusCode, Map<String, List<String>> responseHeaders) {
            try {
                IrResult.CollectiveResults results = IrResult.CollectiveResults.parseFrom(result);
                this.future.complete(new Result<IrResult.CollectiveResults>(results));
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
                this.future.complete(Result.error("Error when deserialize response to collective results" + e.getMessage()));
            }
        }

        @Override
        public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
        }

        @Override
        public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
        }
    }
}

