/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common;

import com.alibaba.graphscope.groot.common.exception.InvalidArgumentException;
import java.util.HashMap;
import java.util.Map;

public enum RoleType {
    UNKNOWN("unknown"),
    FRONTEND("frontend"),
    STORE("store"),
    COORDINATOR("coordinator"),
    FRONTEND_SERVICE("frontend_service"),
    GAIA_ENGINE("gaia_engine"),
    GAIA_RPC("gaia_rpc");

    private final String name;
    private static final Map<String, RoleType> lookup;

    private RoleType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static RoleType fromName(String roleName) {
        RoleType roleType = lookup.get(roleName);
        if (roleType == null || roleType == UNKNOWN) {
            throw new InvalidArgumentException("Unknown RoleType: [" + roleName + "]");
        }
        return roleType;
    }

    static {
        lookup = new HashMap<String, RoleType>();
        for (RoleType role : RoleType.values()) {
            lookup.put(role.getName(), role);
        }
    }
}

