/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.config;

import com.alibaba.graphscope.proto.groot.ConfigPb;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class Configs {
    private final Properties properties;

    public Configs() {
        this.properties = new Properties();
    }

    public Configs(String configFile) throws IOException {
        this();
        try (FileInputStream is = new FileInputStream(configFile);){
            this.properties.load(is);
        }
    }

    public Configs(Properties properties) {
        this.properties = properties;
    }

    public Configs(Map<String, String> configs) {
        this.properties = new Properties();
        if (configs != null && !configs.isEmpty()) {
            configs.forEach(this.properties::setProperty);
        }
    }

    public String get(String name) {
        return this.properties.getProperty(name);
    }

    public String get(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    public ConfigPb toProto() {
        ConfigPb.Builder builder = ConfigPb.newBuilder();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            builder.putConfigs(entry.getKey().toString(), entry.getValue().toString());
        }
        return builder.build();
    }

    public String toString() {
        return this.properties.toString();
    }

    public Properties getInnerProperties() {
        return this.properties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Configs fromConfigs) {
        return new Builder(fromConfigs);
    }

    public static Builder newBuilder(Properties properties) {
        return new Builder(properties);
    }

    public static class Builder {
        private Properties properties = new Properties();

        private Builder() {
        }

        private Builder(Configs fromConfigs) {
            fromConfigs.properties.entrySet().forEach(e -> this.properties.put(e.getKey(), e.getValue()));
        }

        private Builder(Properties properties) {
            this();
            this.properties.putAll((Map<?, ?>)properties);
        }

        public Builder put(String key, String val) {
            this.properties.put(key, val);
            return this;
        }

        public Configs build() {
            return new Configs(this.properties);
        }
    }
}

