/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.impl;

import com.alibaba.graphscope.groot.common.schema.api.GraphStatistics;
import com.alibaba.graphscope.groot.common.schema.wrapper.EdgeKind;
import com.alibaba.graphscope.groot.common.schema.wrapper.LabelId;
import com.alibaba.graphscope.proto.groot.Statistics;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGraphStatistics
implements GraphStatistics {
    private static final Logger logger = LoggerFactory.getLogger(DefaultGraphStatistics.class);
    private Map<LabelId, Long> vertexTypeCounts = Maps.newHashMap();
    private Map<EdgeKind, Long> edgeTypeCounts = Maps.newHashMap();
    private Long totalVertexCount;
    private Long totalEdgeCount;

    public DefaultGraphStatistics(Map<LabelId, Long> vertexTypeCounts, Map<EdgeKind, Long> edgeTypeCounts, Long totalVertexCount, Long totalEdgeCount) {
        this.vertexTypeCounts = vertexTypeCounts;
        this.edgeTypeCounts = edgeTypeCounts;
        this.totalVertexCount = totalVertexCount;
        this.totalEdgeCount = totalEdgeCount;
    }

    @Override
    public String getVersion() {
        return "0";
    }

    @Override
    public Long getVertexCount() {
        return this.totalVertexCount;
    }

    @Override
    public Long getEdgeCount() {
        return this.totalEdgeCount;
    }

    @Override
    public Long getVertexTypeCount(Integer vertexTypeId) {
        return this.vertexTypeCounts.get(new LabelId(vertexTypeId));
    }

    @Override
    public Long getEdgeTypeCount(Optional<Integer> sourceTypeId, Optional<Integer> edgeTypeId, Optional<Integer> targetTypeId) {
        Long count = this.edgeTypeCounts.entrySet().stream().filter(entry -> !sourceTypeId.isPresent() || ((EdgeKind)entry.getKey()).getSrcVertexLabelId().equals(new LabelId((Integer)sourceTypeId.get()))).filter(entry -> !edgeTypeId.isPresent() || ((EdgeKind)entry.getKey()).getEdgeLabelId().equals(new LabelId((Integer)edgeTypeId.get()))).filter(entry -> !targetTypeId.isPresent() || ((EdgeKind)entry.getKey()).getDstVertexLabelId().equals(new LabelId((Integer)targetTypeId.get()))).collect(Collectors.summingLong(Map.Entry::getValue));
        return count == null ? 0L : count;
    }

    public static DefaultGraphStatistics parseProto(Statistics statistics) {
        long vcount = statistics.getNumVertices();
        long ecount = statistics.getNumEdges();
        HashMap<LabelId, Long> vertexTypeCounts = new HashMap<LabelId, Long>();
        HashMap<EdgeKind, Long> edgeTypeCounts = new HashMap<EdgeKind, Long>();
        for (Statistics.VertexTypeStatistics vertexTypeStatistics : statistics.getVertexTypeStatisticsList()) {
            vertexTypeCounts.put(LabelId.parseProto(vertexTypeStatistics.getLabelId()), vertexTypeStatistics.getNumVertices());
        }
        for (Statistics.EdgeTypeStatistics edgeTypeStatistics : statistics.getEdgeTypeStatisticsList()) {
            edgeTypeCounts.put(EdgeKind.parseProto(edgeTypeStatistics.getEdgeKind()), edgeTypeStatistics.getNumEdges());
        }
        return new DefaultGraphStatistics(vertexTypeCounts, edgeTypeCounts, vcount, ecount);
    }

    public String toString() {
        return "DefaultGraphStatistics{vertexTypeCounts=" + this.vertexTypeCounts + ", edgeTypeCounts=" + this.edgeTypeCounts + ", totalVertexCount=" + this.totalVertexCount + ", totalEdgeCount=" + this.totalEdgeCount + "}";
    }
}

