/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.impl;

import com.alibaba.graphscope.groot.common.exception.InvalidArgumentException;
import com.alibaba.graphscope.groot.common.schema.api.GraphProperty;
import com.alibaba.graphscope.groot.common.schema.api.GraphVertex;
import com.alibaba.graphscope.groot.common.schema.wrapper.TypeDef;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultGraphVertex
implements GraphVertex {
    private final int labelId;
    private final String label;
    private final List<GraphProperty> propertyList;
    private final List<String> primaryKeyList;
    private final int versionId;
    private final long tableId;

    public DefaultGraphVertex(int labelId, String label, List<GraphProperty> propertyList, List<String> primaryKeyList) {
        this(labelId, label, propertyList, primaryKeyList, 0, 0L);
    }

    public DefaultGraphVertex(int labelId, String label, List<GraphProperty> propertyList, List<String> primaryKeyList, int versionId, long tableId) {
        this.label = label;
        this.labelId = labelId;
        this.propertyList = propertyList;
        this.primaryKeyList = primaryKeyList;
        this.versionId = versionId;
        this.tableId = tableId;
    }

    public DefaultGraphVertex(TypeDef typeDef, long tableId) {
        this(typeDef.getLabelId(), typeDef.getLabel(), typeDef.getPropertyList(), typeDef.getPrimaryKeyNameList(), typeDef.getVersionId(), tableId);
    }

    @Override
    public List<String> getPrimaryKeyNameList() {
        return this.primaryKeyList;
    }

    @Override
    public List<GraphProperty> getPrimaryKeyList() {
        ArrayList<GraphProperty> props = new ArrayList<GraphProperty>();
        for (String name : this.primaryKeyList) {
            props.add(this.getProperty(name));
        }
        return props;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getLabelId() {
        return this.labelId;
    }

    @Override
    public List<GraphProperty> getPropertyList() {
        return this.propertyList;
    }

    @Override
    public GraphProperty getProperty(int propId) {
        for (GraphProperty graphProperty : this.propertyList) {
            if (graphProperty.getId() != propId) continue;
            return graphProperty;
        }
        throw new InvalidArgumentException("Can't get graph property for id " + propId);
    }

    @Override
    public GraphProperty getProperty(String propName) {
        for (GraphProperty graphProperty : this.propertyList) {
            if (!Objects.equals(propName, graphProperty.getName())) continue;
            return graphProperty;
        }
        throw new InvalidArgumentException("Can't get graph property for name " + propName);
    }

    @Override
    public int getVersionId() {
        return this.versionId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("labelId", this.labelId).add("label", (Object)this.label).add("propertyList", this.propertyList).add("primaryKeyList", this.primaryKeyList).toString();
    }

    @Override
    public long getTableId() {
        return this.tableId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGraphVertex that = (DefaultGraphVertex)o;
        return this.labelId == that.labelId && this.versionId == that.versionId && this.tableId == that.tableId && this.label.equals(that.label) && Objects.equals(this.propertyList, that.propertyList) && Objects.equals(this.primaryKeyList, that.primaryKeyList);
    }

    public int hashCode() {
        return Objects.hash(this.labelId, this.label, this.propertyList, this.primaryKeyList, this.versionId, this.tableId);
    }
}

