/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.mapper;

import com.alibaba.graphscope.groot.common.schema.api.EdgeRelation;
import com.alibaba.graphscope.groot.common.schema.api.GraphVertex;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultEdgeRelation;
import java.util.Map;

public class EdgeRelationMapper {
    private String srcVertexLabel;
    private String dstVertexLabel;
    private String edgeLabel;
    private long tableId;

    public String getSrcVertexLabel() {
        return this.srcVertexLabel;
    }

    public void setSrcVertexLabel(String srcVertexLabel) {
        this.srcVertexLabel = srcVertexLabel;
    }

    public String getDstVertexLabel() {
        return this.dstVertexLabel;
    }

    public void setDstVertexLabel(String dstVertexLabel) {
        this.dstVertexLabel = dstVertexLabel;
    }

    public String getEdgeLabel() {
        return this.edgeLabel;
    }

    public void setEdgeLabel(String edgeLabel) {
        this.edgeLabel = edgeLabel;
    }

    public long getTableId() {
        return this.tableId;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    public static EdgeRelationMapper parseFromEdgeRelation(String edgeLabel, EdgeRelation edgeRelation) {
        EdgeRelationMapper edgeRelationMapper = new EdgeRelationMapper();
        edgeRelationMapper.setSrcVertexLabel(edgeRelation.getSource().getLabel());
        edgeRelationMapper.setDstVertexLabel(edgeRelation.getTarget().getLabel());
        edgeRelationMapper.setEdgeLabel(edgeLabel);
        edgeRelationMapper.setTableId(edgeRelation.getTableId());
        return edgeRelationMapper;
    }

    public EdgeRelation toEdgeRelation(Map<String, GraphVertex> vertexTypeMap) {
        GraphVertex sourceGraphVertex = vertexTypeMap.get(this.srcVertexLabel);
        GraphVertex targetGraphVertex = vertexTypeMap.get(this.dstVertexLabel);
        return new DefaultEdgeRelation(sourceGraphVertex, targetGraphVertex, this.tableId);
    }
}

