/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.mapper;

import com.alibaba.graphscope.groot.common.exception.InvalidArgumentException;
import com.alibaba.graphscope.groot.common.schema.api.GraphProperty;
import com.alibaba.graphscope.groot.common.schema.api.GraphVertex;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultGraphVertex;
import com.alibaba.graphscope.groot.common.schema.mapper.ElementIndexMapper;
import com.alibaba.graphscope.groot.common.schema.mapper.GraphPropertyMapper;
import com.alibaba.graphscope.groot.common.schema.mapper.SchemaElementMapper;
import com.alibaba.graphscope.groot.common.schema.wrapper.TypeEnum;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VertexTypeMapper
extends SchemaElementMapper {
    private List<ElementIndexMapper> indexes;
    private long tableId;

    public static VertexTypeMapper parseFromVertexType(GraphVertex graphVertex) {
        VertexTypeMapper vertexTypeMapper = new VertexTypeMapper();
        vertexTypeMapper.setId(graphVertex.getLabelId());
        vertexTypeMapper.setLabel(graphVertex.getLabel());
        vertexTypeMapper.setType(TypeEnum.VERTEX.toString());
        ElementIndexMapper elementIndexMapper = new ElementIndexMapper();
        elementIndexMapper.setName("primary_key");
        elementIndexMapper.setIndexType("PRIMARY_KEY");
        elementIndexMapper.setPropertyNames(graphVertex.getPrimaryKeyNameList());
        ArrayList<ElementIndexMapper> elementIndexMapperList = new ArrayList<ElementIndexMapper>();
        elementIndexMapperList.add(elementIndexMapper);
        vertexTypeMapper.setIndexes(elementIndexMapperList);
        ArrayList<GraphPropertyMapper> propertyMapperList = new ArrayList<GraphPropertyMapper>();
        for (GraphProperty graphProperty : graphVertex.getPropertyList()) {
            propertyMapperList.add(GraphPropertyMapper.parseFromGraphProperty(graphProperty));
        }
        vertexTypeMapper.setPropertyDefList(propertyMapperList);
        vertexTypeMapper.setVersionId(graphVertex.getVersionId());
        vertexTypeMapper.setTableId(graphVertex.getTableId());
        return vertexTypeMapper;
    }

    public List<ElementIndexMapper> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<ElementIndexMapper> indexes) {
        this.indexes = indexes;
    }

    public long getTableId() {
        return this.tableId;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    public GraphVertex toVertexType() {
        List<GraphProperty> graphPropertyList = this.getPropertyDefList().stream().map(GraphPropertyMapper::toGraphProperty).collect(Collectors.toList());
        if (this.indexes.size() > 1) {
            throw new InvalidArgumentException("Only support primary key now for " + this.indexes);
        }
        List<String> primaryKeyList = this.indexes.get(0).getPropertyNames();
        return new DefaultGraphVertex(this.getId(), this.getLabel(), graphPropertyList, primaryKeyList, this.getVersionId(), this.getTableId());
    }
}

