/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.unified;

import com.alibaba.graphscope.groot.common.exception.TypeNotFoundException;
import com.alibaba.graphscope.groot.common.schema.unified.EdgeType;
import com.alibaba.graphscope.groot.common.schema.unified.VertexType;
import com.alibaba.graphscope.groot.common.schema.unified.VertexTypePairRelation;
import java.util.List;
import java.util.Objects;

public class Schema {
    public List<VertexType> vertexTypes;
    public List<EdgeType> edgeTypes;

    public String toString() {
        return "Schema{vertexTypes=" + this.vertexTypes + ", edgeTypes=" + this.edgeTypes + "}";
    }

    private VertexType getVertexType(String label) throws TypeNotFoundException {
        for (VertexType type : this.vertexTypes) {
            if (!Objects.equals(type.getLabel(), label)) continue;
            return type;
        }
        return null;
    }

    public Schema munge() {
        for (EdgeType edgeType : this.edgeTypes) {
            for (VertexTypePairRelation relation : edgeType.vertexTypePairRelations) {
                relation.source = this.getVertexType(relation.sourceVertex);
                relation.target = this.getVertexType(relation.destinationVertex);
            }
        }
        return this;
    }
}

