/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.unified;

import com.alibaba.graphscope.groot.common.schema.api.GraphElement;
import com.alibaba.graphscope.groot.common.schema.api.GraphProperty;
import com.alibaba.graphscope.groot.common.schema.unified.Property;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Type
implements GraphElement {
    public int typeId;
    public String typeName;
    public String description;
    public List<String> primaryKeys;
    public List<Property> properties;
    public int versionId;

    public String toString() {
        return "Type{typeId=" + this.typeId + ", typeName='" + this.typeName + "', description='" + this.description + "', primaryKeys=" + this.primaryKeys + ", properties=" + this.properties + "}";
    }

    @Override
    @JsonIgnore
    public String getLabel() {
        return this.typeName;
    }

    @Override
    @JsonIgnore
    public int getLabelId() {
        return this.typeId;
    }

    @Override
    @JsonIgnore
    public List<GraphProperty> getPropertyList() {
        return new ArrayList<GraphProperty>(this.properties);
    }

    @Override
    public GraphProperty getProperty(int propId) {
        for (Property property : this.properties) {
            if (property.getId() != propId) continue;
            return property;
        }
        return null;
    }

    @Override
    public GraphProperty getProperty(String propName) {
        for (Property property : this.properties) {
            if (!Objects.equals(property.getName(), propName)) continue;
            return property;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public int getVersionId() {
        return this.versionId;
    }

    @Override
    @JsonIgnore
    public List<GraphProperty> getPrimaryKeyList() {
        if (this.primaryKeys == null) {
            return new ArrayList<GraphProperty>();
        }
        return this.properties.stream().filter(property -> this.primaryKeys.contains(property.getName())).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<String> getPrimaryKeyNameList() {
        return this.primaryKeys;
    }
}

