/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.wrapper;

import com.alibaba.graphscope.groot.common.exception.InvalidDataTypeException;
import com.alibaba.graphscope.groot.common.exception.UnsupportedOperationException;
import com.alibaba.graphscope.groot.common.meta.InternalDataType;
import com.alibaba.graphscope.proto.groot.DataTypePb;

public enum DataType {
    UNKNOWN(0),
    BOOL(1),
    CHAR(2),
    SHORT(3),
    INT(4),
    LONG(5),
    FLOAT(6),
    DOUBLE(7),
    STRING(8),
    BYTES(9),
    INT_LIST(10),
    LONG_LIST(11),
    FLOAT_LIST(12),
    DOUBLE_LIST(13),
    STRING_LIST(14),
    BYTES_LIST(15),
    DATE(16),
    TIME32(17),
    TIMESTAMP(18);

    private final byte type;
    private static final DataType[] TYPES;

    private DataType(int type) {
        this.type = (byte)type;
    }

    public static DataType fromId(byte id) {
        if (id < 0 || id >= TYPES.length) {
            throw new InvalidDataTypeException("Unknown DataType: [" + id + "]");
        }
        return TYPES[id];
    }

    public static DataType parseProto(DataTypePb pb) {
        return DataType.fromId((byte)pb.getNumber());
    }

    public static DataType parseString(String type) {
        String upperType = type.toUpperCase();
        if (upperType.startsWith("LIST<")) {
            String typeValue = upperType.substring(5, upperType.length() - 1) + "_LIST";
            return DataType.valueOf(typeValue);
        }
        return DataType.valueOf(type);
    }

    public DataTypePb toProto() {
        return DataTypePb.forNumber(this.type);
    }

    public String toString() {
        Object dataTypeString = this.name();
        if (((String)dataTypeString).endsWith("_LIST")) {
            String[] dataTypeArray = ((String)dataTypeString).split("_");
            dataTypeString = "LIST<" + dataTypeArray[0] + ">";
        }
        return dataTypeString;
    }

    public boolean isFixedLength() {
        switch (this) {
            case BOOL: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public int getTypeLength() {
        switch (this) {
            case BOOL: {
                return 1;
            }
            case CHAR: 
            case SHORT: {
                return 2;
            }
            case INT: 
            case FLOAT: {
                return 4;
            }
            case LONG: 
            case DOUBLE: {
                return 8;
            }
        }
        throw new UnsupportedOperationException("not a fixed length type [" + this + "]");
    }

    public static DataType parseFromDataType(com.alibaba.graphscope.groot.common.meta.DataType dataType) {
        InternalDataType internalDataType = dataType.getType();
        switch (internalDataType) {
            case BOOL: {
                return BOOL;
            }
            case CHAR: {
                return CHAR;
            }
            case SHORT: {
                return SHORT;
            }
            case INT: {
                return INT;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case STRING: {
                return STRING;
            }
            case DATE: {
                return DATE;
            }
            case TIME: {
                return TIME32;
            }
            case TIMESTAMP: {
                return TIMESTAMP;
            }
            case BYTES: {
                return BYTES;
            }
            case LIST: {
                switch (InternalDataType.valueOf(dataType.getExpression())) {
                    case INT: {
                        return INT_LIST;
                    }
                    case LONG: {
                        return LONG_LIST;
                    }
                    case FLOAT: {
                        return FLOAT_LIST;
                    }
                    case DOUBLE: {
                        return DOUBLE_LIST;
                    }
                    case STRING: {
                        return STRING_LIST;
                    }
                }
                throw new InvalidDataTypeException("Unsupported property data type " + dataType);
            }
        }
        throw new InvalidDataTypeException("Unsupported property data type " + dataType);
    }

    static {
        TYPES = DataType.values();
    }
}

