/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.wrapper;

import com.alibaba.graphscope.groot.common.exception.IllegalSchemaException;
import com.alibaba.graphscope.groot.common.exception.InvalidArgumentException;
import com.alibaba.graphscope.groot.common.exception.NotFoundException;
import com.alibaba.graphscope.groot.common.exception.PropertyNotFoundException;
import com.alibaba.graphscope.groot.common.exception.TypeNotFoundException;
import com.alibaba.graphscope.groot.common.schema.api.EdgeRelation;
import com.alibaba.graphscope.groot.common.schema.api.GraphEdge;
import com.alibaba.graphscope.groot.common.schema.api.GraphElement;
import com.alibaba.graphscope.groot.common.schema.api.GraphProperty;
import com.alibaba.graphscope.groot.common.schema.api.GraphSchema;
import com.alibaba.graphscope.groot.common.schema.api.GraphVertex;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultEdgeRelation;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultGraphEdge;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultGraphVertex;
import com.alibaba.graphscope.groot.common.schema.wrapper.EdgeKind;
import com.alibaba.graphscope.groot.common.schema.wrapper.LabelId;
import com.alibaba.graphscope.groot.common.schema.wrapper.TypeDef;
import com.alibaba.graphscope.groot.common.schema.wrapper.TypeEnum;
import com.alibaba.graphscope.proto.groot.EdgeKindPb;
import com.alibaba.graphscope.proto.groot.EdgeTableIdEntry;
import com.alibaba.graphscope.proto.groot.GraphDefPb;
import com.alibaba.graphscope.proto.groot.TypeDefPb;
import com.alibaba.graphscope.proto.groot.VertexTableIdEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GraphDef
implements GraphSchema {
    private final long version;
    private final Map<String, LabelId> labelToId;
    private final Map<LabelId, TypeDef> idToType;
    private final Map<LabelId, Set<EdgeKind>> idToKinds;
    private final Map<String, Integer> propertyNameToId;
    private final int labelIdx;
    private final int propertyIdx;
    private final Map<LabelId, Long> vertexTableIds;
    private final Map<EdgeKind, Long> edgeTableIds;
    private final long tableIdx;
    private Map<LabelId, GraphVertex> vertexTypes;
    private Map<LabelId, GraphEdge> edgeTypes;

    public GraphDef(long version, Map<String, LabelId> labelToId, Map<LabelId, TypeDef> idToType, Map<LabelId, Set<EdgeKind>> idToKinds, Map<String, Integer> propertyNameToId, int labelIdx, int propertyIdx, Map<LabelId, Long> vertexTableIds, Map<EdgeKind, Long> edgeTableIds, long tableIdx) {
        this.version = version;
        this.labelToId = Collections.unmodifiableMap(new HashMap<String, LabelId>(labelToId));
        this.idToType = Collections.unmodifiableMap(new HashMap<LabelId, TypeDef>(idToType));
        this.idToKinds = Collections.unmodifiableMap(new HashMap<LabelId, Set<EdgeKind>>(idToKinds));
        this.propertyNameToId = Collections.unmodifiableMap(new HashMap<String, Integer>(propertyNameToId));
        this.vertexTableIds = Collections.unmodifiableMap(new HashMap<LabelId, Long>(vertexTableIds));
        this.edgeTableIds = Collections.unmodifiableMap(new HashMap<EdgeKind, Long>(edgeTableIds));
        this.labelIdx = labelIdx;
        this.propertyIdx = propertyIdx;
        this.tableIdx = tableIdx;
        this.buildVertexTypes();
        this.buildEdgeTypes();
    }

    private void buildEdgeTypes() {
        this.edgeTypes = new HashMap<LabelId, GraphEdge>();
        for (TypeDef typeDef : this.idToType.values()) {
            if (typeDef.getTypeEnum() != TypeEnum.EDGE) continue;
            LabelId labelId = typeDef.getTypeLabelId();
            DefaultGraphEdge edgeType = this.getEdgeType(typeDef);
            this.edgeTypes.put(labelId, edgeType);
        }
    }

    private DefaultGraphEdge getEdgeType(TypeDef typeDef) {
        LabelId labelId = typeDef.getTypeLabelId();
        Set<EdgeKind> edgeKindSet = this.idToKinds.get(labelId);
        ArrayList<EdgeRelation> edgeRelations = new ArrayList<EdgeRelation>();
        if (edgeKindSet != null) {
            for (EdgeKind edgeKind : edgeKindSet) {
                GraphVertex srcGraphVertex = this.vertexTypes.get(edgeKind.getSrcVertexLabelId());
                GraphVertex dstGraphVertex = this.vertexTypes.get(edgeKind.getDstVertexLabelId());
                Long tableId = this.edgeTableIds.get(edgeKind);
                if (tableId == null) {
                    throw new InvalidArgumentException("no valid table id for [" + edgeKind + "]");
                }
                edgeRelations.add(new DefaultEdgeRelation(srcGraphVertex, dstGraphVertex, tableId));
            }
        }
        return new DefaultGraphEdge(typeDef, edgeRelations);
    }

    private void buildVertexTypes() {
        this.vertexTypes = new HashMap<LabelId, GraphVertex>();
        for (TypeDef typeDef : this.idToType.values()) {
            if (typeDef.getTypeEnum() != TypeEnum.VERTEX) continue;
            LabelId labelId = typeDef.getTypeLabelId();
            DefaultGraphVertex vertexType = this.getVertexType(typeDef);
            this.vertexTypes.put(labelId, vertexType);
        }
    }

    private DefaultGraphVertex getVertexType(TypeDef typeDef) {
        LabelId labelId = typeDef.getTypeLabelId();
        Long tableId = this.vertexTableIds.get(labelId);
        if (tableId == null) {
            throw new IllegalSchemaException("no valid table id for [" + typeDef.getLabel() + "]");
        }
        return new DefaultGraphVertex(typeDef, tableId);
    }

    public static GraphDef parseProto(GraphDefPb proto) {
        long version = proto.getVersion();
        HashMap<String, LabelId> labelToId = new HashMap<String, LabelId>();
        HashMap<LabelId, TypeDef> idToType = new HashMap<LabelId, TypeDef>();
        for (TypeDefPb typeDefPb : proto.getTypeDefsList()) {
            TypeDef typeDef = TypeDef.parseProto(typeDefPb);
            LabelId labelId = typeDef.getTypeLabelId();
            labelToId.put(typeDef.getLabel(), labelId);
            idToType.put(labelId, typeDef);
        }
        HashMap<LabelId, Set<EdgeKind>> idToKinds = new HashMap<LabelId, Set<EdgeKind>>();
        for (EdgeKindPb edgeKindPb : proto.getEdgeKindsList()) {
            LabelId edgeLabelId = LabelId.parseProto(edgeKindPb.getEdgeLabelId());
            LabelId srcLabelId = LabelId.parseProto(edgeKindPb.getSrcVertexLabelId());
            LabelId dstLabelId = LabelId.parseProto(edgeKindPb.getDstVertexLabelId());
            EdgeKind edgeKind = EdgeKind.newBuilder().setEdgeLabelId(edgeLabelId).setSrcVertexLabelId(srcLabelId).setDstVertexLabelId(dstLabelId).setEdgeLabel(((TypeDef)idToType.get(edgeLabelId)).getLabel()).setSrcVertexLabel(((TypeDef)idToType.get(srcLabelId)).getLabel()).setDstVertexLabel(((TypeDef)idToType.get(dstLabelId)).getLabel()).build();
            Set edgeKindSet = idToKinds.computeIfAbsent(edgeKind.getEdgeLabelId(), k -> new HashSet());
            edgeKindSet.add(edgeKind);
        }
        Map<String, Integer> map = proto.getPropertyNameToIdMap();
        int labelIdx = proto.getLabelIdx();
        int propertyIdx = proto.getPropertyIdx();
        HashMap<LabelId, Long> vertexTableIds = new HashMap<LabelId, Long>();
        for (VertexTableIdEntry vertexTableIdEntry : proto.getVertexTableIdsList()) {
            vertexTableIds.put(LabelId.parseProto(vertexTableIdEntry.getLabelId()), vertexTableIdEntry.getTableId());
        }
        HashMap<EdgeKind, Long> edgeTableIds = new HashMap<EdgeKind, Long>();
        for (EdgeTableIdEntry edgeTableIdEntry : proto.getEdgeTableIdsList()) {
            edgeTableIds.put(EdgeKind.parseProto(edgeTableIdEntry.getEdgeKind()), edgeTableIdEntry.getTableId());
        }
        long l = proto.getTableIdx();
        return new GraphDef(version, labelToId, idToType, idToKinds, map, labelIdx, propertyIdx, vertexTableIds, edgeTableIds, l);
    }

    public GraphDefPb toProto() {
        GraphDefPb.Builder builder = GraphDefPb.newBuilder();
        builder.setVersion(this.version);
        for (TypeDef typeDef : this.idToType.values()) {
            builder.addTypeDefs(typeDef.toProto());
        }
        for (Set set : this.idToKinds.values()) {
            for (EdgeKind edgeKind : set) {
                builder.addEdgeKinds(edgeKind.toProto());
            }
        }
        builder.putAllPropertyNameToId(this.propertyNameToId);
        builder.setLabelIdx(this.labelIdx);
        builder.setPropertyIdx(this.propertyIdx);
        this.vertexTableIds.forEach((k, v) -> builder.addVertexTableIds(VertexTableIdEntry.newBuilder().setLabelId(k.toProto()).setTableId((long)v).build()));
        this.edgeTableIds.forEach((k, v) -> builder.addEdgeTableIds(EdgeTableIdEntry.newBuilder().setEdgeKind(k.toProto()).setTableId((long)v).build()));
        builder.setTableIdx(this.tableIdx);
        return builder.build();
    }

    public TypeDef getTypeDef(String label) {
        LabelId labelId = this.labelToId.get(label);
        if (labelId == null) {
            throw new NotFoundException("no such label [" + label + "]");
        }
        return this.getTypeDef(labelId);
    }

    public TypeDef getTypeDef(LabelId labelId) {
        return this.idToType.get(labelId);
    }

    public boolean hasLabel(String label) {
        return this.labelToId.containsKey(label);
    }

    public LabelId getLabelId(String label) {
        return this.labelToId.get(label);
    }

    public boolean hasEdgeKind(EdgeKind edgeKind) {
        Set<EdgeKind> edgeKindSet = this.idToKinds.get(edgeKind.getEdgeLabelId());
        if (edgeKindSet == null) {
            return false;
        }
        return edgeKindSet.contains(edgeKind);
    }

    @Override
    public GraphElement getElement(String label) throws TypeNotFoundException {
        LabelId labelId = this.labelToId.get(label);
        if (labelId == null) {
            throw new TypeNotFoundException("schema element not found for label " + label);
        }
        return this.convertVertexEdgeType(this.idToType.get(labelId));
    }

    @Override
    public GraphElement getElement(int labelId) throws TypeNotFoundException {
        TypeDef typeDef = this.idToType.get(new LabelId(labelId));
        return this.convertVertexEdgeType(typeDef);
    }

    private GraphElement convertVertexEdgeType(TypeDef typeDef) {
        if (null == typeDef) {
            throw new InvalidArgumentException("No type def with given label id/name");
        }
        if (typeDef.getTypeEnum() == TypeEnum.VERTEX) {
            return this.getVertexType(typeDef);
        }
        if (typeDef.getTypeEnum() == TypeEnum.EDGE) {
            return this.getEdgeType(typeDef);
        }
        throw new InvalidArgumentException("Not support type value " + typeDef.getTypeEnum());
    }

    @Override
    public List<GraphVertex> getVertexList() {
        return new ArrayList<GraphVertex>(this.vertexTypes.values());
    }

    @Override
    public List<GraphEdge> getEdgeList() {
        return new ArrayList<GraphEdge>(this.edgeTypes.values());
    }

    @Override
    public Integer getPropertyId(String propertyName) throws PropertyNotFoundException {
        if (this.propertyNameToId.containsKey(propertyName)) {
            return this.propertyNameToId.get(propertyName);
        }
        throw new PropertyNotFoundException("property " + propertyName + " not exist");
    }

    @Override
    public String getPropertyName(int propertyId) throws PropertyNotFoundException {
        for (Map.Entry<String, Integer> entry : this.propertyNameToId.entrySet()) {
            if (entry.getValue() != propertyId) continue;
            return entry.getKey();
        }
        throw new PropertyNotFoundException("property not exist for property id " + propertyId);
    }

    @Override
    public Map<GraphElement, GraphProperty> getPropertyList(String propertyName) {
        HashMap<GraphElement, GraphProperty> elementToProperty = new HashMap<GraphElement, GraphProperty>();
        for (TypeDef typeDef : this.idToType.values()) {
            GraphProperty property = typeDef.getProperty(propertyName);
            if (property == null) continue;
            elementToProperty.put(typeDef, property);
        }
        return elementToProperty;
    }

    @Override
    public Map<GraphElement, GraphProperty> getPropertyList(int propId) {
        String propertyName = this.getPropertyName(propId);
        return this.getPropertyList(propertyName);
    }

    @Override
    public String getVersion() {
        return String.valueOf(this.version);
    }

    public long getSchemaVersion() {
        return this.version;
    }

    public Map<String, LabelId> getLabelToId() {
        return this.labelToId;
    }

    public Map<LabelId, TypeDef> getIdToType() {
        return this.idToType;
    }

    public Map<LabelId, Set<EdgeKind>> getIdToKinds() {
        return this.idToKinds;
    }

    public int getLabelIdx() {
        return this.labelIdx;
    }

    public int getPropertyIdx() {
        return this.propertyIdx;
    }

    public Map<String, Integer> getPropertyNameToId() {
        return this.propertyNameToId;
    }

    public Map<LabelId, Long> getVertexTableIds() {
        return this.vertexTableIds;
    }

    public Map<EdgeKind, Long> getEdgeTableIds() {
        return this.edgeTableIds;
    }

    public long getTableIdx() {
        return this.tableIdx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphDef graphDef = (GraphDef)o;
        String x = "";
        return this.version == graphDef.version && this.labelIdx == graphDef.labelIdx && this.propertyIdx == graphDef.propertyIdx && this.tableIdx == graphDef.tableIdx && Objects.equals(this.labelToId, graphDef.labelToId) && Objects.equals(this.idToType, graphDef.idToType) && Objects.equals(this.idToKinds, graphDef.idToKinds) && Objects.equals(this.propertyNameToId, graphDef.propertyNameToId) && Objects.equals(this.vertexTableIds, graphDef.vertexTableIds) && Objects.equals(this.edgeTableIds, graphDef.edgeTableIds) && Objects.equals(this.vertexTypes, graphDef.vertexTypes) && Objects.equals(this.edgeTypes, graphDef.edgeTypes);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.labelToId, this.idToType, this.idToKinds, this.propertyNameToId, this.labelIdx, this.propertyIdx, this.vertexTableIds, this.edgeTableIds, this.tableIdx, this.vertexTypes, this.edgeTypes);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(GraphDef graphDef) {
        return new Builder(graphDef);
    }

    public static class Builder {
        private long version;
        private Map<String, LabelId> labelToId;
        private Map<LabelId, TypeDef> idToType;
        private Map<LabelId, Set<EdgeKind>> idToKinds;
        private Map<String, Integer> propertyNameToId;
        private int labelIdx;
        private int propertyIdx;
        private Map<LabelId, Long> vertexTableIds;
        private Map<EdgeKind, Long> edgeTableIds;
        private long tableIdx;

        private Builder() {
            this.version = 0L;
            this.labelToId = new HashMap<String, LabelId>();
            this.idToType = new HashMap<LabelId, TypeDef>();
            this.idToKinds = new HashMap<LabelId, Set<EdgeKind>>();
            this.propertyNameToId = new HashMap<String, Integer>();
            this.labelIdx = 0;
            this.propertyIdx = 0;
            this.vertexTableIds = new HashMap<LabelId, Long>();
            this.edgeTableIds = new HashMap<EdgeKind, Long>();
            this.tableIdx = 0L;
        }

        private Builder(GraphDef graphDef) {
            this.version = graphDef.getSchemaVersion();
            this.labelToId = new HashMap<String, LabelId>(graphDef.getLabelToId());
            this.idToType = new HashMap<LabelId, TypeDef>(graphDef.getIdToType());
            this.idToKinds = new HashMap<LabelId, Set<EdgeKind>>(graphDef.getIdToKinds());
            this.propertyNameToId = new HashMap<String, Integer>(graphDef.getPropertyNameToId());
            this.labelIdx = graphDef.getLabelIdx();
            this.propertyIdx = graphDef.getPropertyIdx();
            this.vertexTableIds = new HashMap<LabelId, Long>(graphDef.getVertexTableIds());
            this.edgeTableIds = new HashMap<EdgeKind, Long>(graphDef.getEdgeTableIds());
            this.tableIdx = graphDef.getTableIdx();
        }

        public Builder setLabelIdx(int labelIdx) {
            this.labelIdx = labelIdx;
            return this;
        }

        public Builder setPropertyIdx(int propertyIdx) {
            this.propertyIdx = propertyIdx;
            return this;
        }

        public Builder putPropertyNameToId(String propertyName, int id) {
            this.propertyNameToId.put(propertyName, id);
            return this;
        }

        public Builder putVertexTableId(LabelId labelId, long tableId) {
            this.vertexTableIds.put(labelId, tableId);
            return this;
        }

        public Builder putEdgeTableId(EdgeKind edgeKind, long tableId) {
            this.edgeTableIds.put(edgeKind, tableId);
            return this;
        }

        public Builder setTableIdx(long tableIdx) {
            this.tableIdx = tableIdx;
            return this;
        }

        public Builder clearUnusedPropertyName(Set<String> usingPropertyNames) {
            HashSet<String> removePropertyNames = new HashSet<String>();
            for (String k2 : this.propertyNameToId.keySet()) {
                if (usingPropertyNames.contains(k2)) continue;
                removePropertyNames.add(k2);
            }
            removePropertyNames.forEach(k -> this.propertyNameToId.remove(k));
            return this;
        }

        public Builder addTypeDef(TypeDef typeDef) {
            LabelId labelId = typeDef.getTypeLabelId();
            this.labelToId.put(typeDef.getLabel(), labelId);
            this.idToType.put(labelId, typeDef);
            return this;
        }

        public Builder removeTypeDef(String label) {
            LabelId removedLabelId = this.labelToId.remove(label);
            this.idToType.remove(removedLabelId);
            this.vertexTableIds.remove(removedLabelId);
            return this;
        }

        public Builder addEdgeKind(EdgeKind edgeKind) {
            Set edgeKindSet = this.idToKinds.computeIfAbsent(edgeKind.getEdgeLabelId(), k -> new HashSet());
            edgeKindSet.add(edgeKind);
            return this;
        }

        public Builder removeEdgeKind(EdgeKind edgeKind) {
            LabelId edgeLabelId = edgeKind.getEdgeLabelId();
            Set<EdgeKind> edgeKindSet = this.idToKinds.get(edgeLabelId);
            if (edgeKindSet == null) {
                return this;
            }
            edgeKindSet.remove(edgeKind);
            this.edgeTableIds.remove(edgeKind);
            if (edgeKindSet.size() == 0) {
                this.idToKinds.remove(edgeLabelId);
            }
            return this;
        }

        public Builder setVersion(long version) {
            this.version = version;
            return this;
        }

        public Collection<TypeDef> getAllTypeDefs() {
            return this.idToType.values();
        }

        public GraphDef build() {
            return new GraphDef(this.version, this.labelToId, this.idToType, this.idToKinds, this.propertyNameToId, this.labelIdx, this.propertyIdx, this.vertexTableIds, this.edgeTableIds, this.tableIdx);
        }
    }
}

