/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.schema.wrapper;

import com.alibaba.graphscope.groot.common.schema.api.GraphElement;
import com.alibaba.graphscope.groot.common.schema.api.GraphProperty;
import com.alibaba.graphscope.groot.common.schema.wrapper.LabelId;
import com.alibaba.graphscope.groot.common.schema.wrapper.PropertyDef;
import com.alibaba.graphscope.groot.common.schema.wrapper.TypeEnum;
import com.alibaba.graphscope.proto.groot.PropertyDefPb;
import com.alibaba.graphscope.proto.groot.TypeDefPb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class TypeDef
implements GraphElement {
    private final int versionId;
    private final String label;
    private final LabelId labelId;
    private String comment = "";
    private final List<PropertyDef> properties;
    private final List<Integer> pkIdxs;
    private final Map<String, Integer> nameToIdx;
    private final Map<Integer, Integer> idToIdx;
    private final TypeEnum typeEnum;

    private TypeDef(TypeEnum typeEnum, int versionId, String label, LabelId labelId, List<PropertyDef> properties, String comment) {
        this.typeEnum = typeEnum;
        this.versionId = versionId;
        this.label = label;
        this.labelId = labelId;
        this.comment = comment;
        this.properties = new ArrayList<PropertyDef>(properties);
        this.pkIdxs = new ArrayList<Integer>();
        this.nameToIdx = new HashMap<String, Integer>();
        this.idToIdx = new HashMap<Integer, Integer>();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyDef propertyDef = this.properties.get(i);
            if (propertyDef.isPartOfPrimaryKey()) {
                this.pkIdxs.add(i);
            }
            this.nameToIdx.put(propertyDef.getName(), i);
            this.idToIdx.put(propertyDef.getId(), i);
        }
    }

    public List<Integer> getPkIdxs() {
        return Collections.unmodifiableList(this.pkIdxs);
    }

    @Override
    public int getVersionId() {
        return this.versionId;
    }

    @Override
    public List<GraphProperty> getPrimaryKeyList() {
        return this.pkIdxs.stream().map(i -> this.properties.get((int)i)).collect(Collectors.toList());
    }

    @Override
    public List<String> getPrimaryKeyNameList() {
        return this.pkIdxs.stream().map(i -> this.properties.get((int)i).getName()).collect(Collectors.toList());
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getLabelId() {
        return this.labelId.getId();
    }

    public String getComment() {
        return this.comment;
    }

    public LabelId getTypeLabelId() {
        return this.labelId;
    }

    @Override
    public List<GraphProperty> getPropertyList() {
        return new ArrayList<GraphProperty>(this.getProperties());
    }

    @Override
    public GraphProperty getProperty(int propId) {
        Integer idx = this.idToIdx.get(propId);
        if (idx == null) {
            return null;
        }
        return this.properties.get(idx);
    }

    @Override
    public GraphProperty getProperty(String propName) {
        Integer idx = this.nameToIdx.get(propName);
        if (idx == null) {
            return null;
        }
        return this.properties.get(idx);
    }

    public List<PropertyDef> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public TypeEnum getTypeEnum() {
        return this.typeEnum;
    }

    public static TypeDef parseProto(TypeDefPb proto) {
        int versionId = proto.getVersionId();
        String label = proto.getLabel();
        LabelId labelId = LabelId.parseProto(proto.getLabelId());
        ArrayList<PropertyDef> propertyDefs = new ArrayList<PropertyDef>();
        List<PropertyDefPb> propsList = proto.getPropsList();
        for (PropertyDefPb propertyDefPb : propsList) {
            propertyDefs.add(PropertyDef.parseProto(propertyDefPb));
        }
        TypeEnum typeEnum = TypeEnum.parseProto(proto.getTypeEnum());
        String comment = proto.getComment();
        return new TypeDef(typeEnum, versionId, label, labelId, propertyDefs, comment);
    }

    public TypeDefPb toProto() {
        TypeDefPb.Builder builder = TypeDefPb.newBuilder();
        builder.setVersionId(this.versionId);
        builder.setLabel(this.label);
        builder.setLabelId(this.labelId.toProto());
        for (PropertyDef property : this.properties) {
            builder.addProps(property.toProto());
        }
        builder.setTypeEnum(this.typeEnum.toProto());
        builder.setComment(this.comment);
        return builder.build();
    }

    public TypeDefPb toDdlProto() {
        TypeDefPb.Builder builder = TypeDefPb.newBuilder();
        builder.setLabel(this.label);
        builder.setVersionId(this.versionId);
        for (PropertyDef property : this.properties) {
            builder.addProps(property.toProto());
        }
        if (this.typeEnum != null) {
            builder.setTypeEnum(this.typeEnum.toProto());
        }
        builder.setComment(this.comment);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeDef typeDef = (TypeDef)o;
        return this.versionId == typeDef.versionId && Objects.equals(this.label, typeDef.label) && Objects.equals(this.labelId, typeDef.labelId) && Objects.equals(this.properties, typeDef.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.versionId, this.label, this.labelId, this.comment, this.properties, this.pkIdxs, this.nameToIdx, this.idToIdx, this.typeEnum});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(TypeDef typeDef) {
        return new Builder(typeDef);
    }

    public static class Builder {
        private int versionId;
        private String label;
        private LabelId labelId;
        private List<PropertyDef> properties = new ArrayList<PropertyDef>();
        private TypeEnum typeEnum;
        private String comment = "";

        private Builder() {
        }

        private Builder(TypeDef typeDef) {
            this.versionId = typeDef.getVersionId();
            this.label = typeDef.getLabel();
            this.labelId = typeDef.getTypeLabelId();
            this.properties = typeDef.getProperties();
            this.typeEnum = typeDef.typeEnum;
            this.comment = typeDef.getComment();
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setLabelId(LabelId labelId) {
            this.labelId = labelId;
            return this;
        }

        public Builder addPropertyDef(PropertyDef propertyDef) {
            this.properties.add(propertyDef);
            return this;
        }

        public Builder setPropertyDefs(List<PropertyDef> propertyDefs) {
            this.properties = propertyDefs;
            return this;
        }

        public Builder setTypeEnum(TypeEnum typeEnum) {
            this.typeEnum = typeEnum;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder setVersionId(int versionId) {
            this.versionId = versionId;
            return this;
        }

        public TypeDef build() {
            return new TypeDef(this.typeEnum, this.versionId, this.label, this.labelId, this.properties, this.comment);
        }
    }
}

