/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.util;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.Base64;
import java.util.concurrent.Executor;

public class BasicAuth
extends CallCredentials {
    public static final Metadata.Key<String> AUTH_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final String TOKEN_HEAD = "Basic ";
    private final String secret;

    public BasicAuth(String username, String password) {
        this.secret = Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier metadataApplier) {
        executor.execute(() -> {
            try {
                Metadata metadata = new Metadata();
                metadata.put(AUTH_KEY, (Object)(TOKEN_HEAD + this.secret));
                metadataApplier.apply(metadata);
            }
            catch (Throwable t) {
                metadataApplier.fail(Status.UNAUTHENTICATED.withCause(t));
            }
        });
    }

    public void thisUsesUnstableApi() {
    }
}

