/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.util;

import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcUtils {
    public static final Logger logger = LoggerFactory.getLogger(RpcUtils.class);

    public static Executor createGrpcExecutor(int threadCount) {
        logger.debug("create grpc executor, thread count [" + threadCount + "]");
        return new ForkJoinPool(threadCount, new ForkJoinPool.ForkJoinWorkerThreadFactory(){
            final AtomicInteger num = new AtomicInteger();

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                thread.setDaemon(true);
                thread.setName("grpc-worker--" + this.num.getAndIncrement());
                return thread;
            }
        }, (t, e) -> logger.error("Uncaught exception in thread {}", (Object)t.getName(), (Object)e), true);
    }
}

