/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.util;

import com.alibaba.graphscope.groot.common.schema.api.GraphEdge;
import com.alibaba.graphscope.groot.common.schema.api.GraphProperty;
import com.alibaba.graphscope.groot.common.schema.api.GraphSchema;
import com.alibaba.graphscope.groot.common.schema.api.GraphVertex;
import java.util.List;
import java.util.stream.Collectors;

public class SchemaUtils {
    public static List<Integer> getVertexPrimaryKeyList(GraphVertex vertexType) {
        return vertexType.getPrimaryKeyList().stream().map(GraphProperty::getId).collect(Collectors.toList());
    }

    public static List<Integer> getEdgePrimaryKeyList(GraphEdge edgeType) {
        if (edgeType.getPrimaryKeyList() == null) {
            return null;
        }
        return edgeType.getPrimaryKeyList().stream().map(GraphProperty::getId).collect(Collectors.toList());
    }

    public static boolean checkPropExist(String propName, GraphSchema schema) {
        try {
            schema.getPropertyId(propName);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static String getPropertyName(int propId, GraphSchema schema) {
        return schema.getPropertyName(propId);
    }

    public static int getPropId(String name, GraphSchema schema) {
        return schema.getPropertyId(name);
    }
}

