/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class ThreadFactoryUtils {
    public static ThreadFactory daemonThreadFactoryWithLogExceptionHandler(String namePrefix, Logger logger) {
        AtomicInteger threadNumber = new AtomicInteger(1);
        SecurityManager s = System.getSecurityManager();
        ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        return r -> {
            Thread thread = new Thread(group, r, namePrefix + "[#" + threadNumber.getAndIncrement() + "]", 0L);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((t, e) -> logger.error("uncaught exception in [" + namePrefix + "], thread [" + t.getName() + "]", e));
            return thread;
        };
    }
}

