from enum import Enum

import typing_extensions

class RequestMethod(str, Enum):
    GET = "GET"
    POST = "POST"
    PUT = "PUT"
    DELETE = "DELETE"

class StatusEndpoints(Enum):
    HEALTH = ...

class TranslateEndpoints(Enum):
    TRANSLATE_TEXT = ...
    TRANSLATE_FILE = ...

class WebEndpoints(Enum):
    SEARCH = ...

class FileEndpoints(Enum):
    PARSER = ...
    INDEX_CREATE = ...
    INDEX_ADD_FILES = ...
    INDEX_RESTORE = ...
    INDEX_RENAME = ...
    INDEX_DELETE_FILES = ...
    INDEX_DELETE = ...
    INDEX_ASK = ...
    INDEX_EMBED = ...
    INDEX_LIST = ...
    INDEX_DETAILS = ...

class LlmEndpoints(Enum):
    CHAT = ...
    CHAT_STREAM = ...
    EMBED = ...

class Endpoints:
    STATUS = StatusEndpoints
    WEB = WebEndpoints
    TRANSLATE = TranslateEndpoints
    FILES = FileEndpoints
    LLM = LlmEndpoints

CosmosEndpoints: typing_extensions.TypeAlias = (
    StatusEndpoints | WebEndpoints | TranslateEndpoints | FileEndpoints | LlmEndpoints
)
