"""Assets Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum, parse_union_result


class AgentType(str, Enum):
    """AgentType."""

    ENDPOINT_REDCLOAK = "ENDPOINT_REDCLOAK"
    ENDPOINT_CARBON_BLACK = "ENDPOINT_CARBON_BLACK"
    ENDPOINT_CROWD_STRIKE = "ENDPOINT_CROWD_STRIKE"
    ENDPOINT_MICROSOFT_ATP = "ENDPOINT_MICROSOFT_ATP"
    ENDPOINT_CARBON_BLACK_PSC = "ENDPOINT_CARBON_BLACK_PSC"


class AssetsOrderByInput(str, Enum):
    """AssetsOrderByInput."""

    HOSTNAME = "hostname"
    IP_ADDRESS = "ip_address"
    MAC_ADDRESS = "mac_address"
    TAG = "tag"
    USERNAME = "username"
    OS_VERSION = "os_version"
    ENDPOINT_TYPE = "endpoint_type"
    CREATED_AT = "created_at"
    UPDATED_AT = "updated_at"
    DELETED_AT = "deleted_at"
    OS_FAMILY = "os_family"
    OS_DISTRIBUTOR = "os_distributor"
    SENSOR_VERSION = "sensor_version"


class AssetsOrderDirectionInput(str, Enum):
    """AssetsOrderDirectionInput."""

    ASC = "asc"
    DESC = "desc"


class AssetStateFilter(str, Enum):
    """AssetStateFilter."""

    ALL = "All"
    DELETED = "Deleted"
    ACTIVE = "Active"
    UNHEALTHY = "Unhealthy"


class EndpointType(str, Enum):
    """EndpointType."""

    ENDPOINT_REDCLOAK = "ENDPOINT_REDCLOAK"
    ENDPOINT_THIRD_PARTY = "ENDPOINT_THIRD_PARTY"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointGroup:
    """EndpointGroup."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetHistory:
    """AssetHistory."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    asset_id: Optional[str] = field(default=None, metadata=config(field_name="assetId"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    action: Optional[str] = field(default=None, metadata=config(field_name="action"))
    who: Optional[str] = field(default=None, metadata=config(field_name="who"))
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetHistoryContact:
    """AssetHistoryContact."""

    email: Optional[str] = field(default=None, metadata=config(field_name="email"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    sub: Optional[str] = field(default=None, metadata=config(field_name="sub"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetHistoryEvent:
    """AssetHistoryEvent."""

    domain_name: Optional[str] = field(
        default=None, metadata=config(field_name="domainName")
    )
    host_name: Optional[str] = field(
        default=None, metadata=config(field_name="hostName")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetHistoryId:
    """AssetHistoryId."""

    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    instance_id: Optional[str] = field(
        default=None, metadata=config(field_name="instanceId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Hostname:
    """Hostname."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EthernetAddress:
    """EthernetAddress."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    mac: Optional[str] = field(default=None, metadata=config(field_name="mac"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class IpAddress:
    """IpAddress."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    ip: Optional[str] = field(default=None, metadata=config(field_name="ip"))
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class User:
    """User."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    username: Optional[str] = field(
        default=None, metadata=config(field_name="username")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class IgnitionDetails:
    """IgnitionDetails."""

    is_endpoint_config_exist: Optional[bool] = field(
        default=None, metadata=config(field_name="isEndpointConfigExist")
    )
    request_status: Optional[str] = field(
        default=None, metadata=config(field_name="requestStatus")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ModuleHealth:
    """ModuleHealth."""

    enabled: Optional[str] = field(default=None, metadata=config(field_name="enabled"))
    last_predicate_time: Optional[str] = field(
        default=None, metadata=config(field_name="lastPredicateTime")
    )
    last_running_time: Optional[str] = field(
        default=None, metadata=config(field_name="lastRunningTime")
    )
    module_color: Optional[str] = field(
        default=None, metadata=config(field_name="moduleColor")
    )
    module_display_name: Optional[str] = field(
        default=None, metadata=config(field_name="moduleDisplayName")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ModuleStatus:
    """ModuleStatus."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    module_name: Optional[str] = field(
        default=None, metadata=config(field_name="moduleName")
    )
    module_state: Optional[str] = field(
        default=None, metadata=config(field_name="moduleState")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SystemInformation:
    """SystemInformation."""

    architecture: Optional[str] = field(
        default=None, metadata=config(field_name="architecture")
    )
    bios_serial: Optional[str] = field(
        default=None, metadata=config(field_name="biosSerial")
    )
    ethernet_address: Optional[List[str]] = field(
        default=None, metadata=config(field_name="ethernetAddress")
    )
    first_disk_serial: Optional[str] = field(
        default=None, metadata=config(field_name="firstDiskSerial")
    )
    host_name: Optional[str] = field(
        default=None, metadata=config(field_name="hostName")
    )
    ip_address: Optional[List[str]] = field(
        default=None, metadata=config(field_name="ipAddress")
    )
    is_server_r2_for2003_and2008: Optional[bool] = field(
        default=None, metadata=config(field_name="isServerR2For2003And2008")
    )
    product_type: Optional[str] = field(
        default=None, metadata=config(field_name="productType")
    )
    redcloak_version: Optional[int] = field(
        default=None, metadata=config(field_name="redcloakVersion")
    )
    service_pack: Optional[str] = field(
        default=None, metadata=config(field_name="servicePack")
    )
    system_volume_serial: Optional[str] = field(
        default=None, metadata=config(field_name="systemVolumeSerial")
    )
    windows_version: Optional[str] = field(
        default=None, metadata=config(field_name="windowsVersion")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetCounts:
    """AssetCounts."""

    count: Optional[int] = field(default=None, metadata=config(field_name="count"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetCountsByEndpointType:
    """AssetCountsByEndpointType."""

    endpoint_type: Optional[str] = field(
        default=None, metadata=config(field_name="endpointType")
    )
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Tag:
    """Tag."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    tag: Optional[str] = field(default=None, metadata=config(field_name="tag"))
    key: Optional[str] = field(default=None, metadata=config(field_name="key"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateTag:
    """UpdateTag."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    tag: Optional[str] = field(default=None, metadata=config(field_name="tag"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetInput:
    """AssetInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetsExportOutput:
    """AssetsExportOutput."""

    column_def: Optional[List[str]] = field(
        default=None, metadata=config(field_name="columnDef")
    )
    rows: Optional[List[List[str]]] = field(
        default=None, metadata=config(field_name="rows")
    )
    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetsBySessionArguments:
    """AssetsBySessionArguments."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    offset: Optional[int] = field(default=None, metadata=config(field_name="offset"))
    limit: Optional[int] = field(default=None, metadata=config(field_name="limit"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SearchAssetsInput:
    """SearchAssetsInput."""

    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    ip_address: Optional[str] = field(
        default=None, metadata=config(field_name="ip_address")
    )
    mac_address: Optional[str] = field(
        default=None, metadata=config(field_name="mac_address")
    )
    os_version: Optional[str] = field(
        default=None, metadata=config(field_name="os_version")
    )
    os_family: Optional[str] = field(
        default=None, metadata=config(field_name="os_family")
    )
    os_distributor: Optional[str] = field(
        default=None, metadata=config(field_name="os_distributor")
    )
    sensor_version: Optional[str] = field(
        default=None, metadata=config(field_name="sensor_version")
    )
    username: Optional[str] = field(
        default=None, metadata=config(field_name="username")
    )
    endpoint_type: Optional[str] = field(
        default=None, metadata=config(field_name="endpoint_type")
    )
    tag: Optional[str] = field(default=None, metadata=config(field_name="tag"))
    host_id_partial_match: Optional[bool] = field(
        default=None, metadata=config(field_name="host_id_partial_match")
    )
    only_most_recent: Optional[bool] = field(
        default=None, metadata=config(field_name="only_most_recent")
    )
    or_search: Optional[bool] = field(
        default=None, metadata=config(field_name="or_search")
    )
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigation_id")
    )
    filter_asset_state: Optional[Union[AssetStateFilter, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AssetStateFilter, x),
            field_name="filter_asset_state",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SearchAssetsPaginationInput:
    """SearchAssetsPaginationInput."""

    offset: Optional[int] = field(default=None, metadata=config(field_name="offset"))
    limit: Optional[int] = field(default=None, metadata=config(field_name="limit"))
    order_by: Optional[Union[AssetsOrderByInput, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AssetsOrderByInput, x),
            field_name="order_by",
        ),
    )
    order_direction: Optional[Union[AssetsOrderDirectionInput, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AssetsOrderDirectionInput, x),
            field_name="order_direction",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetRedCloakHistory:
    """AssetRedCloakHistory."""

    action: Optional[str] = field(default=None, metadata=config(field_name="action"))
    allowed_domain: Optional[List[str]] = field(
        default=None, metadata=config(field_name="allowedDomain")
    )
    asset_id: Optional[str] = field(default=None, metadata=config(field_name="assetId"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    contact: Optional[AssetHistoryContact] = field(
        default=None, metadata=config(field_name="contact")
    )
    event: Optional[AssetHistoryEvent] = field(
        default=None, metadata=config(field_name="event")
    )
    id: Optional[AssetHistoryId] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointInfo:
    """EndpointInfo."""

    actual_isolation_status: Optional[bool] = field(
        default=None, metadata=config(field_name="actualIsolationStatus")
    )
    allowed_domain: Optional[List[str]] = field(
        default=None, metadata=config(field_name="allowedDomain")
    )
    color: Optional[str] = field(default=None, metadata=config(field_name="color"))
    desired_isolation_status: Optional[bool] = field(
        default=None, metadata=config(field_name="desiredIsolationStatus")
    )
    first_connect_time: Optional[str] = field(
        default=None, metadata=config(field_name="firstConnectTime")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    host_name: Optional[str] = field(
        default=None, metadata=config(field_name="hostName")
    )
    last_connect_address: Optional[str] = field(
        default=None, metadata=config(field_name="lastConnectAddress")
    )
    last_connect_server: Optional[str] = field(
        default=None, metadata=config(field_name="lastConnectServer")
    )
    last_connect_time: Optional[str] = field(
        default=None, metadata=config(field_name="lastConnectTime")
    )
    last_crash_check: Optional[str] = field(
        default=None, metadata=config(field_name="lastCrashCheck")
    )
    last_module_status_time: Optional[str] = field(
        default=None, metadata=config(field_name="lastModuleStatusTime")
    )
    last_predicate_authtap: Optional[str] = field(
        default=None, metadata=config(field_name="lastPredicateAuthtap")
    )
    last_predicate_cyclorama: Optional[str] = field(
        default=None, metadata=config(field_name="lastPredicateCyclorama")
    )
    last_predicate_entwine: Optional[str] = field(
        default=None, metadata=config(field_name="lastPredicateEntwine")
    )
    last_predicate_groundling: Optional[str] = field(
        default=None, metadata=config(field_name="lastPredicateGroundling")
    )
    last_predicate_hostel: Optional[str] = field(
        default=None, metadata=config(field_name="lastPredicateHostel")
    )
    last_predicate_lacuna: Optional[str] = field(
        default=None, metadata=config(field_name="lastPredicateLacuna")
    )
    last_predicate_mukluk: Optional[str] = field(
        default=None, metadata=config(field_name="lastPredicateMukluk")
    )
    last_predicate_periodicscan_control: Optional[str] = field(
        default=None, metadata=config(field_name="lastPredicatePeriodicscanControl")
    )
    last_predicate_periodicscan_result: Optional[str] = field(
        default=None, metadata=config(field_name="lastPredicatePeriodicscanResult")
    )
    last_predicate_procwall: Optional[str] = field(
        default=None, metadata=config(field_name="lastPredicateProcwall")
    )
    last_predicate_system_information: Optional[str] = field(
        default=None, metadata=config(field_name="lastPredicateSystemInformation")
    )
    notable_event_count: Optional[int] = field(
        default=None, metadata=config(field_name="notableEventCount")
    )
    sensor_version: Optional[int] = field(
        default=None, metadata=config(field_name="sensorVersion")
    )
    ignition_details: Optional[IgnitionDetails] = field(
        default=None, metadata=config(field_name="ignitionDetails")
    )
    module_health: Optional[List[ModuleHealth]] = field(
        default=None, metadata=config(field_name="moduleHealth")
    )
    module_status: Optional[List[ModuleStatus]] = field(
        default=None, metadata=config(field_name="moduleStatus")
    )
    system_information: Optional[SystemInformation] = field(
        default=None, metadata=config(field_name="systemInformation")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Asset:
    """Asset."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    rn: Optional[str] = field(default=None, metadata=config(field_name="rn"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    sensor_tenant: Optional[str] = field(
        default=None, metadata=config(field_name="sensorTenant")
    )
    sensor_id: Optional[str] = field(
        default=None, metadata=config(field_name="sensorId")
    )
    ingest_time: Optional[str] = field(
        default=None, metadata=config(field_name="ingestTime")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    deleted_at: Optional[str] = field(
        default=None, metadata=config(field_name="deletedAt")
    )
    last_seen_at: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeenAt")
    )
    bios_serial: Optional[str] = field(
        default=None, metadata=config(field_name="biosSerial")
    )
    first_disk_serial: Optional[str] = field(
        default=None, metadata=config(field_name="firstDiskSerial")
    )
    system_volume_serial: Optional[str] = field(
        default=None, metadata=config(field_name="systemVolumeSerial")
    )
    sensor_version: Optional[str] = field(
        default=None, metadata=config(field_name="sensorVersion")
    )
    endpoint_type: Optional[str] = field(
        default=None, metadata=config(field_name="endpointType")
    )
    endpoint_platform: Optional[str] = field(
        default=None, metadata=config(field_name="endpointPlatform")
    )
    architecture: Optional[str] = field(
        default=None, metadata=config(field_name="architecture")
    )
    os_family: Optional[str] = field(
        default=None, metadata=config(field_name="osFamily")
    )
    os_version: Optional[str] = field(
        default=None, metadata=config(field_name="osVersion")
    )
    os_distributor: Optional[str] = field(
        default=None, metadata=config(field_name="osDistributor")
    )
    os_release: Optional[str] = field(
        default=None, metadata=config(field_name="osRelease")
    )
    system_type: Optional[str] = field(
        default=None, metadata=config(field_name="systemType")
    )
    os_codename: Optional[str] = field(
        default=None, metadata=config(field_name="osCodename")
    )
    kernel_release: Optional[str] = field(
        default=None, metadata=config(field_name="kernelRelease")
    )
    kernel_version: Optional[str] = field(
        default=None, metadata=config(field_name="kernelVersion")
    )
    connection_status: Optional[str] = field(
        default=None, metadata=config(field_name="connectionStatus")
    )
    model: Optional[str] = field(default=None, metadata=config(field_name="model"))
    cloud_provider_name: Optional[str] = field(
        default=None, metadata=config(field_name="cloudProviderName")
    )
    cloud_instance_id: Optional[str] = field(
        default=None, metadata=config(field_name="cloudInstanceId")
    )
    status: Optional[str] = field(default=None, metadata=config(field_name="status"))
    hostnames: Optional[List[Hostname]] = field(
        default=None, metadata=config(field_name="hostnames")
    )
    ethernet_addresses: Optional[List[EthernetAddress]] = field(
        default=None, metadata=config(field_name="ethernetAddresses")
    )
    ip_addresses: Optional[List[IpAddress]] = field(
        default=None, metadata=config(field_name="ipAddresses")
    )
    users: Optional[List[User]] = field(
        default=None, metadata=config(field_name="users")
    )
    tags: Optional[List[Tag]] = field(default=None, metadata=config(field_name="tags"))
    endpoint_group: Optional[EndpointGroup] = field(
        default=None, metadata=config(field_name="endpointGroup")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetsResult:
    """AssetsResult."""

    total_results: Optional[int] = field(
        default=None, metadata=config(field_name="totalResults")
    )
    offset: Optional[int] = field(default=None, metadata=config(field_name="offset"))
    limit: Optional[int] = field(default=None, metadata=config(field_name="limit"))
    assets: Optional[List[Asset]] = field(
        default=None, metadata=config(field_name="assets")
    )
