"""Assets2 Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum, parse_union_result


class AssetState(str, Enum):
    """AssetState."""

    ALL = "All"
    ARCHIVED = "Archived"
    ACTIVE = "Active"
    UNHEALTHY = "Unhealthy"
    HEALTHY = "Healthy"


class EndpointTypeV2(str, Enum):
    """EndpointTypeV2."""

    ENDPOINT_REDCLOAK = "ENDPOINT_REDCLOAK"
    ENDPOINT_TAEGIS = "ENDPOINT_TAEGIS"
    ENDPOINT_CROWD_STRIKE = "ENDPOINT_CROWD_STRIKE"
    ENDPOINT_CARBON_BLACK = "ENDPOINT_CARBON_BLACK"
    ENDPOINT_CARBON_BLACK_PSC = "ENDPOINT_CARBON_BLACK_PSC"
    ENDPOINT_MICROSOFT_ATP = "ENDPOINT_MICROSOFT_ATP"
    ENDPOINT_SENTINELONE = "ENDPOINT_SENTINELONE"
    ENDPOINT_HARFANG_LAB = "ENDPOINT_HARFANG_LAB"
    ENDPOINT_SOPHOS_CIXA = "ENDPOINT_SOPHOS_CIXA"


class FacetInfoOrderByInputV2(str, Enum):
    """FacetInfoOrderByInputV2."""

    COUNT_DESC = "count_desc"
    COUNT_ASC = "count_asc"


class AssetSearchOrderByInputV2(str, Enum):
    """AssetSearchOrderByInputV2."""

    OS_VERSION_ASC = "os_version_asc"
    OS_VERSION_DESC = "os_version_desc"
    CREATED_AT_ASC = "created_at_asc"
    CREATED_AT_DESC = "created_at_desc"
    UPDATED_AT_ASC = "updated_at_asc"
    UPDATED_AT_DESC = "updated_at_desc"
    OS_FAMILY_ASC = "os_family_asc"
    OS_FAMILY_DESC = "os_family_desc"
    OS_DISTRIBUTOR_ASC = "os_distributor_asc"
    OS_DISTRIBUTOR_DESC = "os_distributor_desc"
    SENSOR_VERSION_ASC = "sensor_version_asc"
    SENSOR_VERSION_DESC = "sensor_version_desc"
    HOSTNAME_ASC = "hostname_asc"
    HOSTNAME_DESC = "hostname_desc"
    CONNECTION_STATUS_ASC = "connection_status_asc"
    CONNECTION_STATUS_DESC = "connection_status_desc"
    ISOLATION_STATUS_ASC = "isolation_status_asc"
    ISOLATION_STATUS_DESC = "isolation_status_desc"
    DESIRED_ISOLATION_STATUS_ASC = "desired_isolation_status_asc"
    DESIRED_ISOLATION_STATUS_DESC = "desired_isolation_status_desc"
    IP_ADDRESS_ASC = "ip_address_asc"
    IP_ADDRESS_DESC = "ip_address_desc"
    ENDPOINT_TYPE_ASC = "endpoint_type_asc"
    ENDPOINT_TYPE_DESC = "endpoint_type_desc"
    LAST_SEEN_ASC = "last_seen_asc"
    LAST_SEEN_DESC = "last_seen_desc"
    ETHERNET_ADDRESSES_ASC = "ethernet_addresses_asc"
    ETHERNET_ADDRESSES_DESC = "ethernet_addresses_desc"
    SYSTEM_TYPE_ASC = "system_type_asc"
    SYSTEM_TYPE_DESC = "system_type_desc"
    GROUP_ASC = "group_asc"
    GROUP_DESC = "group_desc"
    TAG_KEY_ASC = "tag_key_asc"
    TAG_KEY_DESC = "tag_key_desc"
    TAG_VALUE_ASC = "tag_value_asc"
    TAG_VALUE_DESC = "tag_value_desc"
    TAG_ASC = "tag_asc"
    TAG_DESC = "tag_desc"
    VULNERABILITY_STATUS_ASC = "vulnerability_status_asc"
    VULNERABILITY_STATUS_DESC = "vulnerability_status_desc"


class AssetHostnameSearchOrderByInput(str, Enum):
    """AssetHostnameSearchOrderByInput."""

    CREATED_AT_ASC = "created_at_asc"
    CREATED_AT_DESC = "created_at_desc"
    UPDATED_AT_ASC = "updated_at_asc"
    UPDATED_AT_DESC = "updated_at_desc"
    LAST_SEEN_AT_ASC = "last_seen_at_asc"
    LAST_SEEN_AT_DESC = "last_seen_at_desc"
    HOSTNAME_ASC = "hostname_asc"
    HOSTNAME_DESC = "hostname_desc"


class AssetIPAddressSearchOrderByInput(str, Enum):
    """AssetIPAddressSearchOrderByInput."""

    CREATED_AT_ASC = "created_at_asc"
    CREATED_AT_DESC = "created_at_desc"
    UPDATED_AT_ASC = "updated_at_asc"
    UPDATED_AT_DESC = "updated_at_desc"
    LAST_SEEN_AT_ASC = "last_seen_at_asc"
    LAST_SEEN_AT_DESC = "last_seen_at_desc"
    IP_ASC = "ip_asc"
    IP_DESC = "ip_desc"


class AssetMacAddressSearchOrderByInput(str, Enum):
    """AssetMacAddressSearchOrderByInput."""

    CREATED_AT_ASC = "created_at_asc"
    CREATED_AT_DESC = "created_at_desc"
    UPDATED_AT_ASC = "updated_at_asc"
    UPDATED_AT_DESC = "updated_at_desc"
    LAST_SEEN_AT_ASC = "last_seen_at_asc"
    LAST_SEEN_AT_DESC = "last_seen_at_desc"
    MAC_ASC = "mac_asc"
    MAC_DESC = "mac_desc"


class InvestigationsOrderByInput(str, Enum):
    """InvestigationsOrderByInput."""

    CREATED_AT_ASC = "created_at_asc"
    CREATED_AT_DESC = "created_at_desc"


class CanIsolateResponse(str, Enum):
    """CanIsolateResponse."""

    UNAUTHORIZED = "unauthorized"
    AUTHORIZED = "authorized"
    ALWAYS = "always"


class BulkOpStatusV2(str, Enum):
    """BulkOpStatusV2."""

    TASK_STATE_PENDING = "TASK_STATE_PENDING"
    TASK_STATE_FAILED = "TASK_STATE_FAILED"
    TASK_STATE_COMPLETED = "TASK_STATE_COMPLETED"
    TASK_STATE_IN_PROGRESS = "TASK_STATE_IN_PROGRESS"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ConnectionDetails:
    """ConnectionDetails."""

    connection_status: Optional[str] = field(
        default=None, metadata=config(field_name="connectionStatus")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    last_connected_ts: Optional[str] = field(
        default=None, metadata=config(field_name="lastConnectedTS")
    )
    last_disconnected_ts: Optional[str] = field(
        default=None, metadata=config(field_name="lastDisconnectedTS")
    )
    last_disconnect_reason: Optional[str] = field(
        default=None, metadata=config(field_name="lastDisconnectReason")
    )
    last_seen_at: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeenAt")
    )
    using_ssl: Optional[bool] = field(
        default=None, metadata=config(field_name="usingSSL")
    )
    remote_ip: Optional[str] = field(
        default=None, metadata=config(field_name="remoteIP")
    )
    remote_port: Optional[int] = field(
        default=None, metadata=config(field_name="remotePort")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FileAnalysis:
    """FileAnalysis."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AutoArchive:
    """AutoArchive."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    period: Optional[int] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use periodDays"},
            field_name="period",
        ),
    )
    period_days: Optional[int] = field(
        default=None, metadata=config(field_name="periodDays")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TamperProtection:
    """TamperProtection."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AdvancedKernelTelemetry:
    """AdvancedKernelTelemetry."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class MaintenanceWindow:
    """MaintenanceWindow."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VulnerabilityDetails:
    """VulnerabilityDetails."""

    high_cps: Optional[str] = field(default=None, metadata=config(field_name="highCps"))
    high_cvss: Optional[str] = field(
        default=None, metadata=config(field_name="highCvss")
    )
    vulnerability_status: Optional[str] = field(
        default=None, metadata=config(field_name="vulnerabilityStatus")
    )
    vdr_instance: Optional[str] = field(
        default=None, metadata=config(field_name="vdrInstance")
    )
    vdr_asset_id: Optional[str] = field(
        default=None, metadata=config(field_name="vdrAssetId")
    )
    vdr_organization_id: Optional[str] = field(
        default=None, metadata=config(field_name="vdrOrganizationId")
    )
    vdr_hostname: Optional[str] = field(
        default=None, metadata=config(field_name="vdrHostname")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointGroupV2:
    """EndpointGroupV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class HostnameV2:
    """HostnameV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EthernetAddressV2:
    """EthernetAddressV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    mac: Optional[str] = field(default=None, metadata=config(field_name="mac"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class IpAddressV2:
    """IpAddressV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    ip: Optional[str] = field(default=None, metadata=config(field_name="ip"))
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UserV2:
    """UserV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    username: Optional[str] = field(
        default=None, metadata=config(field_name="username")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TagV2:
    """TagV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    tag: Optional[str] = field(default=None, metadata=config(field_name="tag"))
    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))
    is_vendor_tag: Optional[bool] = field(
        default=None, metadata=config(field_name="isVendorTag")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetInvestigation:
    """AssetInvestigation."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FacetV2:
    """FacetV2."""

    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    facet: Optional[str] = field(default=None, metadata=config(field_name="facet"))
    search_only: Optional[bool] = field(
        default=None, metadata=config(field_name="searchOnly")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FacetFieldInfoV2:
    """FacetFieldInfoV2."""

    field_: Optional[str] = field(default=None, metadata=config(field_name="field"))
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TagWhereInputV2:
    """TagWhereInputV2."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    key_contains: Optional[str] = field(
        default=None, metadata=config(field_name="key_contains")
    )
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))
    value_contains: Optional[str] = field(
        default=None, metadata=config(field_name="value_contains")
    )
    tag: Optional[str] = field(default=None, metadata=config(field_name="tag"))
    tag_contains: Optional[str] = field(
        default=None, metadata=config(field_name="tag_contains")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PageInfoV2:
    """PageInfoV2."""

    end_cursor: Optional[str] = field(
        default=None, metadata=config(field_name="endCursor")
    )
    start_cursor: Optional[str] = field(
        default=None, metadata=config(field_name="startCursor")
    )
    has_next_page: Optional[bool] = field(
        default=None, metadata=config(field_name="hasNextPage")
    )
    has_previous_page: Optional[bool] = field(
        default=None, metadata=config(field_name="hasPreviousPage")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetHostname:
    """AssetHostname."""

    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    deleted_at: Optional[str] = field(
        default=None, metadata=config(field_name="deletedAt")
    )
    last_seen_at: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt"},
            field_name="lastSeenAt",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetIPAddress:
    """AssetIPAddress."""

    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    ip: Optional[str] = field(default=None, metadata=config(field_name="ip"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    deleted_at: Optional[str] = field(
        default=None, metadata=config(field_name="deletedAt")
    )
    last_seen_at: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt"},
            field_name="lastSeenAt",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetMacAddress:
    """AssetMacAddress."""

    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    mac: Optional[str] = field(default=None, metadata=config(field_name="mac"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    deleted_at: Optional[str] = field(
        default=None, metadata=config(field_name="deletedAt")
    )
    last_seen_at: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt"},
            field_name="lastSeenAt",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class KVTagInputV2:
    """KVTagInputV2."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TaskInfoMetadata:
    """TaskInfoMetadata."""

    num_endpoints: Optional[int] = field(
        default=None, metadata=config(field_name="numEndpoints")
    )
    num_succeeded: Optional[int] = field(
        default=None, metadata=config(field_name="numSucceeded")
    )
    num_failed: Optional[int] = field(
        default=None, metadata=config(field_name="numFailed")
    )
    sync_succeeded: Optional[bool] = field(
        default=None, metadata=config(field_name="syncSucceeded")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FacetInfoV2:
    """FacetInfoV2."""

    facet: Optional[str] = field(default=None, metadata=config(field_name="facet"))
    fields: Optional[List[FacetFieldInfoV2]] = field(
        default=None, metadata=config(field_name="fields")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateTagsForEndpointInputV2:
    """UpdateTagsForEndpointInputV2."""

    endpoint_id: Optional[str] = field(
        default=None, metadata=config(field_name="endpointId")
    )
    tags: Optional[List[KVTagInputV2]] = field(
        default=None, metadata=config(field_name="tags")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BulkOpPayloadV2:
    """BulkOpPayloadV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    status: Optional[Union[BulkOpStatusV2, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(BulkOpStatusV2, x),
            field_name="status",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetsExportOutputV2:
    """AssetsExportOutputV2."""

    column_def: Optional[List[str]] = field(
        default=None, metadata=config(field_name="columnDef")
    )
    rows: Optional[List[List[str]]] = field(
        default=None, metadata=config(field_name="rows")
    )
    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    page_info: Optional[PageInfoV2] = field(
        default=None, metadata=config(field_name="pageInfo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TagFilter:
    """TagFilter."""

    endpoint_types: Optional[List[Union[EndpointTypeV2, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EndpointTypeV2, x),
            field_name="endpointTypes",
        ),
    )
    where: Optional[TagWhereInputV2] = field(
        default=None, metadata=config(field_name="where")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetsHostname:
    """AssetsHostname."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    assets_hostnames: Optional[List[AssetHostname]] = field(
        default=None, metadata=config(field_name="assetsHostnames")
    )
    page_info: Optional[PageInfoV2] = field(
        default=None, metadata=config(field_name="pageInfo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetsIPAddress:
    """AssetsIPAddress."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    assets_ip_addresses: Optional[List[AssetIPAddress]] = field(
        default=None, metadata=config(field_name="assetsIPAddresses")
    )
    page_info: Optional[PageInfoV2] = field(
        default=None, metadata=config(field_name="pageInfo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetsMacAddress:
    """AssetsMacAddress."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    assets_mac_addresses: Optional[List[AssetMacAddress]] = field(
        default=None, metadata=config(field_name="assetsMacAddresses")
    )
    page_info: Optional[PageInfoV2] = field(
        default=None, metadata=config(field_name="pageInfo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TaskInfoPayload:
    """TaskInfoPayload."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    status: Optional[Union[BulkOpStatusV2, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(BulkOpStatusV2, x),
            field_name="status",
        ),
    )
    metadata: Optional[TaskInfoMetadata] = field(
        default=None, metadata=config(field_name="metadata")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetHostnameWhereInput:
    """AssetHostnameWhereInput."""

    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_at_lt: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_lt")
    )
    created_at_lte: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_lte")
    )
    created_at_gt: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_gt")
    )
    created_at_gte: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_gte")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    host_id_contains: Optional[str] = field(
        default=None, metadata=config(field_name="hostId_contains")
    )
    host_id_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="hostId_autocomplete")
    )
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )
    hostname_contains: Optional[str] = field(
        default=None, metadata=config(field_name="hostname_contains")
    )
    hostname_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="hostname_autocomplete")
    )
    last_seen_at: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt"},
            field_name="lastSeenAt",
        ),
    )
    last_seen_at_lt: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt_lt"},
            field_name="lastSeenAt_lt",
        ),
    )
    last_seen_at_lte: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt_lte"},
            field_name="lastSeenAt_lte",
        ),
    )
    last_seen_at_gt: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt_gt"},
            field_name="lastSeenAt_gt",
        ),
    )
    last_seen_at_gte: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt_gte"},
            field_name="lastSeenAt_gte",
        ),
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    updated_at_lt: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_lt")
    )
    updated_at_lte: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_lte")
    )
    updated_at_gt: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_gt")
    )
    updated_at_gte: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_gte")
    )
    and_: Optional[List["AssetHostnameWhereInput"]] = field(
        default=None, metadata=config(field_name="and")
    )
    or_: Optional[List["AssetHostnameWhereInput"]] = field(
        default=None, metadata=config(field_name="or")
    )
    not_: Optional["AssetHostnameWhereInput"] = field(
        default=None, metadata=config(field_name="not")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetIPAddressWhereInput:
    """AssetIPAddressWhereInput."""

    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_at_lt: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_lt")
    )
    created_at_lte: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_lte")
    )
    created_at_gt: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_gt")
    )
    created_at_gte: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_gte")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    host_id_contains: Optional[str] = field(
        default=None, metadata=config(field_name="hostId_contains")
    )
    host_id_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="hostId_autocomplete")
    )
    ip: Optional[str] = field(default=None, metadata=config(field_name="ip"))
    ip_contains: Optional[str] = field(
        default=None, metadata=config(field_name="ip_contains")
    )
    ip_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="ip_autocomplete")
    )
    last_seen_at: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt"},
            field_name="lastSeenAt",
        ),
    )
    last_seen_at_lt: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt_lt"},
            field_name="lastSeenAt_lt",
        ),
    )
    last_seen_at_lte: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt_lte"},
            field_name="lastSeenAt_lte",
        ),
    )
    last_seen_at_gt: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt_gt"},
            field_name="lastSeenAt_gt",
        ),
    )
    last_seen_at_gte: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt_gte"},
            field_name="lastSeenAt_gte",
        ),
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    updated_at_lt: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_lt")
    )
    updated_at_lte: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_lte")
    )
    updated_at_gt: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_gt")
    )
    updated_at_gte: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_gte")
    )
    and_: Optional[List["AssetIPAddressWhereInput"]] = field(
        default=None, metadata=config(field_name="and")
    )
    or_: Optional[List["AssetIPAddressWhereInput"]] = field(
        default=None, metadata=config(field_name="or")
    )
    not_: Optional["AssetIPAddressWhereInput"] = field(
        default=None, metadata=config(field_name="not")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetMacAddressWhereInput:
    """AssetMacAddressWhereInput."""

    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_at_lt: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_lt")
    )
    created_at_lte: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_lte")
    )
    created_at_gt: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_gt")
    )
    created_at_gte: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_gte")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    host_id_contains: Optional[str] = field(
        default=None, metadata=config(field_name="hostId_contains")
    )
    host_id_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="hostId_autocomplete")
    )
    mac: Optional[str] = field(default=None, metadata=config(field_name="mac"))
    mac_contains: Optional[str] = field(
        default=None, metadata=config(field_name="mac_contains")
    )
    mac_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="mac_autocomplete")
    )
    last_seen_at: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt"},
            field_name="lastSeenAt",
        ),
    )
    last_seen_at_lt: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt_lt"},
            field_name="lastSeenAt_lt",
        ),
    )
    last_seen_at_lte: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt_lte"},
            field_name="lastSeenAt_lte",
        ),
    )
    last_seen_at_gt: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt_gt"},
            field_name="lastSeenAt_gt",
        ),
    )
    last_seen_at_gte: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedAt_gte"},
            field_name="lastSeenAt_gte",
        ),
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    updated_at_lt: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_lt")
    )
    updated_at_lte: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_lte")
    )
    updated_at_gt: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_gt")
    )
    updated_at_gte: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_gte")
    )
    and_: Optional[List["AssetMacAddressWhereInput"]] = field(
        default=None, metadata=config(field_name="and")
    )
    or_: Optional[List["AssetMacAddressWhereInput"]] = field(
        default=None, metadata=config(field_name="or")
    )
    not_: Optional["AssetMacAddressWhereInput"] = field(
        default=None, metadata=config(field_name="not")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AgentSettings:
    """AgentSettings."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    is_default: Optional[bool] = field(
        default=None, metadata=config(field_name="isDefault")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    policy_name: Optional[str] = field(
        default=None, metadata=config(field_name="policyName")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    channel: Optional[str] = field(default=None, metadata=config(field_name="channel"))
    skip_upgrade: Optional[bool] = field(
        default=None, metadata=config(field_name="skipUpgrade")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    file_analysis: Optional[FileAnalysis] = field(
        default=None, metadata=config(field_name="fileAnalysis")
    )
    auto_archive: Optional[AutoArchive] = field(
        default=None, metadata=config(field_name="autoArchive")
    )
    tamper_protection: Optional[TamperProtection] = field(
        default=None, metadata=config(field_name="tamperProtection")
    )
    maintenance_window: Optional[MaintenanceWindow] = field(
        default=None, metadata=config(field_name="maintenanceWindow")
    )
    advanced_kernel_telemetry: Optional[AdvancedKernelTelemetry] = field(
        default=None, metadata=config(field_name="advancedKernelTelemetry")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetWhereInputV2:
    """AssetWhereInputV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    agent_setting_id: Optional[str] = field(
        default=None, metadata=config(field_name="agentSettingID")
    )
    agent_setting_id_contains: Optional[str] = field(
        default=None, metadata=config(field_name="agentSettingID_contains")
    )
    agent_setting_id_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="agentSettingID_autocomplete")
    )
    cloud_instance_id: Optional[str] = field(
        default=None, metadata=config(field_name="cloudInstanceId")
    )
    cloud_instance_id_contains: Optional[str] = field(
        default=None, metadata=config(field_name="cloudInstanceId_contains")
    )
    cloud_instance_id_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="cloudInstanceId_autocomplete")
    )
    connection_status: Optional[str] = field(
        default=None, metadata=config(field_name="connectionStatus")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_at_lt: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_lt")
    )
    created_at_lte: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_lte")
    )
    created_at_gt: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_gt")
    )
    created_at_gte: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt_gte")
    )
    desired_isolation_status: Optional[str] = field(
        default=None, metadata=config(field_name="desiredIsolationStatus")
    )
    group_name: Optional[str] = field(
        default=None, metadata=config(field_name="groupName")
    )
    group_name_contains: Optional[str] = field(
        default=None, metadata=config(field_name="groupName_contains")
    )
    group_name_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="groupName_autocomplete")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    host_id_contains: Optional[str] = field(
        default=None, metadata=config(field_name="hostId_contains")
    )
    host_id_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="hostId_autocomplete")
    )
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )
    hostname_contains: Optional[str] = field(
        default=None, metadata=config(field_name="hostname_contains")
    )
    hostname_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="hostname_autocomplete")
    )
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    investigation_id_contains: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId_contains")
    )
    investigation_id_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId_autocomplete")
    )
    ip_address: Optional[str] = field(
        default=None, metadata=config(field_name="ipAddress")
    )
    ip_address_contains: Optional[str] = field(
        default=None, metadata=config(field_name="ipAddress_contains")
    )
    ip_address_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="ipAddress_autocomplete")
    )
    isolation_status: Optional[str] = field(
        default=None, metadata=config(field_name="isolationStatus")
    )
    last_seen_at: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeenAt")
    )
    last_seen_at_lt: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeenAt_lt")
    )
    last_seen_at_lte: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeenAt_lte")
    )
    last_seen_at_gt: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeenAt_gt")
    )
    last_seen_at_gte: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeenAt_gte")
    )
    mac_address: Optional[str] = field(
        default=None, metadata=config(field_name="macAddress")
    )
    mac_address_contains: Optional[str] = field(
        default=None, metadata=config(field_name="macAddress_contains")
    )
    mac_address_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="macAddress_autocomplete")
    )
    os_distributor: Optional[str] = field(
        default=None, metadata=config(field_name="osDistributor")
    )
    os_family: Optional[str] = field(
        default=None, metadata=config(field_name="osFamily")
    )
    os_version: Optional[str] = field(
        default=None, metadata=config(field_name="osVersion")
    )
    os_version_normalized: Optional[str] = field(
        default=None, metadata=config(field_name="osVersionNormalized")
    )
    os_version_normalized_contains: Optional[str] = field(
        default=None, metadata=config(field_name="osVersionNormalized_contains")
    )
    os_version_normalized_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="osVersionNormalized_autocomplete")
    )
    sensor_version: Optional[str] = field(
        default=None, metadata=config(field_name="sensorVersion")
    )
    system_type: Optional[str] = field(
        default=None, metadata=config(field_name="systemType")
    )
    un_installable: Optional[bool] = field(
        default=None, metadata=config(field_name="unInstallable")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    updated_at_lt: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_lt")
    )
    updated_at_lte: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_lte")
    )
    updated_at_gt: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_gt")
    )
    updated_at_gte: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt_gte")
    )
    username: Optional[str] = field(
        default=None, metadata=config(field_name="username")
    )
    username_contains: Optional[str] = field(
        default=None, metadata=config(field_name="username_contains")
    )
    username_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="username_autocomplete")
    )
    vulnerability_status: Optional[str] = field(
        default=None, metadata=config(field_name="vulnerabilityStatus")
    )
    vulnerability_status_contains: Optional[str] = field(
        default=None, metadata=config(field_name="vulnerabilityStatus_contains")
    )
    vulnerability_status_autocomplete: Optional[str] = field(
        default=None, metadata=config(field_name="vulnerabilityStatus_autocomplete")
    )
    and_: Optional[List["AssetWhereInputV2"]] = field(
        default=None, metadata=config(field_name="and")
    )
    or_: Optional[List["AssetWhereInputV2"]] = field(
        default=None, metadata=config(field_name="or")
    )
    not_: Optional["AssetWhereInputV2"] = field(
        default=None, metadata=config(field_name="not")
    )
    tags: Optional[TagWhereInputV2] = field(
        default=None, metadata=config(field_name="tags")
    )
    tags_contains: Optional[TagWhereInputV2] = field(
        default=None, metadata=config(field_name="tags_contains")
    )
    tags_autocomplete: Optional[TagWhereInputV2] = field(
        default=None, metadata=config(field_name="tags_autocomplete")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetV2:
    """AssetV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    rn: Optional[str] = field(default=None, metadata=config(field_name="rn"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    sensor_tenant: Optional[str] = field(
        default=None, metadata=config(field_name="sensorTenant")
    )
    sensor_id: Optional[str] = field(
        default=None, metadata=config(field_name="sensorId")
    )
    ingest_time: Optional[str] = field(
        default=None, metadata=config(field_name="ingestTime")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    deleted_at: Optional[str] = field(
        default=None, metadata=config(field_name="deletedAt")
    )
    last_seen_at: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeenAt")
    )
    bios_serial: Optional[str] = field(
        default=None, metadata=config(field_name="biosSerial")
    )
    first_disk_serial: Optional[str] = field(
        default=None, metadata=config(field_name="firstDiskSerial")
    )
    system_volume_serial: Optional[str] = field(
        default=None, metadata=config(field_name="systemVolumeSerial")
    )
    sensor_version: Optional[str] = field(
        default=None, metadata=config(field_name="sensorVersion")
    )
    endpoint_type: Optional[str] = field(
        default=None, metadata=config(field_name="endpointType")
    )
    endpoint_platform: Optional[str] = field(
        default=None, metadata=config(field_name="endpointPlatform")
    )
    architecture: Optional[str] = field(
        default=None, metadata=config(field_name="architecture")
    )
    os_family: Optional[str] = field(
        default=None, metadata=config(field_name="osFamily")
    )
    os_version: Optional[str] = field(
        default=None, metadata=config(field_name="osVersion")
    )
    os_version_normalized: Optional[str] = field(
        default=None, metadata=config(field_name="osVersionNormalized")
    )
    os_distributor: Optional[str] = field(
        default=None, metadata=config(field_name="osDistributor")
    )
    os_release: Optional[str] = field(
        default=None, metadata=config(field_name="osRelease")
    )
    system_type: Optional[str] = field(
        default=None, metadata=config(field_name="systemType")
    )
    os_codename: Optional[str] = field(
        default=None, metadata=config(field_name="osCodename")
    )
    kernel_release: Optional[str] = field(
        default=None, metadata=config(field_name="kernelRelease")
    )
    kernel_version: Optional[str] = field(
        default=None, metadata=config(field_name="kernelVersion")
    )
    connection_status: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "use connectionDetails.connectionStatus",
            },
            field_name="connectionStatus",
        ),
    )
    isolation_status: Optional[str] = field(
        default=None, metadata=config(field_name="isolationStatus")
    )
    desired_isolation_status: Optional[str] = field(
        default=None, metadata=config(field_name="desiredIsolationStatus")
    )
    model: Optional[str] = field(default=None, metadata=config(field_name="model"))
    cloud_provider_name: Optional[str] = field(
        default=None, metadata=config(field_name="cloudProviderName")
    )
    cloud_instance_id: Optional[str] = field(
        default=None, metadata=config(field_name="cloudInstanceId")
    )
    status: Optional[str] = field(default=None, metadata=config(field_name="status"))
    un_installable: Optional[bool] = field(
        default=None, metadata=config(field_name="unInstallable")
    )
    agent_policy_version: Optional[str] = field(
        default=None, metadata=config(field_name="agentPolicyVersion")
    )
    uninstall: Optional[bool] = field(
        default=None, metadata=config(field_name="uninstall")
    )
    hostnames: Optional[List[HostnameV2]] = field(
        default=None, metadata=config(field_name="hostnames")
    )
    ethernet_addresses: Optional[List[EthernetAddressV2]] = field(
        default=None, metadata=config(field_name="ethernetAddresses")
    )
    ip_addresses: Optional[List[IpAddressV2]] = field(
        default=None, metadata=config(field_name="ipAddresses")
    )
    users: Optional[List[UserV2]] = field(
        default=None, metadata=config(field_name="users")
    )
    tags: Optional[List[TagV2]] = field(
        default=None, metadata=config(field_name="tags")
    )
    endpoint_group: Optional[EndpointGroupV2] = field(
        default=None, metadata=config(field_name="endpointGroup")
    )
    investigations: Optional[List[AssetInvestigation]] = field(
        default=None, metadata=config(field_name="investigations")
    )
    vulnerability_details: Optional[VulnerabilityDetails] = field(
        default=None, metadata=config(field_name="vulnerabilityDetails")
    )
    agent_settings: Optional[AgentSettings] = field(
        default=None, metadata=config(field_name="agentSettings")
    )
    connection_details: Optional[ConnectionDetails] = field(
        default=None, metadata=config(field_name="connectionDetails")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BulkReconnectNativeAssetsInput:
    """BulkReconnectNativeAssetsInput."""

    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    where: Optional[AssetWhereInputV2] = field(
        default=None, metadata=config(field_name="where")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetsV2:
    """AssetsV2."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    assets: Optional[List[AssetV2]] = field(
        default=None, metadata=config(field_name="assets")
    )
    page_info: Optional[PageInfoV2] = field(
        default=None, metadata=config(field_name="pageInfo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetHostnameFilter:
    """AssetHostnameFilter."""

    endpoint_types: Optional[List[Union[EndpointTypeV2, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EndpointTypeV2, x),
            field_name="endpointTypes",
        ),
    )
    where: Optional[AssetHostnameWhereInput] = field(
        default=None, metadata=config(field_name="where")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetIPAddressFilter:
    """AssetIPAddressFilter."""

    endpoint_types: Optional[List[Union[EndpointTypeV2, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EndpointTypeV2, x),
            field_name="endpointTypes",
        ),
    )
    where: Optional[AssetIPAddressWhereInput] = field(
        default=None, metadata=config(field_name="where")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetMacAddressFilter:
    """AssetMacAddressFilter."""

    endpoint_types: Optional[List[Union[EndpointTypeV2, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EndpointTypeV2, x),
            field_name="endpointTypes",
        ),
    )
    where: Optional[AssetMacAddressWhereInput] = field(
        default=None, metadata=config(field_name="where")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetFilter:
    """AssetFilter."""

    endpoint_types: Optional[List[Union[EndpointTypeV2, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EndpointTypeV2, x),
            field_name="endpointTypes",
        ),
    )
    asset_state: Optional[List[Union[AssetState, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AssetState, x),
            field_name="assetState",
        ),
    )
    where: Optional[AssetWhereInputV2] = field(
        default=None, metadata=config(field_name="where")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BulkDeleteTagsForEndpointsInputV2:
    """BulkDeleteTagsForEndpointsInputV2."""

    tag_keys: Optional[List[str]] = field(
        default=None, metadata=config(field_name="tagKeys")
    )
    filter: Optional[AssetFilter] = field(
        default=None, metadata=config(field_name="filter")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteAssetsInputV2:
    """DeleteAssetsInputV2."""

    filter: Optional[AssetFilter] = field(
        default=None, metadata=config(field_name="filter")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RestoreAssetsInputV2:
    """RestoreAssetsInputV2."""

    filter: Optional[AssetFilter] = field(
        default=None, metadata=config(field_name="filter")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssignBulkAssetsToGroupInput:
    """AssignBulkAssetsToGroupInput."""

    group_id: Optional[str] = field(default=None, metadata=config(field_name="groupId"))
    filter: Optional[AssetFilter] = field(
        default=None, metadata=config(field_name="filter")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssignBulkAssetsToInvestigationInput:
    """AssignBulkAssetsToInvestigationInput."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    filter: Optional[AssetFilter] = field(
        default=None, metadata=config(field_name="filter")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BulkDeleteInvestigationForEndpointsInput:
    """BulkDeleteInvestigationForEndpointsInput."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    filter: Optional[AssetFilter] = field(
        default=None, metadata=config(field_name="filter")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BulkUpdateTagsForEndpointsInputV2:
    """BulkUpdateTagsForEndpointsInputV2."""

    filter: Optional[AssetFilter] = field(
        default=None, metadata=config(field_name="filter")
    )
    tags: Optional[List[KVTagInputV2]] = field(
        default=None, metadata=config(field_name="tags")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BulkUninstallNativeAssetsInput:
    """BulkUninstallNativeAssetsInput."""

    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    agent_count: Optional[int] = field(
        default=None, metadata=config(field_name="agentCount")
    )
    filter: Optional[AssetFilter] = field(
        default=None, metadata=config(field_name="filter")
    )
    where: Optional[AssetWhereInputV2] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use filter.where"},
            field_name="where",
        ),
    )
