"""EndpointManagementService Mutation."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.endpoint_management_service.types import *
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.endpoint_management_service import (
        EndpointManagementServiceService,
    )

log = logging.getLogger(__name__)


class TaegisSDKEndpointManagementServiceMutation:
    """Taegis Endpoint_management_service Mutation operations."""

    def __init__(self, service: EndpointManagementServiceService):
        self.service = service

    def create_endpoint_group(self, input_: CreateEndpointGroupInput) -> EndpointGroup:
        """Create new endpoint group for a tenant.."""
        endpoint = "createEndpointGroup"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(EndpointGroup),
        )
        if result.get(endpoint) is not None:
            return EndpointGroup.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createEndpointGroup")

    def update_endpoint_group(self, input_: UpdateEndpointGroupInput) -> EndpointGroup:
        """Update policy type of endpoint group for a tenant.."""
        endpoint = "updateEndpointGroup"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(EndpointGroup),
        )
        if result.get(endpoint) is not None:
            return EndpointGroup.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateEndpointGroup")

    def delete_endpoint_group(self, input_: DeleteEndpointGrpInput) -> bool:
        """Delete endpoint group for a tenant.."""
        endpoint = "deleteEndpointGroup"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for mutation deleteEndpointGroup")

    def create_policy(self, input_: CreatePolicyInput) -> Policy:
        """Create new policy. Used by administrator of the taegis."""
        endpoint = "createPolicy"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(Policy),
        )
        if result.get(endpoint) is not None:
            return Policy.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createPolicy")

    def assign_bulk_assets_to_group(
        self, input_: Optional[BulkAssignRequestInput] = None
    ) -> BulkAssignRequestOutput:
        """Assign the assets to target group."""
        endpoint = "assignBulkAssetsToGroup"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(BulkAssignRequestOutput),
        )
        if result.get(endpoint) is not None:
            return BulkAssignRequestOutput.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation assignBulkAssetsToGroup")

    def rotate_registration_key(self, endpoint_group_id: str) -> EndpointGroup:
        """Rotate the registration key for a group."""
        endpoint = "rotateRegistrationKey"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "endpointGroupID": prepare_input(endpoint_group_id),
            },
            output=build_output_string(EndpointGroup),
        )
        if result.get(endpoint) is not None:
            return EndpointGroup.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation rotateRegistrationKey")

    def create_agent_setting(self, input_: AgentSettingsInput) -> AgentSetting:
        """create agent settings item."""
        endpoint = "createAgentSetting"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(AgentSetting),
        )
        if result.get(endpoint) is not None:
            return AgentSetting.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createAgentSetting")

    def update_agent_setting(
        self, id_: str, input_: AgentSettingsInput
    ) -> AgentSetting:
        """update agent settings item."""
        endpoint = "updateAgentSetting"

        log.warning(
            f"GraphQL Mutation `{endpoint}` is deprecated: 'Use V2 api for update functionality'"
        )

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
                "input": prepare_input(input_),
            },
            output=build_output_string(AgentSetting),
        )
        if result.get(endpoint) is not None:
            return AgentSetting.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateAgentSetting")

    def update_agent_setting_v2(
        self, id_: str, input_: UpdateAgentSettingsInput
    ) -> AgentSetting:
        """update the default agent settings item."""
        endpoint = "updateAgentSettingV2"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
                "input": prepare_input(input_),
            },
            output=build_output_string(AgentSetting),
        )
        if result.get(endpoint) is not None:
            return AgentSetting.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateAgentSettingV2")

    def update_default_agent_setting(self, input_: AgentSettingsInput) -> AgentSetting:
        """update the default agent settings item."""
        endpoint = "updateDefaultAgentSetting"

        log.warning(
            f"GraphQL Mutation `{endpoint}` is deprecated: 'Use V2 api for update functionality'"
        )

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(AgentSetting),
        )
        if result.get(endpoint) is not None:
            return AgentSetting.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateDefaultAgentSetting")

    def update_default_agent_setting_v2(
        self, input_: UpdateAgentSettingsInput
    ) -> AgentSetting:
        """delete agent settings item."""
        endpoint = "updateDefaultAgentSettingV2"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(AgentSetting),
        )
        if result.get(endpoint) is not None:
            return AgentSetting.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateDefaultAgentSettingV2")

    def delete_agent_setting(self, id_: str) -> bool:
        """delete agent settings item."""
        endpoint = "deleteAgentSetting"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for mutation deleteAgentSetting")

    def update_group_policy_override(
        self, input_: UpdatePolicyOverrideInput
    ) -> EndpointGroup:
        """Update the policy override for an endpoint group."""
        endpoint = "updateGroupPolicyOverride"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(EndpointGroup),
        )
        if result.get(endpoint) is not None:
            return EndpointGroup.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateGroupPolicyOverride")

    def delete_group_policy_override(self, id_: str) -> EndpointGroup:
        """Delete the policy override for an endpoint group."""
        endpoint = "deleteGroupPolicyOverride"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(EndpointGroup),
        )
        if result.get(endpoint) is not None:
            return EndpointGroup.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation deleteGroupPolicyOverride")

    def update_agent_setting_policy_override(
        self, input_: UpdatePolicyOverrideInput
    ) -> AgentSetting:
        """Update the policy override for an agent setting."""
        endpoint = "updateAgentSettingPolicyOverride"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(AgentSetting),
        )
        if result.get(endpoint) is not None:
            return AgentSetting.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for mutation updateAgentSettingPolicyOverride"
        )

    def delete_agent_setting_policy_override(self, id_: str) -> AgentSetting:
        """Delete the policy override for an agent setting."""
        endpoint = "deleteAgentSettingPolicyOverride"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(AgentSetting),
        )
        if result.get(endpoint) is not None:
            return AgentSetting.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for mutation deleteAgentSettingPolicyOverride"
        )
