"""Exports Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.exports.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.exports import ExportsService

log = logging.getLogger(__name__)


class TaegisSDKExportsQuery:
    """Taegis Exports Query operations."""

    def __init__(self, service: ExportsService):
        self.service = service

    def all_exports(
        self, include_connected_exports: Optional[bool] = None
    ) -> List[Export]:
        """None."""
        endpoint = "allExports"

        log.warning(
            f"GraphQL Query `{endpoint}` is deprecated: 'Migration to V2 backend; Use 'searchReportsV2''"
        )

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "includeConnectedExports": prepare_input(include_connected_exports),
            },
            output=build_output_string(Export),
        )
        if result.get(endpoint) is not None:
            return Export.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query allExports")

    def single_export(self, id_: str) -> Export:
        """None."""
        endpoint = "singleExport"

        log.warning(
            f"GraphQL Query `{endpoint}` is deprecated: 'Migration to V2 backend; Use 'reportV2''"
        )

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(Export),
        )
        if result.get(endpoint) is not None:
            return Export.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query singleExport")

    def get_export_url(self, input_: str) -> str:
        """None."""
        endpoint = "getExportURL"

        log.warning(
            f"GraphQL Query `{endpoint}` is deprecated: 'Migration to V2 backend; Use 'downloadReportArtifactV2''"
        )

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for query getExportURL")

    def get_reports_from_schedule(
        self,
        id_: str,
        cursor: Optional[Cursor] = None,
        filters: Optional[ReportsFilters] = None,
    ) -> ReportsOutput:
        """None."""
        endpoint = "getReportsFromSchedule"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
                "cursor": prepare_input(cursor),
                "filters": prepare_input(filters),
            },
            output=build_output_string(ReportsOutput),
        )
        if result.get(endpoint) is not None:
            return ReportsOutput.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query getReportsFromSchedule")

    def all_reports(
        self, cursor: Optional[Cursor] = None, filters: Optional[ReportsFilters] = None
    ) -> ReportsOutput:
        """None."""
        endpoint = "allReports"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "cursor": prepare_input(cursor),
                "filters": prepare_input(filters),
            },
            output=build_output_string(ReportsOutput),
        )
        if result.get(endpoint) is not None:
            return ReportsOutput.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query allReports")

    def all_schedules(
        self,
        cursor: Optional[Cursor] = None,
        filters: Optional[SchedulesFilters] = None,
    ) -> SchedulesOutput:
        """None."""
        endpoint = "allSchedules"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "cursor": prepare_input(cursor),
                "filters": prepare_input(filters),
            },
            output=build_output_string(SchedulesOutput),
        )
        if result.get(endpoint) is not None:
            return SchedulesOutput.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query allSchedules")

    def single_schedule(self, id_: str) -> Schedule:
        """None."""
        endpoint = "singleSchedule"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(Schedule),
        )
        if result.get(endpoint) is not None:
            return Schedule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query singleSchedule")

    def single_report(self, id_: str) -> Report:
        """None."""
        endpoint = "singleReport"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(Report),
        )
        if result.get(endpoint) is not None:
            return Report.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query singleReport")

    def get_report_url(self, id_: str) -> str:
        """None."""
        endpoint = "getReportURL"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for query getReportURL")

    def get_connected_export_url(self, id_: str) -> str:
        """None."""
        endpoint = "getConnectedExportURL"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for query getConnectedExportURL")

    def create_absolute_time_red_ql_query(
        self, query: str, reference_time: str, current_time: str
    ) -> str:
        """None."""
        endpoint = "createAbsoluteTimeRedQLQuery"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "query": prepare_input(query),
                "referenceTime": prepare_input(reference_time),
                "currentTime": prepare_input(current_time),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for query createAbsoluteTimeRedQLQuery")

    def get_reports_from_schedule_v2(
        self, input_: ReportsFromScheduleInput
    ) -> ReportsOutput:
        """None."""
        endpoint = "getReportsFromScheduleV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(ReportsOutput),
        )
        if result.get(endpoint) is not None:
            return ReportsOutput.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query getReportsFromScheduleV2")

    def all_reports_v2(self, input_: Optional[AllReportsInput] = None) -> ReportsOutput:
        """None."""
        endpoint = "allReportsV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(ReportsOutput),
        )
        if result.get(endpoint) is not None:
            return ReportsOutput.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query allReportsV2")

    def all_schedules_v2(
        self, input_: Optional[AllSchedulesInput] = None
    ) -> SchedulesOutput:
        """None."""
        endpoint = "allSchedulesV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(SchedulesOutput),
        )
        if result.get(endpoint) is not None:
            return SchedulesOutput.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query allSchedulesV2")

    def create_absolute_time_red_ql_query_v2(
        self, input_: AbsoluteTimeRedQLQueryInput
    ) -> str:
        """None."""
        endpoint = "createAbsoluteTimeRedQLQueryV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for query createAbsoluteTimeRedQLQueryV2")

    def get_red_ql_query_with_time_range(self, input_: QueryWithTimeRangeInput) -> str:
        """None."""
        endpoint = "getRedQLQueryWithTimeRange"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for query getRedQLQueryWithTimeRange")

    def get_all_unsubscriptions(self) -> List[Unsubscription]:
        """None."""
        endpoint = "getAllUnsubscriptions"

        result = self.service.execute_query(
            endpoint=endpoint, variables={}, output=build_output_string(Unsubscription)
        )
        if result.get(endpoint) is not None:
            return Unsubscription.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query getAllUnsubscriptions")
