"""FileInfo Mutation."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.file_info.types import *
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.file_info import FileInfoService

log = logging.getLogger(__name__)


class TaegisSDKFileInfoMutation:
    """Taegis File_info Mutation operations."""

    def __init__(self, service: FileInfoService):
        self.service = service

    def create_file_info(self, file: FileInput) -> File:
        """Creates a new file."""
        endpoint = "createFileInfo"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "file": prepare_input(file),
            },
            output=build_output_string(File),
        )
        if result.get(endpoint) is not None:
            return File.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createFileInfo")

    def delete_file_info(self, file_hash: str) -> bool:
        """Deletes a file."""
        endpoint = "deleteFileInfo"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "fileHash": prepare_input(file_hash),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for mutation deleteFileInfo")

    def set_malicious(
        self,
        id_: Optional[str] = None,
        file_hash: Optional[str] = None,
        malicious: Optional[bool] = None,
    ) -> File:
        """Sets the malicious flag for the file."""
        endpoint = "setMalicious"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
                "fileHash": prepare_input(file_hash),
                "malicious": prepare_input(malicious),
            },
            output=build_output_string(File),
        )
        if result.get(endpoint) is not None:
            return File.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation setMalicious")

    def create_appearances(
        self, appearances: List[AppearanceInput]
    ) -> List[Appearance]:
        """Create file appearances."""
        endpoint = "createAppearances"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "appearances": prepare_input(appearances),
            },
            output=build_output_string(Appearance),
        )
        if result.get(endpoint) is not None:
            return Appearance.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for mutation createAppearances")

    def create_yara_metadata(
        self, metadata: List[YaraMetadataInput]
    ) -> List[YaraMetadata]:
        """Create YARA metadata."""
        endpoint = "createYaraMetadata"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "metadata": prepare_input(metadata),
            },
            output=build_output_string(YaraMetadata),
        )
        if result.get(endpoint) is not None:
            return YaraMetadata.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for mutation createYaraMetadata")

    def create_file_path_metadata(self, metadata: FilePathMetadataInput) -> bool:
        """Create file path metadata."""
        endpoint = "createFilePathMetadata"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "metadata": prepare_input(metadata),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for mutation createFilePathMetadata")

    def submit_file_fetch_request(self, event_id: str) -> bool:
        """Submit a file fetch request."""
        endpoint = "submitFileFetchRequest"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "eventID": prepare_input(event_id),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for mutation submitFileFetchRequest")

    def create_file_marking(self, input_: FileMarkingInput) -> FileMarking:
        """Create a file marking record based on its filehash."""
        endpoint = "createFileMarking"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(FileMarking),
        )
        if result.get(endpoint) is not None:
            return FileMarking.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createFileMarking")
