"""IngestStats Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantDailyVolume:
    """TenantDailyVolume."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    date: Optional[str] = field(default=None, metadata=config(field_name="date"))
    total_bytes_compressed: Optional[int] = field(
        default=None, metadata=config(field_name="totalBytesCompressed")
    )
    total_records: Optional[int] = field(
        default=None, metadata=config(field_name="totalRecords")
    )
    total_distinct_records: Optional[int] = field(
        default=None, metadata=config(field_name="totalDistinctRecords")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class HostDailyVolume:
    """HostDailyVolume."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    sensor_type: Optional[str] = field(
        default=None, metadata=config(field_name="sensorType")
    )
    host: Optional[str] = field(default=None, metadata=config(field_name="host"))
    date: Optional[str] = field(default=None, metadata=config(field_name="date"))
    total_bytes_uncompressed: Optional[int] = field(
        default=None, metadata=config(field_name="totalBytesUncompressed")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TopKTenants:
    """TopKTenants."""

    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    schema_: Optional[str] = field(default=None, metadata=config(field_name="schema"))
    total_bytes_compressed: Optional[int] = field(
        default=None, metadata=config(field_name="totalBytesCompressed")
    )
    total_records: Optional[int] = field(
        default=None, metadata=config(field_name="totalRecords")
    )
    total_distinct_records: Optional[int] = field(
        default=None, metadata=config(field_name="totalDistinctRecords")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TopKSchema:
    """TopKSchema."""

    schema_: Optional[str] = field(default=None, metadata=config(field_name="schema"))
    total_bytes_compressed: Optional[int] = field(
        default=None, metadata=config(field_name="totalBytesCompressed")
    )
    total_records: Optional[int] = field(
        default=None, metadata=config(field_name="totalRecords")
    )
    total_distinct_records: Optional[int] = field(
        default=None, metadata=config(field_name="totalDistinctRecords")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantSensorType:
    """TenantSensorType."""

    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    sensor_types: Optional[List[str]] = field(
        default=None, metadata=config(field_name="sensorTypes")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DateRange:
    """DateRange."""

    start_date: Optional[str] = field(
        default=None, metadata=config(field_name="StartDate")
    )
    end_date: Optional[str] = field(default=None, metadata=config(field_name="EndDate"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TopKSchemasByDate:
    """TopKSchemasByDate."""

    date: Optional[str] = field(default=None, metadata=config(field_name="date"))
    schemas: Optional[List[TopKSchema]] = field(
        default=None, metadata=config(field_name="schemas")
    )
