"""Investigations2 Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum, parse_union_result


class AlertResolutionStatus(str, Enum):
    """AlertResolutionStatus."""

    OPEN = "OPEN"
    TRUE_POSITIVE_BENIGN = "TRUE_POSITIVE_BENIGN"
    TRUE_POSITIVE_MALICIOUS = "TRUE_POSITIVE_MALICIOUS"
    FALSE_POSITIVE = "FALSE_POSITIVE"
    NOT_ACTIONABLE = "NOT_ACTIONABLE"
    OTHER = "OTHER"
    SUPPRESSED = "SUPPRESSED"


class InvestigationRuleState(str, Enum):
    """InvestigationRuleState."""

    ENABLED = "ENABLED"
    APPEND = "APPEND"
    DISABLED = "DISABLED"
    TEST = "TEST"


class InvestigationStatus(str, Enum):
    """InvestigationStatus."""

    DRAFT = "DRAFT"
    DRAFT_DISMISSED = "DRAFT_DISMISSED"
    OPEN = "OPEN"
    AWAITING_ACTION = "AWAITING_ACTION"
    ACTIVE = "ACTIVE"
    SUSPENDED = "SUSPENDED"
    CLOSED_CONFIRMED_SECURITY_INCIDENT = "CLOSED_CONFIRMED_SECURITY_INCIDENT"
    CLOSED_AUTHORIZED_ACTIVITY = "CLOSED_AUTHORIZED_ACTIVITY"
    CLOSED_THREAT_MITIGATED = "CLOSED_THREAT_MITIGATED"
    CLOSED_NOT_VULNERABLE = "CLOSED_NOT_VULNERABLE"
    CLOSED_FALSE_POSITIVE_ALERT = "CLOSED_FALSE_POSITIVE_ALERT"
    CLOSED_INCONCLUSIVE = "CLOSED_INCONCLUSIVE"
    CLOSED_INFORMATIONAL = "CLOSED_INFORMATIONAL"


class InvestigationCloseStatus(str, Enum):
    """InvestigationCloseStatus."""

    CLOSED_CONFIRMED_SECURITY_INCIDENT = "CLOSED_CONFIRMED_SECURITY_INCIDENT"
    CLOSED_AUTHORIZED_ACTIVITY = "CLOSED_AUTHORIZED_ACTIVITY"
    CLOSED_THREAT_MITIGATED = "CLOSED_THREAT_MITIGATED"
    CLOSED_NOT_VULNERABLE = "CLOSED_NOT_VULNERABLE"
    CLOSED_FALSE_POSITIVE_ALERT = "CLOSED_FALSE_POSITIVE_ALERT"
    CLOSED_INCONCLUSIVE = "CLOSED_INCONCLUSIVE"
    CLOSED_INFORMATIONAL = "CLOSED_INFORMATIONAL"


class InvestigationType(str, Enum):
    """InvestigationType."""

    SECURITY_INVESTIGATION = "SECURITY_INVESTIGATION"
    INCIDENT_RESPONSE = "INCIDENT_RESPONSE"
    THREAT_HUNT = "THREAT_HUNT"
    MANAGED_XDR_THREAT_HUNT = "MANAGED_XDR_THREAT_HUNT"
    CTU_THREAT_HUNT = "CTU_THREAT_HUNT"
    MANAGED_XDR_ELITE_THREAT_HUNT = "MANAGED_XDR_ELITE_THREAT_HUNT"
    SECUREWORKS_INCIDENT_RESPONSE = "SECUREWORKS_INCIDENT_RESPONSE"
    UNLIMITED_RESPONSE = "UNLIMITED_RESPONSE"
    MANAGED_XDR_OT_INVESTIGATION = "MANAGED_XDR_OT_INVESTIGATION"
    OT_INVESTIGATION = "OT_INVESTIGATION"
    DETECTION_RESEARCH = "DETECTION_RESEARCH"
    INFORMATIONAL = "INFORMATIONAL"


class InvestigationProcessingState(str, Enum):
    """InvestigationProcessingState."""

    SUCCESS = "SUCCESS"
    FAILED = "FAILED"
    RUNNING = "RUNNING"


class InvestigationResourceType(str, Enum):
    """InvestigationResourceType."""

    INVESTIGATION_TEMPLATE = "INVESTIGATION_TEMPLATE"
    INVESTIGATION_RULE = "INVESTIGATION_RULE"


class PaginationOrder(str, Enum):
    """PaginationOrder."""

    ASCENDING = "ASCENDING"
    DESCENDING = "DESCENDING"


class InvestigationV2TimelineEntityType(str, Enum):
    """InvestigationV2TimelineEntityType."""

    ALERT = "ALERT"
    EVENT = "EVENT"
    AUDIT = "AUDIT"


class InvestigationRuleType(str, Enum):
    """InvestigationRuleType."""

    STATIC = "STATIC"
    ALERT_THREAD = "ALERT_THREAD"


class CommentVisibilityFilter(str, Enum):
    """CommentVisibilityFilter."""

    INTERNAL = "INTERNAL"
    NOT_INTERNAL = "NOT_INTERNAL"
    ALL = "ALL"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationsAggregationArguments:
    """InvestigationsAggregationArguments."""

    cql: Optional[str] = field(default=None, metadata=config(field_name="cql"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationsAggregation:
    """InvestigationsAggregation."""

    aggregation: Optional[List[dict]] = field(
        default=None, metadata=config(field_name="Aggregation")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AddEvidenceToInvestigationInput:
    """AddEvidenceToInvestigationInput."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    alerts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alerts")
    )
    alerts_search_query: Optional[str] = field(
        default=None, metadata=config(field_name="alertsSearchQuery")
    )
    events: Optional[List[str]] = field(
        default=None, metadata=config(field_name="events")
    )
    search_queries: Optional[List[str]] = field(
        default=None, metadata=config(field_name="searchQueries")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RemoveEvidenceFromInvestigationInput:
    """RemoveEvidenceFromInvestigationInput."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    alerts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alerts")
    )
    events: Optional[List[str]] = field(
        default=None, metadata=config(field_name="events")
    )
    assets: Optional[List[str]] = field(
        default=None, metadata=config(field_name="assets")
    )
    search_queries: Optional[List[str]] = field(
        default=None, metadata=config(field_name="searchQueries")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteInvestigationRuleInput:
    """DeleteInvestigationRuleInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ArchiveInvestigationInput:
    """ArchiveInvestigationInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UnarchiveInvestigationInput:
    """UnarchiveInvestigationInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ArchiveInvestigationsInput:
    """ArchiveInvestigationsInput."""

    ids: Optional[List[str]] = field(default=None, metadata=config(field_name="ids"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UnarchiveInvestigationsInput:
    """UnarchiveInvestigationsInput."""

    ids: Optional[List[str]] = field(default=None, metadata=config(field_name="ids"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ArchivedInvestigations:
    """ArchivedInvestigations."""

    ids: Optional[List[str]] = field(default=None, metadata=config(field_name="ids"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UnarchivedInvestigations:
    """UnarchivedInvestigations."""

    ids: Optional[List[str]] = field(default=None, metadata=config(field_name="ids"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationPriorityCount:
    """InvestigationPriorityCount."""

    priority: Optional[int] = field(
        default=None, metadata=config(field_name="priority")
    )
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Metric:
    """Metric."""

    draft_created_at: Optional[str] = field(
        default=None, metadata=config(field_name="draftCreatedAt")
    )
    draft_promoted_at: Optional[str] = field(
        default=None, metadata=config(field_name="draftPromotedAt")
    )
    time_to_draft_promotion: Optional[int] = field(
        default=None, metadata=config(field_name="timeToDraftPromotion")
    )
    draft_promoted_by: Optional[str] = field(
        default=None, metadata=config(field_name="draftPromotedBy")
    )
    handed_off_at: Optional[str] = field(
        default=None, metadata=config(field_name="handedOffAt")
    )
    time_to_hand_off: Optional[int] = field(
        default=None, metadata=config(field_name="timeToHandOff")
    )
    handed_off_by: Optional[str] = field(
        default=None, metadata=config(field_name="handedOffBy")
    )
    acknowledged_at: Optional[str] = field(
        default=None, metadata=config(field_name="acknowledgedAt")
    )
    time_to_acknowledgement: Optional[int] = field(
        default=None, metadata=config(field_name="timeToAcknowledgement")
    )
    acknowledged_by: Optional[str] = field(
        default=None, metadata=config(field_name="acknowledgedBy")
    )
    resolved_at: Optional[str] = field(
        default=None, metadata=config(field_name="resolvedAt")
    )
    time_to_resolution: Optional[int] = field(
        default=None, metadata=config(field_name="timeToResolution")
    )
    resolved_by: Optional[str] = field(
        default=None, metadata=config(field_name="resolvedBy")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Metrics:
    """Metrics."""

    mean_time_to_handoff: Optional[int] = field(
        default=None, metadata=config(field_name="meanTimeToHandoff")
    )
    mean_time_to_acknowledgement: Optional[int] = field(
        default=None, metadata=config(field_name="meanTimeToAcknowledgement")
    )
    mean_time_to_resolution: Optional[int] = field(
        default=None, metadata=config(field_name="meanTimeToResolution")
    )
    mean_time_to_draft_promotion: Optional[int] = field(
        default=None, metadata=config(field_name="meanTimeToDraftPromotion")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AddEvidenceToInvestigationResult:
    """AddEvidenceToInvestigationResult."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    alerts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alerts")
    )
    alerts_search_query: Optional[str] = field(
        default=None, metadata=config(field_name="alertsSearchQuery")
    )
    events: Optional[List[str]] = field(
        default=None, metadata=config(field_name="events")
    )
    search_queries: Optional[List[str]] = field(
        default=None, metadata=config(field_name="searchQueries")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RemoveEvidenceFromInvestigationResult:
    """RemoveEvidenceFromInvestigationResult."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    alerts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alerts")
    )
    events: Optional[List[str]] = field(
        default=None, metadata=config(field_name="events")
    )
    assets: Optional[List[str]] = field(
        default=None, metadata=config(field_name="assets")
    )
    search_queries: Optional[List[str]] = field(
        default=None, metadata=config(field_name="searchQueries")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateInvestigationTemplateInput:
    """CreateInvestigationTemplateInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    investigation_type: Optional[str] = field(
        default=None, metadata=config(field_name="investigationType")
    )
    investigation_priority: Optional[str] = field(
        default=None, metadata=config(field_name="investigationPriority")
    )
    investigation_title: Optional[str] = field(
        default=None, metadata=config(field_name="investigationTitle")
    )
    investigation_tags: Optional[List[str]] = field(
        default=None, metadata=config(field_name="investigationTags")
    )
    investigation_key_findings: Optional[str] = field(
        default=None, metadata=config(field_name="investigationKeyFindings")
    )
    investigation_key_findings_prompts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="investigationKeyFindingsPrompts")
    )
    investigation_assignee: Optional[str] = field(
        default=None, metadata=config(field_name="investigationAssignee")
    )
    investigation_status: Optional[str] = field(
        default=None, metadata=config(field_name="investigationStatus")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateInvestigationTemplateInput:
    """UpdateInvestigationTemplateInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    investigation_type: Optional[str] = field(
        default=None, metadata=config(field_name="investigationType")
    )
    investigation_priority: Optional[str] = field(
        default=None, metadata=config(field_name="investigationPriority")
    )
    investigation_title: Optional[str] = field(
        default=None, metadata=config(field_name="investigationTitle")
    )
    investigation_tags: Optional[List[str]] = field(
        default=None, metadata=config(field_name="investigationTags")
    )
    investigation_key_findings: Optional[str] = field(
        default=None, metadata=config(field_name="investigationKeyFindings")
    )
    investigation_key_findings_prompts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="investigationKeyFindingsPrompts")
    )
    investigation_assignee: Optional[str] = field(
        default=None, metadata=config(field_name="investigationAssignee")
    )
    investigation_status: Optional[str] = field(
        default=None, metadata=config(field_name="investigationStatus")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteInvestigationTemplateInput:
    """DeleteInvestigationTemplateInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2Arguments:
    """InvestigationV2Arguments."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationTemplateArguments:
    """InvestigationTemplateArguments."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationTemplatesArguments:
    """InvestigationTemplatesArguments."""

    cql: Optional[str] = field(default=None, metadata=config(field_name="cql"))
    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))
    name: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "no-op; use cql"},
            field_name="name",
        ),
    )
    tags: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "no-op; use cql"},
            field_name="tags",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationRuleArguments:
    """InvestigationRuleArguments."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationRulesArguments:
    """InvestigationRulesArguments."""

    cql: Optional[str] = field(default=None, metadata=config(field_name="cql"))
    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))
    name: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "no-op; use cql"},
            field_name="name",
        ),
    )
    tags: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "no-op; use cql"},
            field_name="tags",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ExportInvestigationResourceInput:
    """ExportInvestigationResourceInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ImportInvestigationResourcesInput:
    """ImportInvestigationResourcesInput."""

    file: Optional[str] = field(default=None, metadata=config(field_name="file"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationResourceExport:
    """InvestigationResourceExport."""

    export: Optional[str] = field(default=None, metadata=config(field_name="export"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AddCommentToInvestigationInput:
    """AddCommentToInvestigationInput."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    comment: Optional[str] = field(default=None, metadata=config(field_name="comment"))
    is_internal: Optional[bool] = field(
        default=None, metadata=config(field_name="isInternal")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateInvestigationCommentInput:
    """UpdateInvestigationCommentInput."""

    comment_id: Optional[str] = field(
        default=None, metadata=config(field_name="commentId")
    )
    comment: Optional[str] = field(default=None, metadata=config(field_name="comment"))
    mark_as_read: Optional[bool] = field(
        default=None, metadata=config(field_name="markAsRead")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteInvestigationCommentInput:
    """DeleteInvestigationCommentInput."""

    comment_id: Optional[str] = field(
        default=None, metadata=config(field_name="commentId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationCommentsCount:
    """InvestigationCommentsCount."""

    total: Optional[int] = field(default=None, metadata=config(field_name="total"))
    unread: Optional[int] = field(default=None, metadata=config(field_name="unread"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertEvidence:
    """AlertEvidence."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_by: Optional[str] = field(
        default=None, metadata=config(field_name="createdBy")
    )
    alert_id: Optional[str] = field(default=None, metadata=config(field_name="alertId"))
    is_genesis: Optional[bool] = field(
        default=None, metadata=config(field_name="isGenesis")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EventEvidence:
    """EventEvidence."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_by: Optional[str] = field(
        default=None, metadata=config(field_name="createdBy")
    )
    event_id: Optional[str] = field(default=None, metadata=config(field_name="eventId"))
    is_genesis: Optional[bool] = field(
        default=None, metadata=config(field_name="isGenesis")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetEvidence:
    """AssetEvidence."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_by: Optional[str] = field(
        default=None, metadata=config(field_name="createdBy")
    )
    asset_id: Optional[str] = field(default=None, metadata=config(field_name="assetId"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityEvidence:
    """EntityEvidence."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_by: Optional[str] = field(
        default=None, metadata=config(field_name="createdBy")
    )
    entity_id: Optional[str] = field(
        default=None, metadata=config(field_name="entityId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SearchQueryEvidence:
    """SearchQueryEvidence."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_by: Optional[str] = field(
        default=None, metadata=config(field_name="createdBy")
    )
    search_query: Optional[str] = field(
        default=None, metadata=config(field_name="searchQuery")
    )
    is_genesis: Optional[bool] = field(
        default=None, metadata=config(field_name="isGenesis")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationFileMeta:
    """InvestigationFileMeta."""

    content_type: Optional[str] = field(
        default=None, metadata=config(field_name="contentType")
    )
    content_md5: Optional[str] = field(
        default=None, metadata=config(field_name="contentMD5")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InitInvestigationFileUploadInput:
    """InitInvestigationFileUploadInput."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    size: Optional[int] = field(default=None, metadata=config(field_name="size"))
    content_type: Optional[str] = field(
        default=None, metadata=config(field_name="contentType")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationFileV2Arguments:
    """InvestigationFileV2Arguments."""

    file_id: Optional[str] = field(default=None, metadata=config(field_name="fileId"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationFilesV2Arguments:
    """InvestigationFilesV2Arguments."""

    cql: Optional[str] = field(default=None, metadata=config(field_name="cql"))
    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))
    investigation_id: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "use cql query field to filter by investigationId. Setting this field will ignore the provided cql query.",
            },
            field_name="investigationId",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteInvestigationFileInput:
    """DeleteInvestigationFileInput."""

    file_id: Optional[str] = field(default=None, metadata=config(field_name="fileId"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantV4:
    """TenantV4."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Subject:
    """Subject."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TDRUser:
    """TDRUser."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationStatusCount:
    """InvestigationStatusCount."""

    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    status: Optional[Union[InvestigationStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationStatus, x),
            field_name="status",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationTypeCount:
    """InvestigationTypeCount."""

    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    type: Optional[Union[InvestigationType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationTenantCount:
    """InvestigationTenantCount."""

    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    tenant: Optional[TenantV4] = field(
        default=None, metadata=config(field_name="tenant")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationCreatorCount:
    """InvestigationCreatorCount."""

    creator_id: Optional[str] = field(
        default=None, metadata=config(field_name="creatorId")
    )
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="subject")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationAssigneeCount:
    """InvestigationAssigneeCount."""

    assignee_id: Optional[str] = field(
        default=None, metadata=config(field_name="assigneeId")
    )
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="subject")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationsV2Arguments:
    """InvestigationsV2Arguments."""

    cql: Optional[str] = field(default=None, metadata=config(field_name="cql"))
    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))
    tenant_service_filters: Optional[List[str]] = field(
        default=None, metadata=config(field_name="tenantServiceFilters")
    )
    search_children_tenants: Optional[bool] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "does not do anything - the default is now to search children tenants if the calling context is partner",
            },
            field_name="searchChildrenTenants",
        ),
    )
    order_by: Optional[Union[PaginationOrder, TaegisEnum]] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "does not do anything - sorting is done through cql",
            },
            encoder=encode_enum,
            decoder=lambda x: decode_enum(PaginationOrder, x),
            field_name="orderBy",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ExportInvestigationResourcesArgument:
    """ExportInvestigationResourcesArgument."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    type: Optional[Union[InvestigationResourceType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationResourceType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateInvestigationRuleInput:
    """UpdateInvestigationRuleInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    order: Optional[int] = field(default=None, metadata=config(field_name="order"))
    filter: Optional[str] = field(default=None, metadata=config(field_name="filter"))
    append_filter: Optional[str] = field(
        default=None, metadata=config(field_name="appendFilter")
    )
    append_comment: Optional[str] = field(
        default=None, metadata=config(field_name="appendComment")
    )
    group_by: Optional[List[str]] = field(
        default=None, metadata=config(field_name="groupBy")
    )
    group_count: Optional[int] = field(
        default=None, metadata=config(field_name="groupCount")
    )
    group_duration: Optional[str] = field(
        default=None, metadata=config(field_name="groupDuration")
    )
    group_extend_on_append: Optional[bool] = field(
        default=None, metadata=config(field_name="groupExtendOnAppend")
    )
    search_queries: Optional[List[str]] = field(
        default=None, metadata=config(field_name="searchQueries")
    )
    search_window: Optional[str] = field(
        default=None, metadata=config(field_name="searchWindow")
    )
    tenant_filter: Optional[str] = field(
        default=None, metadata=config(field_name="tenantFilter")
    )
    skip_alert_prioritization: Optional[bool] = field(
        default=None, metadata=config(field_name="skipAlertPrioritization")
    )
    template_id: Optional[str] = field(
        default=None, metadata=config(field_name="templateId")
    )
    response_data: Optional[dict] = field(
        default=None, metadata=config(field_name="responseData")
    )
    state: Optional[Union[InvestigationRuleState, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationRuleState, x),
            field_name="state",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2StatusesArguments:
    """InvestigationV2StatusesArguments."""

    current_status: Optional[Union[InvestigationStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationStatus, x),
            field_name="currentStatus",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2Type:
    """InvestigationV2Type."""

    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    type: Optional[Union[InvestigationType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2Status:
    """InvestigationV2Status."""

    status: Optional[Union[InvestigationStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationStatus, x),
            field_name="status",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateInvestigationInput:
    """CreateInvestigationInput."""

    priority: Optional[int] = field(
        default=None, metadata=config(field_name="priority")
    )
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    key_findings: Optional[str] = field(
        default=None, metadata=config(field_name="keyFindings")
    )
    assignee_id: Optional[str] = field(
        default=None, metadata=config(field_name="assigneeId")
    )
    alerts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alerts")
    )
    alerts_search_query: Optional[str] = field(
        default=None, metadata=config(field_name="alertsSearchQuery")
    )
    events: Optional[List[str]] = field(
        default=None, metadata=config(field_name="events")
    )
    search_queries: Optional[List[str]] = field(
        default=None, metadata=config(field_name="searchQueries")
    )
    service_desk_id: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDeskId")
    )
    service_desk_type: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDeskType")
    )
    rule_id: Optional[str] = field(default=None, metadata=config(field_name="ruleId"))
    template_id: Optional[str] = field(
        default=None, metadata=config(field_name="templateId")
    )
    type: Optional[Union[InvestigationType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationType, x),
            field_name="type",
        ),
    )
    status: Optional[Union[InvestigationStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationStatus, x),
            field_name="status",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateInvestigationV2Input:
    """UpdateInvestigationV2Input."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    priority: Optional[int] = field(
        default=None, metadata=config(field_name="priority")
    )
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    key_findings: Optional[str] = field(
        default=None, metadata=config(field_name="keyFindings")
    )
    assignee_id: Optional[str] = field(
        default=None, metadata=config(field_name="assigneeId")
    )
    service_desk_id: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDeskId")
    )
    service_desk_type: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDeskType")
    )
    type: Optional[Union[InvestigationType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationType, x),
            field_name="type",
        ),
    )
    status: Optional[Union[InvestigationStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationStatus, x),
            field_name="status",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CloseInvestigationInput:
    """CloseInvestigationInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    status: Optional[Union[InvestigationCloseStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationCloseStatus, x),
            field_name="status",
        ),
    )
    alerts_resolution_status: Optional[Union[AlertResolutionStatus, TaegisEnum]] = (
        field(
            default=None,
            metadata=config(
                encoder=encode_enum,
                decoder=lambda x: decode_enum(AlertResolutionStatus, x),
                field_name="alertsResolutionStatus",
            ),
        )
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateInvestigationRuleInput:
    """CreateInvestigationRuleInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    order: Optional[int] = field(default=None, metadata=config(field_name="order"))
    filter: Optional[str] = field(default=None, metadata=config(field_name="filter"))
    append_filter: Optional[str] = field(
        default=None, metadata=config(field_name="appendFilter")
    )
    append_comment: Optional[str] = field(
        default=None, metadata=config(field_name="appendComment")
    )
    group_by: Optional[List[str]] = field(
        default=None, metadata=config(field_name="groupBy")
    )
    group_count: Optional[int] = field(
        default=None, metadata=config(field_name="groupCount")
    )
    group_duration: Optional[str] = field(
        default=None, metadata=config(field_name="groupDuration")
    )
    group_extend_on_append: Optional[bool] = field(
        default=None, metadata=config(field_name="groupExtendOnAppend")
    )
    search_queries: Optional[List[str]] = field(
        default=None, metadata=config(field_name="searchQueries")
    )
    search_window: Optional[str] = field(
        default=None, metadata=config(field_name="searchWindow")
    )
    tenant_filter: Optional[str] = field(
        default=None, metadata=config(field_name="tenantFilter")
    )
    skip_alert_prioritization: Optional[bool] = field(
        default=None, metadata=config(field_name="skipAlertPrioritization")
    )
    template_id: Optional[str] = field(
        default=None, metadata=config(field_name="templateId")
    )
    response_data: Optional[dict] = field(
        default=None, metadata=config(field_name="responseData")
    )
    type: Optional[Union[InvestigationRuleType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationRuleType, x),
            field_name="type",
        ),
    )
    state: Optional[Union[InvestigationRuleState, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationRuleState, x),
            field_name="state",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2TimelineArguments:
    """InvestigationV2TimelineArguments."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    created_after: Optional[str] = field(
        default=None, metadata=config(field_name="createdAfter")
    )
    created_before: Optional[str] = field(
        default=None, metadata=config(field_name="createdBefore")
    )
    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))
    order_by: Optional[Union[PaginationOrder, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(PaginationOrder, x),
            field_name="orderBy",
        ),
    )
    entity_types: Optional[
        List[Union[InvestigationV2TimelineEntityType, TaegisEnum]]
    ] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationV2TimelineEntityType, x),
            field_name="entityTypes",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CommentsV2Arguments:
    """CommentsV2Arguments."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))
    order_by: Optional[Union[PaginationOrder, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(PaginationOrder, x),
            field_name="orderBy",
        ),
    )
    visibility: Optional[Union[CommentVisibilityFilter, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(CommentVisibilityFilter, x),
            field_name="visibility",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationProcessingStatus:
    """InvestigationProcessingStatus."""

    assets: Optional[Union[InvestigationProcessingState, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationProcessingState, x),
            field_name="assets",
        ),
    )
    events: Optional[Union[InvestigationProcessingState, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationProcessingState, x),
            field_name="events",
        ),
    )
    alerts: Optional[Union[InvestigationProcessingState, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationProcessingState, x),
            field_name="alerts",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2TimelineEntity:
    """InvestigationV2TimelineEntity."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    resource_id: Optional[str] = field(
        default=None, metadata=config(field_name="resourceId")
    )
    resource_created_at: Optional[str] = field(
        default=None, metadata=config(field_name="resourceCreatedAt")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    descriptor: Optional[str] = field(
        default=None, metadata=config(field_name="descriptor")
    )
    subject_id: Optional[str] = field(
        default=None, metadata=config(field_name="subjectId")
    )
    is_partner_only: Optional[bool] = field(
        default=None, metadata=config(field_name="isPartnerOnly")
    )
    entity_id: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use resourceId"},
            field_name="entityId",
        ),
    )
    timestamp: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "use resourceCreatedAt",
            },
            field_name="timestamp",
        ),
    )
    user_id: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use subjectId"},
            field_name="userId",
        ),
    )
    subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="subject")
    )
    user: Optional[TDRUser] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use subject"},
            field_name="user",
        ),
    )
    user_subject: Optional[Subject] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use subject"},
            field_name="userSubject",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationFileV2:
    """InvestigationFileV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    deleted_at: Optional[str] = field(
        default=None, metadata=config(field_name="deletedAt")
    )
    uploaded_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="uploadedById")
    )
    deleted_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="deletedById")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    path: Optional[str] = field(default=None, metadata=config(field_name="path"))
    size: Optional[int] = field(default=None, metadata=config(field_name="size"))
    status: Optional[str] = field(default=None, metadata=config(field_name="status"))
    download_url: Optional[str] = field(
        default=None, metadata=config(field_name="downloadURL")
    )
    uploaded_by_subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="uploadedBySubject")
    )
    deleted_by_subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="deletedBySubject")
    )
    metadata: Optional[InvestigationFileMeta] = field(
        default=None, metadata=config(field_name="metadata")
    )
    uploaded_by: Optional[TDRUser] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "use uploadedBySubject",
            },
            field_name="uploadedBy",
        ),
    )
    deleted_by: Optional[TDRUser] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use deletedBySubject"},
            field_name="deletedBy",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AggregatedCounts:
    """AggregatedCounts."""

    archived_count: Optional[int] = field(
        default=None, metadata=config(field_name="archivedCount")
    )
    status: Optional[List[InvestigationStatusCount]] = field(
        default=None, metadata=config(field_name="status")
    )
    type: Optional[List[InvestigationTypeCount]] = field(
        default=None, metadata=config(field_name="type")
    )
    priority: Optional[List[InvestigationPriorityCount]] = field(
        default=None, metadata=config(field_name="priority")
    )
    tenant: Optional[List[InvestigationTenantCount]] = field(
        default=None, metadata=config(field_name="tenant")
    )
    assignee: Optional[List[InvestigationAssigneeCount]] = field(
        default=None, metadata=config(field_name="assignee")
    )
    creator: Optional[List[InvestigationCreatorCount]] = field(
        default=None, metadata=config(field_name="creator")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationTemplate:
    """InvestigationTemplate."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="createdById")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="updatedById")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    investigation_type: Optional[str] = field(
        default=None, metadata=config(field_name="investigationType")
    )
    investigation_priority: Optional[str] = field(
        default=None, metadata=config(field_name="investigationPriority")
    )
    investigation_title: Optional[str] = field(
        default=None, metadata=config(field_name="investigationTitle")
    )
    investigation_tags: Optional[List[str]] = field(
        default=None, metadata=config(field_name="investigationTags")
    )
    investigation_key_findings: Optional[str] = field(
        default=None, metadata=config(field_name="investigationKeyFindings")
    )
    investigation_key_findings_prompts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="investigationKeyFindingsPrompts")
    )
    investigation_assignee: Optional[str] = field(
        default=None, metadata=config(field_name="investigationAssignee")
    )
    investigation_status: Optional[str] = field(
        default=None, metadata=config(field_name="investigationStatus")
    )
    created_by_subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="createdBySubject")
    )
    updated_by_subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="updatedBySubject")
    )
    investigation_assignee_subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="investigationAssigneeSubject")
    )
    created_by: Optional[TDRUser] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use createdBySubject"},
            field_name="createdBy",
        ),
    )
    updated_by: Optional[TDRUser] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedBySubject"},
            field_name="updatedBy",
        ),
    )
    investigation_assignee_user: Optional[TDRUser] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "use investigationAssignee",
            },
            field_name="investigationAssigneeUser",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CommentV2:
    """CommentV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    author_id: Optional[str] = field(
        default=None, metadata=config(field_name="authorId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    comment: Optional[str] = field(default=None, metadata=config(field_name="comment"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    mentions_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="mentionsIds")
    )
    read_by_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="readByIds")
    )
    is_internal: Optional[bool] = field(
        default=None, metadata=config(field_name="isInternal")
    )
    author_subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="authorSubject")
    )
    mentions_subjects: Optional[List[Subject]] = field(
        default=None, metadata=config(field_name="mentionsSubjects")
    )
    read_by_subjects: Optional[List[Subject]] = field(
        default=None, metadata=config(field_name="readBySubjects")
    )
    author: Optional[TDRUser] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use authorSubject"},
            field_name="author",
        ),
    )
    mentions_users: Optional[List[TDRUser]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use mentionsSubjects"},
            field_name="mentionsUsers",
        ),
    )
    read_by: Optional[List[TDRUser]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use readBySubjects"},
            field_name="readBy",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationRule:
    """InvestigationRule."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="createdById")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="updatedById")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    order: Optional[int] = field(default=None, metadata=config(field_name="order"))
    filter: Optional[str] = field(default=None, metadata=config(field_name="filter"))
    append_filter: Optional[str] = field(
        default=None, metadata=config(field_name="appendFilter")
    )
    append_comment: Optional[str] = field(
        default=None, metadata=config(field_name="appendComment")
    )
    group_by: Optional[List[str]] = field(
        default=None, metadata=config(field_name="groupBy")
    )
    group_count: Optional[int] = field(
        default=None, metadata=config(field_name="groupCount")
    )
    group_duration: Optional[str] = field(
        default=None, metadata=config(field_name="groupDuration")
    )
    group_extend_on_append: Optional[bool] = field(
        default=None, metadata=config(field_name="groupExtendOnAppend")
    )
    search_queries: Optional[List[str]] = field(
        default=None, metadata=config(field_name="searchQueries")
    )
    search_window: Optional[str] = field(
        default=None, metadata=config(field_name="searchWindow")
    )
    tenant_filter: Optional[str] = field(
        default=None, metadata=config(field_name="tenantFilter")
    )
    skip_alert_prioritization: Optional[bool] = field(
        default=None, metadata=config(field_name="skipAlertPrioritization")
    )
    comment: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use appendComment"},
            field_name="comment",
        ),
    )
    exclude_child_tenants: Optional[bool] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use tenantFilter"},
            field_name="excludeChildTenants",
        ),
    )
    created_by_subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="createdBySubject")
    )
    updated_by_subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="updatedBySubject")
    )
    type: Optional[Union[InvestigationRuleType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationRuleType, x),
            field_name="type",
        ),
    )
    state: Optional[Union[InvestigationRuleState, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationRuleState, x),
            field_name="state",
        ),
    )
    template: Optional[InvestigationTemplate] = field(
        default=None, metadata=config(field_name="template")
    )
    created_by: Optional[TDRUser] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use createdBySubject"},
            field_name="createdBy",
        ),
    )
    updated_by: Optional[TDRUser] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedBySubject"},
            field_name="updatedBy",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2:
    """InvestigationV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    short_id: Optional[str] = field(default=None, metadata=config(field_name="shortId"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    key_findings: Optional[str] = field(
        default=None, metadata=config(field_name="keyFindings")
    )
    alerts_evidence_count: Optional[int] = field(
        default=None, metadata=config(field_name="alertsEvidenceCount")
    )
    assets_evidence_count: Optional[int] = field(
        default=None, metadata=config(field_name="assetsEvidenceCount")
    )
    events_evidence_count: Optional[int] = field(
        default=None, metadata=config(field_name="eventsEvidenceCount")
    )
    search_queries_evidence_count: Optional[int] = field(
        default=None, metadata=config(field_name="searchQueriesEvidenceCount")
    )
    priority: Optional[int] = field(
        default=None, metadata=config(field_name="priority")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    contributor_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="contributorIds")
    )
    assignee_id: Optional[str] = field(
        default=None, metadata=config(field_name="assigneeId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="createdById")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="updatedById")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    archived_at: Optional[str] = field(
        default=None, metadata=config(field_name="archivedAt")
    )
    close_reason: Optional[str] = field(
        default=None, metadata=config(field_name="closeReason")
    )
    rule_id: Optional[str] = field(default=None, metadata=config(field_name="ruleId"))
    service_desk_id: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDeskId")
    )
    service_desk_type: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDeskType")
    )
    is_created_by_partner: Optional[bool] = field(
        default=None, metadata=config(field_name="isCreatedByPartner")
    )
    alerts: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use alertsEvidence"},
            field_name="alerts",
        ),
    )
    assets: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use assetsEvidence"},
            field_name="assets",
        ),
    )
    events: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use eventsEvidence"},
            field_name="events",
        ),
    )
    contributor_ids: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use contributorIds"},
            field_name="contributorIDs",
        ),
    )
    search_queries: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "use searchQueriesEvidence",
            },
            field_name="searchQueries",
        ),
    )
    entities_evidence_count: Optional[int] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use alertsEvidence"},
            field_name="entitiesEvidenceCount",
        ),
    )
    alerts_evidence: Optional[List[AlertEvidence]] = field(
        default=None, metadata=config(field_name="alertsEvidence")
    )
    assets_evidence: Optional[List[AssetEvidence]] = field(
        default=None, metadata=config(field_name="assetsEvidence")
    )
    events_evidence: Optional[List[EventEvidence]] = field(
        default=None, metadata=config(field_name="eventsEvidence")
    )
    search_queries_evidence: Optional[List[SearchQueryEvidence]] = field(
        default=None, metadata=config(field_name="searchQueriesEvidence")
    )
    type: Optional[Union[InvestigationType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationType, x),
            field_name="type",
        ),
    )
    status: Optional[Union[InvestigationStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InvestigationStatus, x),
            field_name="status",
        ),
    )
    contributor_subjects: Optional[List[Subject]] = field(
        default=None, metadata=config(field_name="contributorSubjects")
    )
    assignee_subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="assigneeSubject")
    )
    tenant: Optional[TenantV4] = field(
        default=None, metadata=config(field_name="tenant")
    )
    created_by_subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="createdBySubject")
    )
    updated_by_subject: Optional[Subject] = field(
        default=None, metadata=config(field_name="updatedBySubject")
    )
    processing_status: Optional[InvestigationProcessingStatus] = field(
        default=None, metadata=config(field_name="processingStatus")
    )
    comments_count: Optional[InvestigationCommentsCount] = field(
        default=None, metadata=config(field_name="commentsCount")
    )
    metrics: Optional[Metric] = field(
        default=None, metadata=config(field_name="metrics")
    )
    entities_evidence: Optional[List[EntityEvidence]] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "call the entity api directly",
            },
            field_name="entitiesEvidence",
        ),
    )
    assignee: Optional[TDRUser] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use assigneeSubject"},
            field_name="assignee",
        ),
    )
    contributors: Optional[List[TDRUser]] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "use contributorSubjects",
            },
            field_name="contributors",
        ),
    )
    created_by: Optional[TDRUser] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use createdBySubject"},
            field_name="createdBy",
        ),
    )
    updated_by: Optional[TDRUser] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use updatedBySubject"},
            field_name="updatedBy",
        ),
    )
    metric: Optional[Metric] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use metrics"},
            field_name="metric",
        ),
    )


InvestigationResource = Union[
    InvestigationTemplate,
    InvestigationRule,
]


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationTemplates:
    """InvestigationTemplates."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    templates: Optional[List[InvestigationTemplate]] = field(
        default=None, metadata=config(field_name="templates")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ExportInvestigationResourcesArguments:
    """ExportInvestigationResourcesArguments."""

    arguments: Optional[List[ExportInvestigationResourcesArgument]] = field(
        default=None, metadata=config(field_name="arguments")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationRules:
    """InvestigationRules."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    rules: Optional[List[InvestigationRule]] = field(
        default=None, metadata=config(field_name="rules")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2Timeline:
    """InvestigationV2Timeline."""

    total_entities: Optional[int] = field(
        default=None, metadata=config(field_name="totalEntities")
    )
    entities: Optional[List[InvestigationV2TimelineEntity]] = field(
        default=None, metadata=config(field_name="entities")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CommentsV2:
    """CommentsV2."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    comments: Optional[List[CommentV2]] = field(
        default=None, metadata=config(field_name="comments")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationFileUpload:
    """InvestigationFileUpload."""

    presigned_url: Optional[str] = field(
        default=None, metadata=config(field_name="presignedUrl")
    )
    file: Optional[InvestigationFileV2] = field(
        default=None, metadata=config(field_name="file")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationFilesV2:
    """InvestigationFilesV2."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    files: Optional[List[InvestigationFileV2]] = field(
        default=None, metadata=config(field_name="files")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationsV2:
    """InvestigationsV2."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    investigations: Optional[List[InvestigationV2]] = field(
        default=None, metadata=config(field_name="investigations")
    )
    aggregated_counts: Optional[AggregatedCounts] = field(
        default=None, metadata=config(field_name="aggregatedCounts")
    )
    metrics: Optional[Metrics] = field(
        default=None, metadata=config(field_name="metrics")
    )
