"""Isensor Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.isensor.types import *
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.isensor import IsensorService


log = logging.getLogger(__name__)


class TaegisSDKIsensorQuery:
    """Taegis Isensor Query operations."""

    def __init__(self, service: IsensorService):
        self.service = service

    def i_sensor_details(self) -> List[IsensorDetail]:
        """Get all iSensor overview data."""
        endpoint = "iSensorDetails"

        result = self.service.execute_query(
            endpoint=endpoint, variables={}, output=build_output_string(IsensorDetail)
        )
        if result.get(endpoint) is not None:
            return IsensorDetail.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query iSensorDetails")

    def i_sensor_details_by_id(self, id_: str) -> IsensorDetail:
        """Get NDR overview data."""
        endpoint = "iSensorDetailsByID"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(IsensorDetail),
        )
        if result.get(endpoint) is not None:
            return IsensorDetail.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query iSensorDetailsByID")

    def i_sensor_firewall_rules(self, id_: str) -> IsensorFirewallRules:
        """Get iSensor firewall rules."""
        endpoint = "iSensorFirewallRules"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(IsensorFirewallRules),
        )
        if result.get(endpoint) is not None:
            return IsensorFirewallRules.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query iSensorFirewallRules")

    def i_sensor_job_status(self, id_: str) -> IsensorJob:
        """Get iSensor job status."""
        endpoint = "iSensorJobStatus"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(IsensorJob),
        )
        if result.get(endpoint) is not None:
            return IsensorJob.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query iSensorJobStatus")

    def i_sensor_job_logs(self, id_: str) -> IsensorJobLogs:
        """Get iSensor job log."""
        endpoint = "iSensorJobLogs"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(IsensorJobLogs),
        )
        if result.get(endpoint) is not None:
            return IsensorJobLogs.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query iSensorJobLogs")

    def i_sensor_open_source_zip(self) -> ISensorArtifact:
        """Get iSensor open-source location."""
        endpoint = "iSensorOpenSourceZip"

        result = self.service.execute_query(
            endpoint=endpoint, variables={}, output=build_output_string(ISensorArtifact)
        )
        if result.get(endpoint) is not None:
            return ISensorArtifact.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query iSensorOpenSourceZip")

    def i_sensor_vmware_ova(self) -> ISensorArtifact:
        """Get iSensor Vmware OVA location."""
        endpoint = "iSensorVmwareOVA"

        result = self.service.execute_query(
            endpoint=endpoint, variables={}, output=build_output_string(ISensorArtifact)
        )
        if result.get(endpoint) is not None:
            return ISensorArtifact.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query iSensorVmwareOVA")

    def i_sensor_change_mgmt_report_list(
        self,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort_by: Optional[Union[IsensorReportResultSortBy, TaegisEnum]] = None,
        sort_order: Optional[Union[IsensorReportResultSortOrder, TaegisEnum]] = None,
    ) -> List[IsensorChangeMgmtReportList]:
        """Get iSensor Change Management Report List."""
        endpoint = "iSensorChangeMgmtReportList"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "limit": prepare_input(limit),
                "offset": prepare_input(offset),
                "sortBy": prepare_input(sort_by),
                "sortOrder": prepare_input(sort_order),
            },
            output=build_output_string(IsensorChangeMgmtReportList),
        )
        if result.get(endpoint) is not None:
            return IsensorChangeMgmtReportList.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query iSensorChangeMgmtReportList")

    def i_sensor_change_mgmt_report_result(self, report_id: str) -> IsensorReportResult:
        """Get iSensor ChangeManagement Report Result."""
        endpoint = "iSensorChangeMgmtReportResult"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "reportId": prepare_input(report_id),
            },
            output=build_output_string(IsensorReportResult),
        )
        if result.get(endpoint) is not None:
            return IsensorReportResult.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query iSensorChangeMgmtReportResult")

    def i_sensor_change_mgmt_report_location(
        self, report_id: str, format_: Union[IsensorReportFormat, TaegisEnum]
    ) -> ISensorArtifact:
        """Get iSensor ChangeManagement Report Location."""
        endpoint = "iSensorChangeMgmtReportLocation"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "reportId": prepare_input(report_id),
                "format": prepare_input(format_),
            },
            output=build_output_string(ISensorArtifact),
        )
        if result.get(endpoint) is not None:
            return ISensorArtifact.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query iSensorChangeMgmtReportLocation")

    def ndr_maintenance_windows(self, idn: str) -> List[NdrMaintenanceWindowResult]:
        """Get NDR Device Maintenance window."""
        endpoint = "ndrMaintenanceWindows"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "idn": prepare_input(idn),
            },
            output=build_output_string(NdrMaintenanceWindowResult),
        )
        if result.get(endpoint) is not None:
            return NdrMaintenanceWindowResult.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query ndrMaintenanceWindows")

    def ndr_maintenance_event_devices(self, idn: str) -> List[NdrEventDeviceResult]:
        """Get Upcoming NDR EventDevice Events scheduled for idn."""
        endpoint = "ndrMaintenanceEventDevices"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "idn": prepare_input(idn),
            },
            output=build_output_string(NdrEventDeviceResult),
        )
        if result.get(endpoint) is not None:
            return NdrEventDeviceResult.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query ndrMaintenanceEventDevices")

    def ndr_device_policy(
        self, policy_input: NdrPolicyInput
    ) -> List[NdrDevicePolicyResult]:
        """Get NDR Policy for Device."""
        endpoint = "ndrDevicePolicy"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "policyInput": prepare_input(policy_input),
            },
            output=build_output_string(NdrDevicePolicyResult),
        )
        if result.get(endpoint) is not None:
            return NdrDevicePolicyResult.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query ndrDevicePolicy")

    def ndr_zeek_policy(
        self, idn: str, item_name: Optional[str] = None
    ) -> List[NdrDevicePolicyResult]:
        """Get NDR Zeek Policy for Device."""
        endpoint = "ndrZeekPolicy"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "idn": prepare_input(idn),
                "itemName": prepare_input(item_name),
            },
            output=build_output_string(NdrDevicePolicyResult),
        )
        if result.get(endpoint) is not None:
            return NdrDevicePolicyResult.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query ndrZeekPolicy")
