"""MultiTenantContext Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.multi_tenant_context.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.multi_tenant_context import (
        MultiTenantContextService,
    )

log = logging.getLogger(__name__)


class TaegisSDKMultiTenantContextQuery:
    """Taegis Multi_tenant_context Query operations."""

    def __init__(self, service: MultiTenantContextService):
        self.service = service

    def get_session(self, keys: Optional[List[str]] = None) -> List[Session]:
        """Gets a multi tenant session. This contains the multiple tenants a subject can look at. If the global key is provided but the session does not exist, it will be populated.."""
        endpoint = "getSession"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "keys": prepare_input(keys),
            },
            output=build_output_string(Session),
        )
        if result.get(endpoint) is not None:
            return Session.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query getSession")

    def get_tenant_history(self, key: str) -> List[History]:
        """Gets tenant history for a subject. If the global key is provided but the tenant history does not exist, it will be populated.."""
        endpoint = "getTenantHistory"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "key": prepare_input(key),
            },
            output=build_output_string(History),
        )
        if result.get(endpoint) is not None:
            return History.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query getTenantHistory")

    def get_claims_for_tenant(self, tenant_id: str) -> List[TenantClaim]:
        """Gets all the subjects who have claimed a specific tenant."""
        endpoint = "getClaimsForTenant"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "tenantID": prepare_input(tenant_id),
            },
            output=build_output_string(TenantClaim),
        )
        if result.get(endpoint) is not None:
            return TenantClaim.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query getClaimsForTenant")

    def get_claims_for_tenants(self, tenant_ids: List[str]) -> List[TenantsClaim]:
        """Gets all the subjects who have claims for multiple tenants."""
        endpoint = "getClaimsForTenants"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "tenantIDs": prepare_input(tenant_ids),
            },
            output=build_output_string(TenantsClaim),
        )
        if result.get(endpoint) is not None:
            return TenantsClaim.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query getClaimsForTenants")

    def get_claimed_tenants(self) -> List[TenantClaim]:
        """Gets all the tenant claims the current subject has."""
        endpoint = "getClaimedTenants"

        result = self.service.execute_query(
            endpoint=endpoint, variables={}, output=build_output_string(TenantClaim)
        )
        if result.get(endpoint) is not None:
            return TenantClaim.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query getClaimedTenants")

    def get_tenant_service_filters(self) -> List[str]:
        """Gets the available tenant service filters."""
        endpoint = "getTenantServiceFilters"

        result = self.service.execute_query(endpoint=endpoint, variables={}, output="")
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for query getTenantServiceFilters")
