"""NlSearch Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.nl_search.types import *
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.nl_search import NlSearchService


log = logging.getLogger(__name__)


class TaegisSDKNlSearchQuery:
    """Taegis Nl_search Query operations."""

    def __init__(self, service: NlSearchService):
        self.service = service

    def nl_search(self, in_: NLSearchInputs) -> List[NLSearchOutputs]:
        """nlSearch takes a natural language query input and converts to QL as the output. If many results are returned as output, the best result is first at the top of the list.."""
        endpoint = "nlSearch"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "in": prepare_input(in_),
            },
            output=build_output_string(NLSearchOutputs),
        )
        if result.get(endpoint) is not None:
            return NLSearchOutputs.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query nlSearch")
