"""Subjects Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.subjects.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.subjects import SubjectsService

log = logging.getLogger(__name__)


class TaegisSDKSubjectsQuery:
    """Taegis Subjects Query operations."""

    def __init__(self, service: SubjectsService):
        self.service = service

    def current_subject(self, selector: Optional[SubjectSelector] = None) -> Subject:
        """Returns the subject from the token provided in Authorization Header."""
        endpoint = "currentSubject"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "selector": prepare_input(selector),
            },
            output=build_output_string(Subject),
        )
        if result.get(endpoint) is not None:
            return Subject.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query currentSubject")
