"""TriggerAction Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PlaybookExecution:
    """PlaybookExecution."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PlaybookActionCategory:
    """PlaybookActionCategory."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PlaybookActionContext:
    """PlaybookActionContext."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ExecuteActionInput:
    """ExecuteActionInput."""

    playbook_action_id: Optional[str] = field(
        default=None, metadata=config(field_name="playbookActionId")
    )
    target_resource_id: Optional[str] = field(
        default=None, metadata=config(field_name="targetResourceId")
    )
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ExecuteBulkActionInput:
    """ExecuteBulkActionInput."""

    playbook_action_id: Optional[str] = field(
        default=None, metadata=config(field_name="playbookActionId")
    )
    target_resource_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="targetResourceIds")
    )
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PlaybookActionsV2Arguments:
    """PlaybookActionsV2Arguments."""

    proactive_response_only: Optional[bool] = field(
        default=None, metadata=config(field_name="proactiveResponseOnly")
    )
    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PlaybookActionsConfiguredArguments:
    """PlaybookActionsConfiguredArguments."""

    configured_only: Optional[bool] = field(
        default=None, metadata=config(field_name="configuredOnly")
    )
    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ExecutePlaybookActionV2Input:
    """ExecutePlaybookActionV2Input."""

    playbook_action_id: Optional[str] = field(
        default=None, metadata=config(field_name="playbookActionId")
    )
    target_resource_id: Optional[str] = field(
        default=None, metadata=config(field_name="targetResourceId")
    )
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PlaybookActionsArguments:
    """PlaybookActionsArguments."""

    playbook_action_id: Optional[str] = field(
        default=None, metadata=config(field_name="playbookActionId")
    )
    target_resource_id: Optional[str] = field(
        default=None, metadata=config(field_name="targetResourceId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ExprInput:
    """ExprInput."""

    expression: Optional[str] = field(
        default=None, metadata=config(field_name="expression")
    )
    resource_id: Optional[str] = field(
        default=None, metadata=config(field_name="resourceId")
    )
    resource_type: Optional[str] = field(
        default=None, metadata=config(field_name="resourceType")
    )
    inputs: Optional[Any] = field(default=None, metadata=config(field_name="inputs"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ExprResult:
    """ExprResult."""

    resolved_inputs: Optional[Any] = field(
        default=None, metadata=config(field_name="resolvedInputs")
    )
    output: Optional[Any] = field(default=None, metadata=config(field_name="output"))
    error_message: Optional[str] = field(
        default=None, metadata=config(field_name="errorMessage")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ExecutePlaybookActionInput:
    """ExecutePlaybookActionInput."""

    playbook_action: Optional[str] = field(
        default=None, metadata=config(field_name="playbookAction")
    )
    inputs: Optional[Any] = field(default=None, metadata=config(field_name="inputs"))
    target_resource: Optional[str] = field(
        default=None, metadata=config(field_name="targetResource")
    )
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BulkActions:
    """BulkActions."""

    executions: Optional[List[PlaybookExecution]] = field(
        default=None, metadata=config(field_name="executions")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PlaybookAction:
    """PlaybookAction."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    tenant: Optional[str] = field(default=None, metadata=config(field_name="tenant"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    is_enabled: Optional[bool] = field(
        default=None, metadata=config(field_name="isEnabled")
    )
    is_proactive: Optional[bool] = field(
        default=None, metadata=config(field_name="isProactive")
    )
    is_pre_approved: Optional[bool] = field(
        default=None, metadata=config(field_name="isPreApproved")
    )
    approved_by: Optional[str] = field(
        default=None, metadata=config(field_name="approvedBy")
    )
    category: Optional[PlaybookActionCategory] = field(
        default=None, metadata=config(field_name="category")
    )
    context: Optional[PlaybookActionContext] = field(
        default=None, metadata=config(field_name="context")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PlaybookActions:
    """PlaybookActions."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    actions: Optional[List[PlaybookAction]] = field(
        default=None, metadata=config(field_name="actions")
    )
