from pydantic import BaseModel

from tgpromo.clients.partner.api.base import BaseAPI


class SendImpressionResult(BaseModel):
    impression_sent: bool


class Impressions(BaseAPI):
    async def send(self, user_id: int, message_id: int) -> SendImpressionResult:
        payload = {
            'user_id': user_id,
            'message_id': message_id,
        }
        return await self._request(
            'post',
            '/v1/ads/impressions',
            result_model=SendImpressionResult,
            json=payload
        )
