# coding: utf-8

"""
    Amber Electric Public API

    Amber is an Australian-based electricity retailer that pass through the real-time wholesale price of energy.  Because of Amber's wholesale power prices, you can save hundreds of dollars a year by automating high power devices like air-conditioners, heat pumps and pool pumps.  This Python library provides an interface to the API, allowing you to react to current and forecast prices, as well as download your historic usage.

    The version of the OpenAPI document: 2.0.0
    Contact: dev@amber.com.au
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

try:
    from pydantic.v1 import validate_arguments
except ImportError:
    from pydantic import validate_arguments

from typing_extensions import Annotated
from datetime import date

from pydantic import Field, StrictInt, StrictStr

from typing import List, Optional

from amberelectric.models.interval import Interval
from amberelectric.models.renewable import Renewable
from amberelectric.models.site import Site
from amberelectric.models.usage import Usage

from amberelectric.api_client import ApiClient
from amberelectric.api_response import ApiResponse
from amberelectric.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class AmberApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_current_prices(
        self,
        site_id: Annotated[
            StrictStr,
            Field(
                ...,
                description="ID of the site you are fetching prices for. Can be found using the `/sites` enpoint",
            ),
        ],
        next: Annotated[
            Optional[StrictInt],
            Field(description="Return the _next_ number of forecast intervals"),
        ] = None,
        previous: Annotated[
            Optional[StrictInt],
            Field(description="Return the _previous_ number of actual intervals."),
        ] = None,
        resolution: Annotated[
            Optional[StrictInt],
            Field(
                description="Specify the required interval duration resolution. Valid options: 5, 30. Default: Your billing interval length."
            ),
        ] = None,
        **kwargs
    ) -> List[Interval]:  # noqa: E501
        """get_current_prices  # noqa: E501

        Returns the current price  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_current_prices(site_id, next, previous, resolution, async_req=True)
        >>> result = thread.get()

        :param site_id: ID of the site you are fetching prices for. Can be found using the `/sites` enpoint (required)
        :type site_id: str
        :param next: Return the _next_ number of forecast intervals
        :type next: int
        :param previous: Return the _previous_ number of actual intervals.
        :type previous: int
        :param resolution: Specify the required interval duration resolution. Valid options: 5, 30. Default: Your billing interval length.
        :type resolution: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[Interval]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_current_prices_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_current_prices_with_http_info(
            site_id, next, previous, resolution, **kwargs
        )  # noqa: E501

    @validate_arguments
    def get_current_prices_with_http_info(
        self,
        site_id: Annotated[
            StrictStr,
            Field(
                ...,
                description="ID of the site you are fetching prices for. Can be found using the `/sites` enpoint",
            ),
        ],
        next: Annotated[
            Optional[StrictInt],
            Field(description="Return the _next_ number of forecast intervals"),
        ] = None,
        previous: Annotated[
            Optional[StrictInt],
            Field(description="Return the _previous_ number of actual intervals."),
        ] = None,
        resolution: Annotated[
            Optional[StrictInt],
            Field(
                description="Specify the required interval duration resolution. Valid options: 5, 30. Default: Your billing interval length."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """get_current_prices  # noqa: E501

        Returns the current price  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_current_prices_with_http_info(site_id, next, previous, resolution, async_req=True)
        >>> result = thread.get()

        :param site_id: ID of the site you are fetching prices for. Can be found using the `/sites` enpoint (required)
        :type site_id: str
        :param next: Return the _next_ number of forecast intervals
        :type next: int
        :param previous: Return the _previous_ number of actual intervals.
        :type previous: int
        :param resolution: Specify the required interval duration resolution. Valid options: 5, 30. Default: Your billing interval length.
        :type resolution: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[Interval], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["site_id", "next", "previous", "resolution"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_current_prices" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["site_id"] is not None:
            _path_params["siteId"] = _params["site_id"]

        # process the query parameters
        _query_params = []
        if _params.get("next") is not None:  # noqa: E501
            _query_params.append(("next", _params["next"]))

        if _params.get("previous") is not None:  # noqa: E501
            _query_params.append(("previous", _params["previous"]))

        if _params.get("resolution") is not None:  # noqa: E501
            _query_params.append(("resolution", _params["resolution"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["apiKey"]  # noqa: E501

        _response_types_map = {
            "200": "List[Interval]",
            "400": None,
            "401": None,
            "404": None,
            "500": None,
        }

        return self.api_client.call_api(
            "/sites/{siteId}/prices/current",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_current_renewables(
        self,
        state: Annotated[
            StrictStr,
            Field(
                ...,
                description="State you would like the renewables for. Valid states: nsw, sa, qld, vic",
            ),
        ],
        next: Annotated[
            Optional[StrictInt],
            Field(description="Return the _next_ number of forecast intervals"),
        ] = None,
        previous: Annotated[
            Optional[StrictInt],
            Field(description="Return the _previous_ number of actual intervals."),
        ] = None,
        resolution: Annotated[
            Optional[StrictInt],
            Field(
                description="Specify the required interval duration resolution. Valid options: 5, 30. Default: 30"
            ),
        ] = None,
        **kwargs
    ) -> List[Renewable]:  # noqa: E501
        """get_current_renewables  # noqa: E501

        Returns the current percentage of renewables in the grid  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_current_renewables(state, next, previous, resolution, async_req=True)
        >>> result = thread.get()

        :param state: State you would like the renewables for. Valid states: nsw, sa, qld, vic (required)
        :type state: str
        :param next: Return the _next_ number of forecast intervals
        :type next: int
        :param previous: Return the _previous_ number of actual intervals.
        :type previous: int
        :param resolution: Specify the required interval duration resolution. Valid options: 5, 30. Default: 30
        :type resolution: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[Renewable]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_current_renewables_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_current_renewables_with_http_info(
            state, next, previous, resolution, **kwargs
        )  # noqa: E501

    @validate_arguments
    def get_current_renewables_with_http_info(
        self,
        state: Annotated[
            StrictStr,
            Field(
                ...,
                description="State you would like the renewables for. Valid states: nsw, sa, qld, vic",
            ),
        ],
        next: Annotated[
            Optional[StrictInt],
            Field(description="Return the _next_ number of forecast intervals"),
        ] = None,
        previous: Annotated[
            Optional[StrictInt],
            Field(description="Return the _previous_ number of actual intervals."),
        ] = None,
        resolution: Annotated[
            Optional[StrictInt],
            Field(
                description="Specify the required interval duration resolution. Valid options: 5, 30. Default: 30"
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """get_current_renewables  # noqa: E501

        Returns the current percentage of renewables in the grid  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_current_renewables_with_http_info(state, next, previous, resolution, async_req=True)
        >>> result = thread.get()

        :param state: State you would like the renewables for. Valid states: nsw, sa, qld, vic (required)
        :type state: str
        :param next: Return the _next_ number of forecast intervals
        :type next: int
        :param previous: Return the _previous_ number of actual intervals.
        :type previous: int
        :param resolution: Specify the required interval duration resolution. Valid options: 5, 30. Default: 30
        :type resolution: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[Renewable], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["state", "next", "previous", "resolution"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_current_renewables" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["state"] is not None:
            _path_params["state"] = _params["state"]

        # process the query parameters
        _query_params = []
        if _params.get("next") is not None:  # noqa: E501
            _query_params.append(("next", _params["next"]))

        if _params.get("previous") is not None:  # noqa: E501
            _query_params.append(("previous", _params["previous"]))

        if _params.get("resolution") is not None:  # noqa: E501
            _query_params.append(("resolution", _params["resolution"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            "200": "List[Renewable]",
            "400": None,
            "404": None,
            "500": None,
        }

        return self.api_client.call_api(
            "/state/{state}/renewables/current",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_prices(
        self,
        site_id: Annotated[
            StrictStr,
            Field(
                ...,
                description="ID of the site you are fetching prices for. Can be found using the `/sites` endpoint",
            ),
        ],
        start_date: Annotated[
            Optional[date],
            Field(
                description="Return all prices for each interval on and after this day. Defaults to today."
            ),
        ] = None,
        end_date: Annotated[
            Optional[date],
            Field(
                description="Return all prices for each interval on and before this day. Defaults to today."
            ),
        ] = None,
        resolution: Annotated[
            Optional[StrictInt],
            Field(
                description="Specify the required interval duration resolution. Valid options: 5, 30. Default: Your billing interval length."
            ),
        ] = None,
        **kwargs
    ) -> List[Interval]:  # noqa: E501
        """get_prices  # noqa: E501

        Returns all the prices between the start and end dates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_prices(site_id, start_date, end_date, resolution, async_req=True)
        >>> result = thread.get()

        :param site_id: ID of the site you are fetching prices for. Can be found using the `/sites` endpoint (required)
        :type site_id: str
        :param start_date: Return all prices for each interval on and after this day. Defaults to today.
        :type start_date: date
        :param end_date: Return all prices for each interval on and before this day. Defaults to today.
        :type end_date: date
        :param resolution: Specify the required interval duration resolution. Valid options: 5, 30. Default: Your billing interval length.
        :type resolution: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[Interval]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_prices_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_prices_with_http_info(
            site_id, start_date, end_date, resolution, **kwargs
        )  # noqa: E501

    @validate_arguments
    def get_prices_with_http_info(
        self,
        site_id: Annotated[
            StrictStr,
            Field(
                ...,
                description="ID of the site you are fetching prices for. Can be found using the `/sites` endpoint",
            ),
        ],
        start_date: Annotated[
            Optional[date],
            Field(
                description="Return all prices for each interval on and after this day. Defaults to today."
            ),
        ] = None,
        end_date: Annotated[
            Optional[date],
            Field(
                description="Return all prices for each interval on and before this day. Defaults to today."
            ),
        ] = None,
        resolution: Annotated[
            Optional[StrictInt],
            Field(
                description="Specify the required interval duration resolution. Valid options: 5, 30. Default: Your billing interval length."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """get_prices  # noqa: E501

        Returns all the prices between the start and end dates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_prices_with_http_info(site_id, start_date, end_date, resolution, async_req=True)
        >>> result = thread.get()

        :param site_id: ID of the site you are fetching prices for. Can be found using the `/sites` endpoint (required)
        :type site_id: str
        :param start_date: Return all prices for each interval on and after this day. Defaults to today.
        :type start_date: date
        :param end_date: Return all prices for each interval on and before this day. Defaults to today.
        :type end_date: date
        :param resolution: Specify the required interval duration resolution. Valid options: 5, 30. Default: Your billing interval length.
        :type resolution: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[Interval], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["site_id", "start_date", "end_date", "resolution"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_prices" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["site_id"] is not None:
            _path_params["siteId"] = _params["site_id"]

        # process the query parameters
        _query_params = []
        if _params.get("start_date") is not None:  # noqa: E501
            if isinstance(_params["start_date"], date):
                _query_params.append(
                    (
                        "startDate",
                        _params["start_date"].strftime(
                            self.api_client.configuration.date_format
                        ),
                    )
                )
            else:
                _query_params.append(("startDate", _params["start_date"]))

        if _params.get("end_date") is not None:  # noqa: E501
            if isinstance(_params["end_date"], date):
                _query_params.append(
                    (
                        "endDate",
                        _params["end_date"].strftime(
                            self.api_client.configuration.date_format
                        ),
                    )
                )
            else:
                _query_params.append(("endDate", _params["end_date"]))

        if _params.get("resolution") is not None:  # noqa: E501
            _query_params.append(("resolution", _params["resolution"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["apiKey"]  # noqa: E501

        _response_types_map = {
            "200": "List[Interval]",
            "400": None,
            "401": None,
            "404": None,
            "500": None,
        }

        return self.api_client.call_api(
            "/sites/{siteId}/prices",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_sites(self, **kwargs) -> List[Site]:  # noqa: E501
        """get_sites  # noqa: E501

        Return all sites linked to your account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sites(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[Site]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_sites_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_sites_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_sites_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_sites  # noqa: E501

        Return all sites linked to your account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sites_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[Site], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sites" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["apiKey"]  # noqa: E501

        _response_types_map = {
            "200": "List[Site]",
            "401": None,
            "500": None,
        }

        return self.api_client.call_api(
            "/sites",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_usage(
        self,
        site_id: Annotated[
            StrictStr,
            Field(
                ...,
                description="ID of the site you are fetching usage for. Can be found using the `/sites` enpoint",
            ),
        ],
        start_date: Annotated[
            date,
            Field(
                ...,
                description="Return all usage for each interval on and after this day.",
            ),
        ],
        end_date: Annotated[
            date,
            Field(
                ...,
                description="Return all usage for each interval on and before this day.",
            ),
        ],
        resolution: Annotated[
            Optional[StrictInt],
            Field(
                description="Deprecated. Usage will always be returned in your billing interval length. If you supply this parameter, it will be ignored."
            ),
        ] = None,
        **kwargs
    ) -> List[Usage]:  # noqa: E501
        """get_usage  # noqa: E501

        Returns all usage data between the start and end dates. The API can only return 90-days worth of data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage(site_id, start_date, end_date, resolution, async_req=True)
        >>> result = thread.get()

        :param site_id: ID of the site you are fetching usage for. Can be found using the `/sites` enpoint (required)
        :type site_id: str
        :param start_date: Return all usage for each interval on and after this day. (required)
        :type start_date: date
        :param end_date: Return all usage for each interval on and before this day. (required)
        :type end_date: date
        :param resolution: Deprecated. Usage will always be returned in your billing interval length. If you supply this parameter, it will be ignored.
        :type resolution: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[Usage]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_usage_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_usage_with_http_info(
            site_id, start_date, end_date, resolution, **kwargs
        )  # noqa: E501

    @validate_arguments
    def get_usage_with_http_info(
        self,
        site_id: Annotated[
            StrictStr,
            Field(
                ...,
                description="ID of the site you are fetching usage for. Can be found using the `/sites` enpoint",
            ),
        ],
        start_date: Annotated[
            date,
            Field(
                ...,
                description="Return all usage for each interval on and after this day.",
            ),
        ],
        end_date: Annotated[
            date,
            Field(
                ...,
                description="Return all usage for each interval on and before this day.",
            ),
        ],
        resolution: Annotated[
            Optional[StrictInt],
            Field(
                description="Deprecated. Usage will always be returned in your billing interval length. If you supply this parameter, it will be ignored."
            ),
        ] = None,
        **kwargs
    ) -> ApiResponse:  # noqa: E501
        """get_usage  # noqa: E501

        Returns all usage data between the start and end dates. The API can only return 90-days worth of data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_with_http_info(site_id, start_date, end_date, resolution, async_req=True)
        >>> result = thread.get()

        :param site_id: ID of the site you are fetching usage for. Can be found using the `/sites` enpoint (required)
        :type site_id: str
        :param start_date: Return all usage for each interval on and after this day. (required)
        :type start_date: date
        :param end_date: Return all usage for each interval on and before this day. (required)
        :type end_date: date
        :param resolution: Deprecated. Usage will always be returned in your billing interval length. If you supply this parameter, it will be ignored.
        :type resolution: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[Usage], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["site_id", "start_date", "end_date", "resolution"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_usage" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["site_id"] is not None:
            _path_params["siteId"] = _params["site_id"]

        # process the query parameters
        _query_params = []
        if _params.get("start_date") is not None:  # noqa: E501
            if isinstance(_params["start_date"], date):
                _query_params.append(
                    (
                        "startDate",
                        _params["start_date"].strftime(
                            self.api_client.configuration.date_format
                        ),
                    )
                )
            else:
                _query_params.append(("startDate", _params["start_date"]))

        if _params.get("end_date") is not None:  # noqa: E501
            if isinstance(_params["end_date"], date):
                _query_params.append(
                    (
                        "endDate",
                        _params["end_date"].strftime(
                            self.api_client.configuration.date_format
                        ),
                    )
                )
            else:
                _query_params.append(("endDate", _params["end_date"]))

        if _params.get("resolution") is not None:  # noqa: E501
            _query_params.append(("resolution", _params["resolution"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["apiKey"]  # noqa: E501

        _response_types_map = {
            "200": "List[Usage]",
            "400": None,
            "401": None,
            "404": None,
            "500": None,
        }

        return self.api_client.call_api(
            "/sites/{siteId}/usage",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
