# coding: utf-8

"""
    Amber Electric Public API

    Amber is an Australian-based electricity retailer that pass through the real-time wholesale price of energy.  Because of Amber's wholesale power prices, you can save hundreds of dollars a year by automating high power devices like air-conditioners, heat pumps and pool pumps.  This Python library provides an interface to the API, allowing you to react to current and forecast prices, as well as download your historic usage.

    The version of the OpenAPI document: 2.0.0
    Contact: dev@amber.com.au
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

try:

    from pydantic.v1 import BaseModel, Field, StrictStr, ValidationError, validator
except ImportError:

    from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from amberelectric.models.actual_renewable import ActualRenewable
from amberelectric.models.current_renewable import CurrentRenewable
from amberelectric.models.forecast_renewable import ForecastRenewable
from typing import Union, Any, List, TYPE_CHECKING

RENEWABLE_ONE_OF_SCHEMAS = ["ActualRenewable", "CurrentRenewable", "ForecastRenewable"]


class Renewable(BaseModel):
    """
    Renewable
    """

    # data type: ActualRenewable
    oneof_schema_1_validator: Optional[ActualRenewable] = None
    # data type: CurrentRenewable
    oneof_schema_2_validator: Optional[CurrentRenewable] = None
    # data type: ForecastRenewable
    oneof_schema_3_validator: Optional[ForecastRenewable] = None
    if TYPE_CHECKING:
        actual_instance: Union[ActualRenewable, CurrentRenewable, ForecastRenewable]
    else:
        actual_instance: Any
    one_of_schemas: List[str] = Field(RENEWABLE_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError(
                    "If a position argument is used, only 1 is allowed to set `actual_instance`"
                )
            if kwargs:
                raise ValueError(
                    "If a position argument is used, keyword arguments cannot be used."
                )
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator("actual_instance")
    def actual_instance_must_validate_oneof(cls, v):
        instance = Renewable.construct()
        error_messages = []
        match = 0
        # validate data type: ActualRenewable
        if not isinstance(v, ActualRenewable):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `ActualRenewable`"
            )
        else:
            match += 1
        # validate data type: CurrentRenewable
        if not isinstance(v, CurrentRenewable):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CurrentRenewable`"
            )
        else:
            match += 1
        # validate data type: ForecastRenewable
        if not isinstance(v, ForecastRenewable):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `ForecastRenewable`"
            )
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when setting `actual_instance` in Renewable with oneOf schemas: ActualRenewable, CurrentRenewable, ForecastRenewable. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when setting `actual_instance` in Renewable with oneOf schemas: ActualRenewable, CurrentRenewable, ForecastRenewable. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> Renewable:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Renewable:
        """Returns the object represented by the json string"""
        instance = Renewable.construct()
        error_messages = []
        match = 0

        # deserialize data into ActualRenewable
        try:
            instance.actual_instance = ActualRenewable.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CurrentRenewable
        try:
            instance.actual_instance = CurrentRenewable.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ForecastRenewable
        try:
            instance.actual_instance = ForecastRenewable.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when deserializing the JSON string into Renewable with oneOf schemas: ActualRenewable, CurrentRenewable, ForecastRenewable. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into Renewable with oneOf schemas: ActualRenewable, CurrentRenewable, ForecastRenewable. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())
