# coding: utf-8

"""
    Amber Electric Public API

    Amber is an Australian-based electricity retailer that pass through the real-time wholesale price of energy.  Because of Amber's wholesale power prices, you can save hundreds of dollars a year by automating high power devices like air-conditioners, heat pumps and pool pumps.  This Python library provides an interface to the API, allowing you to react to current and forecast prices, as well as download your historic usage.

    The version of the OpenAPI document: 2.0.0
    Contact: dev@amber.com.au
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional

try:

    from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr, confloat, validator
except ImportError:

    from pydantic import BaseModel, Field, StrictBool, StrictStr, confloat, validator


class TariffInformation(BaseModel):
    """
    Information about how your tariff affects an interval  # noqa: E501
    """

    period: Optional[StrictStr] = Field(
        default=None,
        description="The Time of Use period that is currently active. Only available if the site in on a time of use tariff",
    )
    season: Optional[StrictStr] = Field(
        default=None,
        description="The Time of Use season that is currently active. Only available if the site in on a time of use tariff",
    )
    block: Optional[confloat(le=2, ge=1)] = Field(
        default=None,
        description="The block that is currently active. Only available in the site in on a block tariff",
    )
    demand_window: Optional[StrictBool] = Field(
        default=None,
        alias="demandWindow",
        description="Is this interval currently in the demand window? Only available if the site in on a demand tariff",
    )
    __properties = ["period", "season", "block", "demandWindow"]

    @validator("period")
    def period_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("offPeak", "shoulder", "solarSponge", "peak"):
            raise ValueError(
                "must be one of enum values ('offPeak', 'shoulder', 'solarSponge', 'peak')"
            )
        return value

    @validator("season")
    def season_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "default",
            "summer",
            "autumn",
            "winter",
            "spring",
            "nonSummer",
            "holiday",
            "weekend",
            "weekendHoliday",
            "weekday",
        ):
            raise ValueError(
                "must be one of enum values ('default', 'summer', 'autumn', 'winter', 'spring', 'nonSummer', 'holiday', 'weekend', 'weekendHoliday', 'weekday')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TariffInformation:
        """Create an instance of TariffInformation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TariffInformation:
        """Create an instance of TariffInformation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TariffInformation.parse_obj(obj)

        _obj = TariffInformation.parse_obj(
            {
                "period": obj.get("period"),
                "season": obj.get("season"),
                "block": obj.get("block"),
                "demand_window": obj.get("demandWindow"),
            }
        )
        return _obj
