# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRemediationRunApplicationDependencyRecommendationsResult',
    'AwaitableGetRemediationRunApplicationDependencyRecommendationsResult',
    'get_remediation_run_application_dependency_recommendations',
    'get_remediation_run_application_dependency_recommendations_output',
]

@pulumi.output_type
class GetRemediationRunApplicationDependencyRecommendationsResult:
    """
    A collection of values returned by getRemediationRunApplicationDependencyRecommendations.
    """
    def __init__(__self__, application_dependency_recommendation_collections=None, filters=None, gav=None, id=None, purl=None, remediation_run_id=None):
        if application_dependency_recommendation_collections and not isinstance(application_dependency_recommendation_collections, list):
            raise TypeError("Expected argument 'application_dependency_recommendation_collections' to be a list")
        pulumi.set(__self__, "application_dependency_recommendation_collections", application_dependency_recommendation_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if gav and not isinstance(gav, str):
            raise TypeError("Expected argument 'gav' to be a str")
        pulumi.set(__self__, "gav", gav)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if purl and not isinstance(purl, str):
            raise TypeError("Expected argument 'purl' to be a str")
        pulumi.set(__self__, "purl", purl)
        if remediation_run_id and not isinstance(remediation_run_id, str):
            raise TypeError("Expected argument 'remediation_run_id' to be a str")
        pulumi.set(__self__, "remediation_run_id", remediation_run_id)

    @property
    @pulumi.getter(name="applicationDependencyRecommendationCollections")
    def application_dependency_recommendation_collections(self) -> Sequence['outputs.GetRemediationRunApplicationDependencyRecommendationsApplicationDependencyRecommendationCollectionResult']:
        """
        The list of application_dependency_recommendation_collection.
        """
        return pulumi.get(self, "application_dependency_recommendation_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRemediationRunApplicationDependencyRecommendationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def gav(self) -> Optional[builtins.str]:
        """
        Unique Group Artifact Version (GAV) identifier in the format _Group:Artifact:Version_, e.g. org.graalvm.nativeimage:svm:21.1.0.
        """
        return pulumi.get(self, "gav")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def purl(self) -> Optional[builtins.str]:
        """
        Package URL identifier, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.1.0
        """
        return pulumi.get(self, "purl")

    @property
    @pulumi.getter(name="remediationRunId")
    def remediation_run_id(self) -> builtins.str:
        return pulumi.get(self, "remediation_run_id")


class AwaitableGetRemediationRunApplicationDependencyRecommendationsResult(GetRemediationRunApplicationDependencyRecommendationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRemediationRunApplicationDependencyRecommendationsResult(
            application_dependency_recommendation_collections=self.application_dependency_recommendation_collections,
            filters=self.filters,
            gav=self.gav,
            id=self.id,
            purl=self.purl,
            remediation_run_id=self.remediation_run_id)


def get_remediation_run_application_dependency_recommendations(filters: Optional[Sequence[Union['GetRemediationRunApplicationDependencyRecommendationsFilterArgs', 'GetRemediationRunApplicationDependencyRecommendationsFilterArgsDict']]] = None,
                                                               gav: Optional[builtins.str] = None,
                                                               purl: Optional[builtins.str] = None,
                                                               remediation_run_id: Optional[builtins.str] = None,
                                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRemediationRunApplicationDependencyRecommendationsResult:
    """
    This data source provides the list of Remediation Run Application Dependency Recommendations in Oracle Cloud Infrastructure Adm service.

    Returns a list of application dependency with their associated recommendations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_remediation_run_application_dependency_recommendations = oci.Adm.get_remediation_run_application_dependency_recommendations(remediation_run_id=test_remediation_run["id"],
        gav=remediation_run_application_dependency_recommendation_gav,
        purl=remediation_run_application_dependency_recommendation_purl)
    ```


    :param builtins.str gav: A filter to return only resources that match the entire GAV (Group Artifact Version) identifier given.
    :param builtins.str purl: A filter to return only resources that match the entire purl given.
    :param builtins.str remediation_run_id: Unique Remediation Run identifier path parameter.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['gav'] = gav
    __args__['purl'] = purl
    __args__['remediationRunId'] = remediation_run_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Adm/getRemediationRunApplicationDependencyRecommendations:getRemediationRunApplicationDependencyRecommendations', __args__, opts=opts, typ=GetRemediationRunApplicationDependencyRecommendationsResult).value

    return AwaitableGetRemediationRunApplicationDependencyRecommendationsResult(
        application_dependency_recommendation_collections=pulumi.get(__ret__, 'application_dependency_recommendation_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        gav=pulumi.get(__ret__, 'gav'),
        id=pulumi.get(__ret__, 'id'),
        purl=pulumi.get(__ret__, 'purl'),
        remediation_run_id=pulumi.get(__ret__, 'remediation_run_id'))
def get_remediation_run_application_dependency_recommendations_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRemediationRunApplicationDependencyRecommendationsFilterArgs', 'GetRemediationRunApplicationDependencyRecommendationsFilterArgsDict']]]]] = None,
                                                                      gav: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                                      purl: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                                      remediation_run_id: Optional[pulumi.Input[builtins.str]] = None,
                                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRemediationRunApplicationDependencyRecommendationsResult]:
    """
    This data source provides the list of Remediation Run Application Dependency Recommendations in Oracle Cloud Infrastructure Adm service.

    Returns a list of application dependency with their associated recommendations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_remediation_run_application_dependency_recommendations = oci.Adm.get_remediation_run_application_dependency_recommendations(remediation_run_id=test_remediation_run["id"],
        gav=remediation_run_application_dependency_recommendation_gav,
        purl=remediation_run_application_dependency_recommendation_purl)
    ```


    :param builtins.str gav: A filter to return only resources that match the entire GAV (Group Artifact Version) identifier given.
    :param builtins.str purl: A filter to return only resources that match the entire purl given.
    :param builtins.str remediation_run_id: Unique Remediation Run identifier path parameter.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['gav'] = gav
    __args__['purl'] = purl
    __args__['remediationRunId'] = remediation_run_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Adm/getRemediationRunApplicationDependencyRecommendations:getRemediationRunApplicationDependencyRecommendations', __args__, opts=opts, typ=GetRemediationRunApplicationDependencyRecommendationsResult)
    return __ret__.apply(lambda __response__: GetRemediationRunApplicationDependencyRecommendationsResult(
        application_dependency_recommendation_collections=pulumi.get(__response__, 'application_dependency_recommendation_collections'),
        filters=pulumi.get(__response__, 'filters'),
        gav=pulumi.get(__response__, 'gav'),
        id=pulumi.get(__response__, 'id'),
        purl=pulumi.get(__response__, 'purl'),
        remediation_run_id=pulumi.get(__response__, 'remediation_run_id')))
