# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOnPremiseVantagePointWorkersResult',
    'AwaitableGetOnPremiseVantagePointWorkersResult',
    'get_on_premise_vantage_point_workers',
    'get_on_premise_vantage_point_workers_output',
]

@pulumi.output_type
class GetOnPremiseVantagePointWorkersResult:
    """
    A collection of values returned by getOnPremiseVantagePointWorkers.
    """
    def __init__(__self__, apm_domain_id=None, capability=None, display_name=None, filters=None, id=None, name=None, on_premise_vantage_point_id=None, status=None, worker_collections=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if capability and not isinstance(capability, str):
            raise TypeError("Expected argument 'capability' to be a str")
        pulumi.set(__self__, "capability", capability)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if on_premise_vantage_point_id and not isinstance(on_premise_vantage_point_id, str):
            raise TypeError("Expected argument 'on_premise_vantage_point_id' to be a str")
        pulumi.set(__self__, "on_premise_vantage_point_id", on_premise_vantage_point_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if worker_collections and not isinstance(worker_collections, list):
            raise TypeError("Expected argument 'worker_collections' to be a list")
        pulumi.set(__self__, "worker_collections", worker_collections)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> builtins.str:
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter
    def capability(self) -> Optional[builtins.str]:
        return pulumi.get(self, "capability")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOnPremiseVantagePointWorkersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Unique permanent name of the On-premise VP worker. This is the same as the displayName.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onPremiseVantagePointId")
    def on_premise_vantage_point_id(self) -> builtins.str:
        return pulumi.get(self, "on_premise_vantage_point_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Enables or disables the On-premise VP worker.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="workerCollections")
    def worker_collections(self) -> Sequence['outputs.GetOnPremiseVantagePointWorkersWorkerCollectionResult']:
        """
        The list of worker_collection.
        """
        return pulumi.get(self, "worker_collections")


class AwaitableGetOnPremiseVantagePointWorkersResult(GetOnPremiseVantagePointWorkersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOnPremiseVantagePointWorkersResult(
            apm_domain_id=self.apm_domain_id,
            capability=self.capability,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            name=self.name,
            on_premise_vantage_point_id=self.on_premise_vantage_point_id,
            status=self.status,
            worker_collections=self.worker_collections)


def get_on_premise_vantage_point_workers(apm_domain_id: Optional[builtins.str] = None,
                                         capability: Optional[builtins.str] = None,
                                         display_name: Optional[builtins.str] = None,
                                         filters: Optional[Sequence[Union['GetOnPremiseVantagePointWorkersFilterArgs', 'GetOnPremiseVantagePointWorkersFilterArgsDict']]] = None,
                                         name: Optional[builtins.str] = None,
                                         on_premise_vantage_point_id: Optional[builtins.str] = None,
                                         status: Optional[builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOnPremiseVantagePointWorkersResult:
    """
    This data source provides the list of On Premise Vantage Point Workers in Oracle Cloud Infrastructure APM Availability Monitoring service (aka APM Synthetics Service).

    Returns a list of workers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_on_premise_vantage_point_workers = oci.ApmSynthetics.get_on_premise_vantage_point_workers(apm_domain_id=test_apm_domain["id"],
        on_premise_vantage_point_id=test_on_premise_vantage_point["id"],
        capability=on_premise_vantage_point_worker_capability,
        display_name=on_premise_vantage_point_worker_display_name,
        name=on_premise_vantage_point_worker_name,
        status=on_premise_vantage_point_worker_status)
    ```


    :param builtins.str apm_domain_id: The APM domain ID the request is intended for.
    :param builtins.str capability: A filter to return only On-premise VP workers that match the capability given.
    :param builtins.str display_name: A filter to return only the resources that match the entire display name.
    :param builtins.str name: A filter to return only the resources that match the entire name.
    :param builtins.str on_premise_vantage_point_id: The OCID of the On-premise vantage point.
    :param builtins.str status: A filter to return only On-premise VP workers that match the status given.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['capability'] = capability
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['onPremiseVantagePointId'] = on_premise_vantage_point_id
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmSynthetics/getOnPremiseVantagePointWorkers:getOnPremiseVantagePointWorkers', __args__, opts=opts, typ=GetOnPremiseVantagePointWorkersResult).value

    return AwaitableGetOnPremiseVantagePointWorkersResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        capability=pulumi.get(__ret__, 'capability'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        on_premise_vantage_point_id=pulumi.get(__ret__, 'on_premise_vantage_point_id'),
        status=pulumi.get(__ret__, 'status'),
        worker_collections=pulumi.get(__ret__, 'worker_collections'))
def get_on_premise_vantage_point_workers_output(apm_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                                                capability: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOnPremiseVantagePointWorkersFilterArgs', 'GetOnPremiseVantagePointWorkersFilterArgsDict']]]]] = None,
                                                name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                on_premise_vantage_point_id: Optional[pulumi.Input[builtins.str]] = None,
                                                status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOnPremiseVantagePointWorkersResult]:
    """
    This data source provides the list of On Premise Vantage Point Workers in Oracle Cloud Infrastructure APM Availability Monitoring service (aka APM Synthetics Service).

    Returns a list of workers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_on_premise_vantage_point_workers = oci.ApmSynthetics.get_on_premise_vantage_point_workers(apm_domain_id=test_apm_domain["id"],
        on_premise_vantage_point_id=test_on_premise_vantage_point["id"],
        capability=on_premise_vantage_point_worker_capability,
        display_name=on_premise_vantage_point_worker_display_name,
        name=on_premise_vantage_point_worker_name,
        status=on_premise_vantage_point_worker_status)
    ```


    :param builtins.str apm_domain_id: The APM domain ID the request is intended for.
    :param builtins.str capability: A filter to return only On-premise VP workers that match the capability given.
    :param builtins.str display_name: A filter to return only the resources that match the entire display name.
    :param builtins.str name: A filter to return only the resources that match the entire name.
    :param builtins.str on_premise_vantage_point_id: The OCID of the On-premise vantage point.
    :param builtins.str status: A filter to return only On-premise VP workers that match the status given.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['capability'] = capability
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['onPremiseVantagePointId'] = on_premise_vantage_point_id
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApmSynthetics/getOnPremiseVantagePointWorkers:getOnPremiseVantagePointWorkers', __args__, opts=opts, typ=GetOnPremiseVantagePointWorkersResult)
    return __ret__.apply(lambda __response__: GetOnPremiseVantagePointWorkersResult(
        apm_domain_id=pulumi.get(__response__, 'apm_domain_id'),
        capability=pulumi.get(__response__, 'capability'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        on_premise_vantage_point_id=pulumi.get(__response__, 'on_premise_vantage_point_id'),
        status=pulumi.get(__response__, 'status'),
        worker_collections=pulumi.get(__response__, 'worker_collections')))
