# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ContainerConfigurationArgs', 'ContainerConfiguration']

@pulumi.input_type
class ContainerConfigurationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 is_repository_created_on_first_push: pulumi.Input[builtins.bool]):
        """
        The set of arguments for constructing a ContainerConfiguration resource.
        :param pulumi.Input[builtins.bool] is_repository_created_on_first_push: Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "is_repository_created_on_first_push", is_repository_created_on_first_push)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isRepositoryCreatedOnFirstPush")
    def is_repository_created_on_first_push(self) -> pulumi.Input[builtins.bool]:
        """
        Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        """
        return pulumi.get(self, "is_repository_created_on_first_push")

    @is_repository_created_on_first_push.setter
    def is_repository_created_on_first_push(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_repository_created_on_first_push", value)


@pulumi.input_type
class _ContainerConfigurationState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_repository_created_on_first_push: Optional[pulumi.Input[builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ContainerConfiguration resources.
        :param pulumi.Input[builtins.bool] is_repository_created_on_first_push: Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        :param pulumi.Input[builtins.str] namespace: The tenancy namespace used in the container repository path.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if is_repository_created_on_first_push is not None:
            pulumi.set(__self__, "is_repository_created_on_first_push", is_repository_created_on_first_push)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isRepositoryCreatedOnFirstPush")
    def is_repository_created_on_first_push(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        """
        return pulumi.get(self, "is_repository_created_on_first_push")

    @is_repository_created_on_first_push.setter
    def is_repository_created_on_first_push(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_repository_created_on_first_push", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The tenancy namespace used in the container repository path.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)


@pulumi.type_token("oci:Artifacts/containerConfiguration:ContainerConfiguration")
class ContainerConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_repository_created_on_first_push: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        This resource provides the Container Configuration resource in Oracle Cloud Infrastructure Artifacts service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_container_configuration = oci.artifacts.ContainerConfiguration("test_container_configuration")
        ```

        ## Import

        ContainerConfiguration can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Artifacts/containerConfiguration:ContainerConfiguration test_container_configuration "container/configuration/compartmentId/{compartmentId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] is_repository_created_on_first_push: Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Container Configuration resource in Oracle Cloud Infrastructure Artifacts service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_container_configuration = oci.artifacts.ContainerConfiguration("test_container_configuration")
        ```

        ## Import

        ContainerConfiguration can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Artifacts/containerConfiguration:ContainerConfiguration test_container_configuration "container/configuration/compartmentId/{compartmentId}"
        ```

        :param str resource_name: The name of the resource.
        :param ContainerConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_repository_created_on_first_push: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerConfigurationArgs.__new__(ContainerConfigurationArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if is_repository_created_on_first_push is None and not opts.urn:
                raise TypeError("Missing required property 'is_repository_created_on_first_push'")
            __props__.__dict__["is_repository_created_on_first_push"] = is_repository_created_on_first_push
            __props__.__dict__["namespace"] = None
        super(ContainerConfiguration, __self__).__init__(
            'oci:Artifacts/containerConfiguration:ContainerConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            is_repository_created_on_first_push: Optional[pulumi.Input[builtins.bool]] = None,
            namespace: Optional[pulumi.Input[builtins.str]] = None) -> 'ContainerConfiguration':
        """
        Get an existing ContainerConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] is_repository_created_on_first_push: Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        :param pulumi.Input[builtins.str] namespace: The tenancy namespace used in the container repository path.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerConfigurationState.__new__(_ContainerConfigurationState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["is_repository_created_on_first_push"] = is_repository_created_on_first_push
        __props__.__dict__["namespace"] = namespace
        return ContainerConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="isRepositoryCreatedOnFirstPush")
    def is_repository_created_on_first_push(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        """
        return pulumi.get(self, "is_repository_created_on_first_push")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[builtins.str]:
        """
        The tenancy namespace used in the container repository path.
        """
        return pulumi.get(self, "namespace")

