# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BdsInstanceNodeBackupArgs', 'BdsInstanceNodeBackup']

@pulumi.input_type
class BdsInstanceNodeBackupArgs:
    def __init__(__self__, *,
                 backup_type: pulumi.Input[builtins.str],
                 bds_instance_id: pulumi.Input[builtins.str],
                 level_type_details: pulumi.Input['BdsInstanceNodeBackupLevelTypeDetailsArgs'],
                 backup_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 node_instance_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a BdsInstanceNodeBackup resource.
        :param pulumi.Input[builtins.str] backup_type: Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input['BdsInstanceNodeBackupLevelTypeDetailsArgs'] level_type_details: Details of the type of level used to trigger the creation of a new node backup.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        pulumi.set(__self__, "level_type_details", level_type_details)
        if backup_config_id is not None:
            pulumi.set(__self__, "backup_config_id", backup_config_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if node_instance_id is not None:
            pulumi.set(__self__, "node_instance_id", node_instance_id)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Input[builtins.str]:
        """
        Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "backup_type", value)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="levelTypeDetails")
    def level_type_details(self) -> pulumi.Input['BdsInstanceNodeBackupLevelTypeDetailsArgs']:
        """
        Details of the type of level used to trigger the creation of a new node backup.
        """
        return pulumi.get(self, "level_type_details")

    @level_type_details.setter
    def level_type_details(self, value: pulumi.Input['BdsInstanceNodeBackupLevelTypeDetailsArgs']):
        pulumi.set(self, "level_type_details", value)

    @property
    @pulumi.getter(name="backupConfigId")
    def backup_config_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "backup_config_id")

    @backup_config_id.setter
    def backup_config_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_config_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="nodeInstanceId")
    def node_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "node_instance_id")

    @node_instance_id.setter
    def node_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_instance_id", value)


@pulumi.input_type
class _BdsInstanceNodeBackupState:
    def __init__(__self__, *,
                 backup_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 backup_type: Optional[pulumi.Input[builtins.str]] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 level_type_details: Optional[pulumi.Input['BdsInstanceNodeBackupLevelTypeDetailsArgs']] = None,
                 node_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BdsInstanceNodeBackup resources.
        :param pulumi.Input[builtins.str] backup_type: Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input['BdsInstanceNodeBackupLevelTypeDetailsArgs'] level_type_details: Details of the type of level used to trigger the creation of a new node backup.
        :param pulumi.Input[builtins.str] state: The state of the NodeBackup.
        :param pulumi.Input[builtins.str] time_created: The time the NodeBackup was created, shown as an RFC 3339 formatted datetime string.
        """
        if backup_config_id is not None:
            pulumi.set(__self__, "backup_config_id", backup_config_id)
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if bds_instance_id is not None:
            pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if level_type_details is not None:
            pulumi.set(__self__, "level_type_details", level_type_details)
        if node_instance_id is not None:
            pulumi.set(__self__, "node_instance_id", node_instance_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="backupConfigId")
    def backup_config_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "backup_config_id")

    @backup_config_id.setter
    def backup_config_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_config_id", value)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_type", value)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="levelTypeDetails")
    def level_type_details(self) -> Optional[pulumi.Input['BdsInstanceNodeBackupLevelTypeDetailsArgs']]:
        """
        Details of the type of level used to trigger the creation of a new node backup.
        """
        return pulumi.get(self, "level_type_details")

    @level_type_details.setter
    def level_type_details(self, value: Optional[pulumi.Input['BdsInstanceNodeBackupLevelTypeDetailsArgs']]):
        pulumi.set(self, "level_type_details", value)

    @property
    @pulumi.getter(name="nodeInstanceId")
    def node_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "node_instance_id")

    @node_instance_id.setter
    def node_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_instance_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the NodeBackup.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the NodeBackup was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:BigDataService/bdsInstanceNodeBackup:BdsInstanceNodeBackup")
class BdsInstanceNodeBackup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 backup_type: Optional[pulumi.Input[builtins.str]] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 level_type_details: Optional[pulumi.Input[Union['BdsInstanceNodeBackupLevelTypeDetailsArgs', 'BdsInstanceNodeBackupLevelTypeDetailsArgsDict']]] = None,
                 node_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Bds Instance Node Backup resource in Oracle Cloud Infrastructure Big Data Service service.

        Add a node volume backup to the cluster for an indicated node type or node.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_node_backup = oci.big_data_service.BdsInstanceNodeBackup("test_bds_instance_node_backup",
            bds_instance_id=test_bds_instance["id"],
            level_type_details={
                "level_type": bds_instance_node_backup_level_type_details_level_type,
                "node_host_name": bds_instance_node_backup_level_type_details_node_host_name,
                "node_type": bds_instance_node_backup_level_type_details_node_type,
            },
            backup_type=bds_instance_node_backup_backup_type)
        ```

        ## Import

        BdsInstanceNodeBackupConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstanceNodeBackup:BdsInstanceNodeBackup test_bds_instance_node_backup "bdsInstances/{bdsInstanceId}/nodeBackup/{nodeBackupId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backup_type: Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[Union['BdsInstanceNodeBackupLevelTypeDetailsArgs', 'BdsInstanceNodeBackupLevelTypeDetailsArgsDict']] level_type_details: Details of the type of level used to trigger the creation of a new node backup.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsInstanceNodeBackupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Bds Instance Node Backup resource in Oracle Cloud Infrastructure Big Data Service service.

        Add a node volume backup to the cluster for an indicated node type or node.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_node_backup = oci.big_data_service.BdsInstanceNodeBackup("test_bds_instance_node_backup",
            bds_instance_id=test_bds_instance["id"],
            level_type_details={
                "level_type": bds_instance_node_backup_level_type_details_level_type,
                "node_host_name": bds_instance_node_backup_level_type_details_node_host_name,
                "node_type": bds_instance_node_backup_level_type_details_node_type,
            },
            backup_type=bds_instance_node_backup_backup_type)
        ```

        ## Import

        BdsInstanceNodeBackupConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstanceNodeBackup:BdsInstanceNodeBackup test_bds_instance_node_backup "bdsInstances/{bdsInstanceId}/nodeBackup/{nodeBackupId}"
        ```

        :param str resource_name: The name of the resource.
        :param BdsInstanceNodeBackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsInstanceNodeBackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_config_id: Optional[pulumi.Input[builtins.str]] = None,
                 backup_type: Optional[pulumi.Input[builtins.str]] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 level_type_details: Optional[pulumi.Input[Union['BdsInstanceNodeBackupLevelTypeDetailsArgs', 'BdsInstanceNodeBackupLevelTypeDetailsArgsDict']]] = None,
                 node_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsInstanceNodeBackupArgs.__new__(BdsInstanceNodeBackupArgs)

            __props__.__dict__["backup_config_id"] = backup_config_id
            if backup_type is None and not opts.urn:
                raise TypeError("Missing required property 'backup_type'")
            __props__.__dict__["backup_type"] = backup_type
            if bds_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_instance_id'")
            __props__.__dict__["bds_instance_id"] = bds_instance_id
            __props__.__dict__["display_name"] = display_name
            if level_type_details is None and not opts.urn:
                raise TypeError("Missing required property 'level_type_details'")
            __props__.__dict__["level_type_details"] = level_type_details
            __props__.__dict__["node_instance_id"] = node_instance_id
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(BdsInstanceNodeBackup, __self__).__init__(
            'oci:BigDataService/bdsInstanceNodeBackup:BdsInstanceNodeBackup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_config_id: Optional[pulumi.Input[builtins.str]] = None,
            backup_type: Optional[pulumi.Input[builtins.str]] = None,
            bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            level_type_details: Optional[pulumi.Input[Union['BdsInstanceNodeBackupLevelTypeDetailsArgs', 'BdsInstanceNodeBackupLevelTypeDetailsArgsDict']]] = None,
            node_instance_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'BdsInstanceNodeBackup':
        """
        Get an existing BdsInstanceNodeBackup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backup_type: Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[Union['BdsInstanceNodeBackupLevelTypeDetailsArgs', 'BdsInstanceNodeBackupLevelTypeDetailsArgsDict']] level_type_details: Details of the type of level used to trigger the creation of a new node backup.
        :param pulumi.Input[builtins.str] state: The state of the NodeBackup.
        :param pulumi.Input[builtins.str] time_created: The time the NodeBackup was created, shown as an RFC 3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsInstanceNodeBackupState.__new__(_BdsInstanceNodeBackupState)

        __props__.__dict__["backup_config_id"] = backup_config_id
        __props__.__dict__["backup_type"] = backup_type
        __props__.__dict__["bds_instance_id"] = bds_instance_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["level_type_details"] = level_type_details
        __props__.__dict__["node_instance_id"] = node_instance_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return BdsInstanceNodeBackup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupConfigId")
    def backup_config_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "backup_config_id")

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Output[builtins.str]:
        """
        Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="levelTypeDetails")
    def level_type_details(self) -> pulumi.Output['outputs.BdsInstanceNodeBackupLevelTypeDetails']:
        """
        Details of the type of level used to trigger the creation of a new node backup.
        """
        return pulumi.get(self, "level_type_details")

    @property
    @pulumi.getter(name="nodeInstanceId")
    def node_instance_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "node_instance_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of the NodeBackup.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the NodeBackup was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "time_updated")

