# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BdsInstanceReplaceNodeActionArgs', 'BdsInstanceReplaceNodeAction']

@pulumi.input_type
class BdsInstanceReplaceNodeActionArgs:
    def __init__(__self__, *,
                 bds_instance_id: pulumi.Input[builtins.str],
                 cluster_admin_password: pulumi.Input[builtins.str],
                 node_backup_id: pulumi.Input[builtins.str],
                 node_host_name: pulumi.Input[builtins.str],
                 shape: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a BdsInstanceReplaceNodeAction resource.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.str] node_backup_id: The id of the nodeBackup to use for replacing the node.
        :param pulumi.Input[builtins.str] node_host_name: Host name of the node to replace. MASTER, UTILITY and EDGE node are only supported types
        :param pulumi.Input[builtins.str] shape: Shape of the new vm when replacing the node. If not provided, BDS will attempt to replace the node with the shape of current node.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        pulumi.set(__self__, "node_backup_id", node_backup_id)
        pulumi.set(__self__, "node_host_name", node_host_name)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Input[builtins.str]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="nodeBackupId")
    def node_backup_id(self) -> pulumi.Input[builtins.str]:
        """
        The id of the nodeBackup to use for replacing the node.
        """
        return pulumi.get(self, "node_backup_id")

    @node_backup_id.setter
    def node_backup_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_backup_id", value)

    @property
    @pulumi.getter(name="nodeHostName")
    def node_host_name(self) -> pulumi.Input[builtins.str]:
        """
        Host name of the node to replace. MASTER, UTILITY and EDGE node are only supported types
        """
        return pulumi.get(self, "node_host_name")

    @node_host_name.setter
    def node_host_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_host_name", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Shape of the new vm when replacing the node. If not provided, BDS will attempt to replace the node with the shape of current node.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shape", value)


@pulumi.input_type
class _BdsInstanceReplaceNodeActionState:
    def __init__(__self__, *,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 node_backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 node_host_name: Optional[pulumi.Input[builtins.str]] = None,
                 shape: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BdsInstanceReplaceNodeAction resources.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.str] node_backup_id: The id of the nodeBackup to use for replacing the node.
        :param pulumi.Input[builtins.str] node_host_name: Host name of the node to replace. MASTER, UTILITY and EDGE node are only supported types
        :param pulumi.Input[builtins.str] shape: Shape of the new vm when replacing the node. If not provided, BDS will attempt to replace the node with the shape of current node.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if bds_instance_id is not None:
            pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if cluster_admin_password is not None:
            pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if node_backup_id is not None:
            pulumi.set(__self__, "node_backup_id", node_backup_id)
        if node_host_name is not None:
            pulumi.set(__self__, "node_host_name", node_host_name)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="nodeBackupId")
    def node_backup_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the nodeBackup to use for replacing the node.
        """
        return pulumi.get(self, "node_backup_id")

    @node_backup_id.setter
    def node_backup_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_backup_id", value)

    @property
    @pulumi.getter(name="nodeHostName")
    def node_host_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Host name of the node to replace. MASTER, UTILITY and EDGE node are only supported types
        """
        return pulumi.get(self, "node_host_name")

    @node_host_name.setter
    def node_host_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_host_name", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Shape of the new vm when replacing the node. If not provided, BDS will attempt to replace the node with the shape of current node.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shape", value)


@pulumi.type_token("oci:BigDataService/bdsInstanceReplaceNodeAction:BdsInstanceReplaceNodeAction")
class BdsInstanceReplaceNodeAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 node_backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 node_host_name: Optional[pulumi.Input[builtins.str]] = None,
                 shape: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource replaces the node with the given hostname, in Oracle Cloud Infrastructure Big Data Service cluster.

        Replace the node with the given host name in the cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_replace_node_action = oci.big_data_service.BdsInstanceReplaceNodeAction("test_bds_instance_replace_node_action",
            bds_instance_id=test_bds_instance["id"],
            node_host_name=bds_instance_replace_node_action["nodeHostName"],
            node_backup_id=bds_instance_replace_node_action["nodeBackupId"],
            cluster_admin_password=test_bds_instance["clusterAdminPassword"],
            shape=shape)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.str] node_backup_id: The id of the nodeBackup to use for replacing the node.
        :param pulumi.Input[builtins.str] node_host_name: Host name of the node to replace. MASTER, UTILITY and EDGE node are only supported types
        :param pulumi.Input[builtins.str] shape: Shape of the new vm when replacing the node. If not provided, BDS will attempt to replace the node with the shape of current node.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsInstanceReplaceNodeActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource replaces the node with the given hostname, in Oracle Cloud Infrastructure Big Data Service cluster.

        Replace the node with the given host name in the cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_replace_node_action = oci.big_data_service.BdsInstanceReplaceNodeAction("test_bds_instance_replace_node_action",
            bds_instance_id=test_bds_instance["id"],
            node_host_name=bds_instance_replace_node_action["nodeHostName"],
            node_backup_id=bds_instance_replace_node_action["nodeBackupId"],
            cluster_admin_password=test_bds_instance["clusterAdminPassword"],
            shape=shape)
        ```

        :param str resource_name: The name of the resource.
        :param BdsInstanceReplaceNodeActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsInstanceReplaceNodeActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 node_backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 node_host_name: Optional[pulumi.Input[builtins.str]] = None,
                 shape: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsInstanceReplaceNodeActionArgs.__new__(BdsInstanceReplaceNodeActionArgs)

            if bds_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_instance_id'")
            __props__.__dict__["bds_instance_id"] = bds_instance_id
            if cluster_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_admin_password'")
            __props__.__dict__["cluster_admin_password"] = None if cluster_admin_password is None else pulumi.Output.secret(cluster_admin_password)
            if node_backup_id is None and not opts.urn:
                raise TypeError("Missing required property 'node_backup_id'")
            __props__.__dict__["node_backup_id"] = node_backup_id
            if node_host_name is None and not opts.urn:
                raise TypeError("Missing required property 'node_host_name'")
            __props__.__dict__["node_host_name"] = node_host_name
            __props__.__dict__["shape"] = shape
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clusterAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BdsInstanceReplaceNodeAction, __self__).__init__(
            'oci:BigDataService/bdsInstanceReplaceNodeAction:BdsInstanceReplaceNodeAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
            cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
            node_backup_id: Optional[pulumi.Input[builtins.str]] = None,
            node_host_name: Optional[pulumi.Input[builtins.str]] = None,
            shape: Optional[pulumi.Input[builtins.str]] = None) -> 'BdsInstanceReplaceNodeAction':
        """
        Get an existing BdsInstanceReplaceNodeAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.str] node_backup_id: The id of the nodeBackup to use for replacing the node.
        :param pulumi.Input[builtins.str] node_host_name: Host name of the node to replace. MASTER, UTILITY and EDGE node are only supported types
        :param pulumi.Input[builtins.str] shape: Shape of the new vm when replacing the node. If not provided, BDS will attempt to replace the node with the shape of current node.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsInstanceReplaceNodeActionState.__new__(_BdsInstanceReplaceNodeActionState)

        __props__.__dict__["bds_instance_id"] = bds_instance_id
        __props__.__dict__["cluster_admin_password"] = cluster_admin_password
        __props__.__dict__["node_backup_id"] = node_backup_id
        __props__.__dict__["node_host_name"] = node_host_name
        __props__.__dict__["shape"] = shape
        return BdsInstanceReplaceNodeAction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Output[builtins.str]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @property
    @pulumi.getter(name="nodeBackupId")
    def node_backup_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the nodeBackup to use for replacing the node.
        """
        return pulumi.get(self, "node_backup_id")

    @property
    @pulumi.getter(name="nodeHostName")
    def node_host_name(self) -> pulumi.Output[builtins.str]:
        """
        Host name of the node to replace. MASTER, UTILITY and EDGE node are only supported types
        """
        return pulumi.get(self, "node_host_name")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Shape of the new vm when replacing the node. If not provided, BDS will attempt to replace the node with the shape of current node.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "shape")

