# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBdsInstanceSoftwareUpdateResult',
    'AwaitableGetBdsInstanceSoftwareUpdateResult',
    'get_bds_instance_software_update',
    'get_bds_instance_software_update_output',
]

@pulumi.output_type
class GetBdsInstanceSoftwareUpdateResult:
    """
    A collection of values returned by getBdsInstanceSoftwareUpdate.
    """
    def __init__(__self__, bds_instance_id=None, id=None, software_update_key=None, software_update_type=None, software_update_version=None, state=None, time_due=None, time_released=None):
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if software_update_key and not isinstance(software_update_key, str):
            raise TypeError("Expected argument 'software_update_key' to be a str")
        pulumi.set(__self__, "software_update_key", software_update_key)
        if software_update_type and not isinstance(software_update_type, str):
            raise TypeError("Expected argument 'software_update_type' to be a str")
        pulumi.set(__self__, "software_update_type", software_update_type)
        if software_update_version and not isinstance(software_update_version, str):
            raise TypeError("Expected argument 'software_update_version' to be a str")
        pulumi.set(__self__, "software_update_version", software_update_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_due and not isinstance(time_due, str):
            raise TypeError("Expected argument 'time_due' to be a str")
        pulumi.set(__self__, "time_due", time_due)
        if time_released and not isinstance(time_released, str):
            raise TypeError("Expected argument 'time_released' to be a str")
        pulumi.set(__self__, "time_released", time_released)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> builtins.str:
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="softwareUpdateKey")
    def software_update_key(self) -> builtins.str:
        """
        Unique identifier of a given software update
        """
        return pulumi.get(self, "software_update_key")

    @property
    @pulumi.getter(name="softwareUpdateType")
    def software_update_type(self) -> builtins.str:
        """
        type of current software update.
        * Big Data Service's micro service. BDS version will be changed after upgrade.
        """
        return pulumi.get(self, "software_update_type")

    @property
    @pulumi.getter(name="softwareUpdateVersion")
    def software_update_version(self) -> builtins.str:
        """
        The version of the software update.
        """
        return pulumi.get(self, "software_update_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The lifecycle state of the software update.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeDue")
    def time_due(self) -> builtins.str:
        """
        The due date for the software update. Big Data Service will be updated automatically after this date.
        """
        return pulumi.get(self, "time_due")

    @property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> builtins.str:
        """
        The time when the software update was released.
        """
        return pulumi.get(self, "time_released")


class AwaitableGetBdsInstanceSoftwareUpdateResult(GetBdsInstanceSoftwareUpdateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceSoftwareUpdateResult(
            bds_instance_id=self.bds_instance_id,
            id=self.id,
            software_update_key=self.software_update_key,
            software_update_type=self.software_update_type,
            software_update_version=self.software_update_version,
            state=self.state,
            time_due=self.time_due,
            time_released=self.time_released)


def get_bds_instance_software_update(bds_instance_id: Optional[builtins.str] = None,
                                     software_update_key: Optional[builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceSoftwareUpdateResult:
    """
    This data source provides details about a specific Bds Instance Software Update resource in Oracle Cloud Infrastructure Big Data Service service.

    Get the details of the software update of the given SoftwareUpdateId

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_software_update = oci.BigDataService.get_bds_instance_software_update(bds_instance_id=test_bds_instance["id"],
        software_update_key=bds_instance_software_update_software_update_key)
    ```


    :param builtins.str bds_instance_id: The OCID of the cluster.
    :param builtins.str software_update_key: The unique identifier of the software update.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['softwareUpdateKey'] = software_update_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceSoftwareUpdate:getBdsInstanceSoftwareUpdate', __args__, opts=opts, typ=GetBdsInstanceSoftwareUpdateResult).value

    return AwaitableGetBdsInstanceSoftwareUpdateResult(
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        id=pulumi.get(__ret__, 'id'),
        software_update_key=pulumi.get(__ret__, 'software_update_key'),
        software_update_type=pulumi.get(__ret__, 'software_update_type'),
        software_update_version=pulumi.get(__ret__, 'software_update_version'),
        state=pulumi.get(__ret__, 'state'),
        time_due=pulumi.get(__ret__, 'time_due'),
        time_released=pulumi.get(__ret__, 'time_released'))
def get_bds_instance_software_update_output(bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                                            software_update_key: Optional[pulumi.Input[builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstanceSoftwareUpdateResult]:
    """
    This data source provides details about a specific Bds Instance Software Update resource in Oracle Cloud Infrastructure Big Data Service service.

    Get the details of the software update of the given SoftwareUpdateId

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_software_update = oci.BigDataService.get_bds_instance_software_update(bds_instance_id=test_bds_instance["id"],
        software_update_key=bds_instance_software_update_software_update_key)
    ```


    :param builtins.str bds_instance_id: The OCID of the cluster.
    :param builtins.str software_update_key: The unique identifier of the software update.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['softwareUpdateKey'] = software_update_key
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstanceSoftwareUpdate:getBdsInstanceSoftwareUpdate', __args__, opts=opts, typ=GetBdsInstanceSoftwareUpdateResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceSoftwareUpdateResult(
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        id=pulumi.get(__response__, 'id'),
        software_update_key=pulumi.get(__response__, 'software_update_key'),
        software_update_type=pulumi.get(__response__, 'software_update_type'),
        software_update_version=pulumi.get(__response__, 'software_update_version'),
        state=pulumi.get(__response__, 'state'),
        time_due=pulumi.get(__response__, 'time_due'),
        time_released=pulumi.get(__response__, 'time_released')))
