# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetApplianceImagesResult',
    'AwaitableGetApplianceImagesResult',
    'get_appliance_images',
    'get_appliance_images_output',
]

@pulumi.output_type
class GetApplianceImagesResult:
    """
    A collection of values returned by getApplianceImages.
    """
    def __init__(__self__, appliance_image_collections=None, compartment_id=None, display_name=None, filters=None, id=None):
        if appliance_image_collections and not isinstance(appliance_image_collections, list):
            raise TypeError("Expected argument 'appliance_image_collections' to be a list")
        pulumi.set(__self__, "appliance_image_collections", appliance_image_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="applianceImageCollections")
    def appliance_image_collections(self) -> Sequence['outputs.GetApplianceImagesApplianceImageCollectionResult']:
        """
        The list of appliance_image_collection.
        """
        return pulumi.get(self, "appliance_image_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The name of the image to be displayed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetApplianceImagesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetApplianceImagesResult(GetApplianceImagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplianceImagesResult(
            appliance_image_collections=self.appliance_image_collections,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id)


def get_appliance_images(compartment_id: Optional[builtins.str] = None,
                         display_name: Optional[builtins.str] = None,
                         filters: Optional[Sequence[Union['GetApplianceImagesFilterArgs', 'GetApplianceImagesFilterArgsDict']]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplianceImagesResult:
    """
    This data source provides the list of Appliance Images in Oracle Cloud Infrastructure Cloud Bridge service.

    Returns a list of Appliance Images.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_appliance_images = oci.CloudBridge.get_appliance_images(compartment_id=compartment_id,
        display_name=appliance_image_display_name)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudBridge/getApplianceImages:getApplianceImages', __args__, opts=opts, typ=GetApplianceImagesResult).value

    return AwaitableGetApplianceImagesResult(
        appliance_image_collections=pulumi.get(__ret__, 'appliance_image_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_appliance_images_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetApplianceImagesFilterArgs', 'GetApplianceImagesFilterArgsDict']]]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplianceImagesResult]:
    """
    This data source provides the list of Appliance Images in Oracle Cloud Infrastructure Cloud Bridge service.

    Returns a list of Appliance Images.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_appliance_images = oci.CloudBridge.get_appliance_images(compartment_id=compartment_id,
        display_name=appliance_image_display_name)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudBridge/getApplianceImages:getApplianceImages', __args__, opts=opts, typ=GetApplianceImagesResult)
    return __ret__.apply(lambda __response__: GetApplianceImagesResult(
        appliance_image_collections=pulumi.get(__response__, 'appliance_image_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
