# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAdhocQueriesResult',
    'AwaitableGetAdhocQueriesResult',
    'get_adhoc_queries',
    'get_adhoc_queries_output',
]

@pulumi.output_type
class GetAdhocQueriesResult:
    """
    A collection of values returned by getAdhocQueries.
    """
    def __init__(__self__, access_level=None, adhoc_query_collections=None, adhoc_query_status=None, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, time_ended_filter_query_param=None, time_started_filter_query_param=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if adhoc_query_collections and not isinstance(adhoc_query_collections, list):
            raise TypeError("Expected argument 'adhoc_query_collections' to be a list")
        pulumi.set(__self__, "adhoc_query_collections", adhoc_query_collections)
        if adhoc_query_status and not isinstance(adhoc_query_status, str):
            raise TypeError("Expected argument 'adhoc_query_status' to be a str")
        pulumi.set(__self__, "adhoc_query_status", adhoc_query_status)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if time_ended_filter_query_param and not isinstance(time_ended_filter_query_param, str):
            raise TypeError("Expected argument 'time_ended_filter_query_param' to be a str")
        pulumi.set(__self__, "time_ended_filter_query_param", time_ended_filter_query_param)
        if time_started_filter_query_param and not isinstance(time_started_filter_query_param, str):
            raise TypeError("Expected argument 'time_started_filter_query_param' to be a str")
        pulumi.set(__self__, "time_started_filter_query_param", time_started_filter_query_param)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[builtins.str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="adhocQueryCollections")
    def adhoc_query_collections(self) -> Sequence['outputs.GetAdhocQueriesAdhocQueryCollectionResult']:
        """
        The list of adhoc_query_collection.
        """
        return pulumi.get(self, "adhoc_query_collections")

    @property
    @pulumi.getter(name="adhocQueryStatus")
    def adhoc_query_status(self) -> Optional[builtins.str]:
        return pulumi.get(self, "adhoc_query_status")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment OCID of the adhoc query
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAdhocQueriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="timeEndedFilterQueryParam")
    def time_ended_filter_query_param(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_ended_filter_query_param")

    @property
    @pulumi.getter(name="timeStartedFilterQueryParam")
    def time_started_filter_query_param(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_started_filter_query_param")


class AwaitableGetAdhocQueriesResult(GetAdhocQueriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAdhocQueriesResult(
            access_level=self.access_level,
            adhoc_query_collections=self.adhoc_query_collections,
            adhoc_query_status=self.adhoc_query_status,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            time_ended_filter_query_param=self.time_ended_filter_query_param,
            time_started_filter_query_param=self.time_started_filter_query_param)


def get_adhoc_queries(access_level: Optional[builtins.str] = None,
                      adhoc_query_status: Optional[builtins.str] = None,
                      compartment_id: Optional[builtins.str] = None,
                      compartment_id_in_subtree: Optional[builtins.bool] = None,
                      filters: Optional[Sequence[Union['GetAdhocQueriesFilterArgs', 'GetAdhocQueriesFilterArgsDict']]] = None,
                      time_ended_filter_query_param: Optional[builtins.str] = None,
                      time_started_filter_query_param: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAdhocQueriesResult:
    """
    This data source provides the list of Adhoc Queries in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of all adhoc queries (AdhocQuery resources) for a compartment
    identified by compartmentId. List is returned in a AdhocQueryCollection resource
    with page of AdhocQuerySummary resources.

    The ListAdhocQueries operation returns only the adhoc queries in 'compartmentId' passed.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListAdhocQueries on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_adhoc_queries = oci.CloudGuard.get_adhoc_queries(compartment_id=compartment_id,
        access_level=adhoc_query_access_level,
        adhoc_query_status=adhoc_query_adhoc_query_status,
        compartment_id_in_subtree=adhoc_query_compartment_id_in_subtree,
        time_ended_filter_query_param=adhoc_query_time_ended_filter_query_param,
        time_started_filter_query_param=adhoc_query_time_started_filter_query_param)
    ```


    :param builtins.str access_level: Valid values are `RESTRICTED` and `ACCESSIBLE`. Default is `RESTRICTED`. Setting this to `ACCESSIBLE` returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to `RESTRICTED` permissions are checked and no partial results are displayed.
    :param builtins.str adhoc_query_status: The status of the adhoc query created. Default value for state is provisioning. If no value is specified state is provisioning.
    :param builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the setting of `accessLevel`.
    :param builtins.str time_ended_filter_query_param: End time for a filter. If end time is not specified, end time will be set to current time.
    :param builtins.str time_started_filter_query_param: Start time for a filter. If start time is not specified, start time will be set to current time - 30 days.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['adhocQueryStatus'] = adhoc_query_status
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['timeEndedFilterQueryParam'] = time_ended_filter_query_param
    __args__['timeStartedFilterQueryParam'] = time_started_filter_query_param
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getAdhocQueries:getAdhocQueries', __args__, opts=opts, typ=GetAdhocQueriesResult).value

    return AwaitableGetAdhocQueriesResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        adhoc_query_collections=pulumi.get(__ret__, 'adhoc_query_collections'),
        adhoc_query_status=pulumi.get(__ret__, 'adhoc_query_status'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        time_ended_filter_query_param=pulumi.get(__ret__, 'time_ended_filter_query_param'),
        time_started_filter_query_param=pulumi.get(__ret__, 'time_started_filter_query_param'))
def get_adhoc_queries_output(access_level: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             adhoc_query_status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                             compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAdhocQueriesFilterArgs', 'GetAdhocQueriesFilterArgsDict']]]]] = None,
                             time_ended_filter_query_param: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             time_started_filter_query_param: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAdhocQueriesResult]:
    """
    This data source provides the list of Adhoc Queries in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of all adhoc queries (AdhocQuery resources) for a compartment
    identified by compartmentId. List is returned in a AdhocQueryCollection resource
    with page of AdhocQuerySummary resources.

    The ListAdhocQueries operation returns only the adhoc queries in 'compartmentId' passed.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListAdhocQueries on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_adhoc_queries = oci.CloudGuard.get_adhoc_queries(compartment_id=compartment_id,
        access_level=adhoc_query_access_level,
        adhoc_query_status=adhoc_query_adhoc_query_status,
        compartment_id_in_subtree=adhoc_query_compartment_id_in_subtree,
        time_ended_filter_query_param=adhoc_query_time_ended_filter_query_param,
        time_started_filter_query_param=adhoc_query_time_started_filter_query_param)
    ```


    :param builtins.str access_level: Valid values are `RESTRICTED` and `ACCESSIBLE`. Default is `RESTRICTED`. Setting this to `ACCESSIBLE` returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to `RESTRICTED` permissions are checked and no partial results are displayed.
    :param builtins.str adhoc_query_status: The status of the adhoc query created. Default value for state is provisioning. If no value is specified state is provisioning.
    :param builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the setting of `accessLevel`.
    :param builtins.str time_ended_filter_query_param: End time for a filter. If end time is not specified, end time will be set to current time.
    :param builtins.str time_started_filter_query_param: Start time for a filter. If start time is not specified, start time will be set to current time - 30 days.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['adhocQueryStatus'] = adhoc_query_status
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['timeEndedFilterQueryParam'] = time_ended_filter_query_param
    __args__['timeStartedFilterQueryParam'] = time_started_filter_query_param
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudGuard/getAdhocQueries:getAdhocQueries', __args__, opts=opts, typ=GetAdhocQueriesResult)
    return __ret__.apply(lambda __response__: GetAdhocQueriesResult(
        access_level=pulumi.get(__response__, 'access_level'),
        adhoc_query_collections=pulumi.get(__response__, 'adhoc_query_collections'),
        adhoc_query_status=pulumi.get(__response__, 'adhoc_query_status'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        time_ended_filter_query_param=pulumi.get(__response__, 'time_ended_filter_query_param'),
        time_started_filter_query_param=pulumi.get(__response__, 'time_started_filter_query_param')))
