# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityPoliciesResult',
    'AwaitableGetSecurityPoliciesResult',
    'get_security_policies',
    'get_security_policies_output',
]

@pulumi.output_type
class GetSecurityPoliciesResult:
    """
    A collection of values returned by getSecurityPolicies.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, security_policy_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if security_policy_collections and not isinstance(security_policy_collections, list):
            raise TypeError("Expected argument 'security_policy_collections' to be a list")
        pulumi.set(__self__, "security_policy_collections", security_policy_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the security policy's compartment
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The security policy's display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityPoliciesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Unique identifier that can’t be changed after creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="securityPolicyCollections")
    def security_policy_collections(self) -> Sequence['outputs.GetSecurityPoliciesSecurityPolicyCollectionResult']:
        """
        The list of security_policy_collection.
        """
        return pulumi.get(self, "security_policy_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current lifecycle state of the security policy
        """
        return pulumi.get(self, "state")


class AwaitableGetSecurityPoliciesResult(GetSecurityPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityPoliciesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            security_policy_collections=self.security_policy_collections,
            state=self.state)


def get_security_policies(compartment_id: Optional[builtins.str] = None,
                          display_name: Optional[builtins.str] = None,
                          filters: Optional[Sequence[Union['GetSecurityPoliciesFilterArgs', 'GetSecurityPoliciesFilterArgsDict']]] = None,
                          id: Optional[builtins.str] = None,
                          state: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityPoliciesResult:
    """
    This data source provides the list of Security Policies in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of security zone policies (SecurityPolicySummary resources),
    identified by compartmentId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policies = oci.CloudGuard.get_security_policies(compartment_id=compartment_id,
        display_name=security_policy_display_name,
        id=security_policy_id,
        state=security_policy_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: The unique identifier of the security zone policy. (`SecurityPolicy`)
    :param builtins.str state: The field lifecycle state. Only one state can be provided. Default value for state is active. If no value is specified state is active.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getSecurityPolicies:getSecurityPolicies', __args__, opts=opts, typ=GetSecurityPoliciesResult).value

    return AwaitableGetSecurityPoliciesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        security_policy_collections=pulumi.get(__ret__, 'security_policy_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_security_policies_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                 display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSecurityPoliciesFilterArgs', 'GetSecurityPoliciesFilterArgsDict']]]]] = None,
                                 id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityPoliciesResult]:
    """
    This data source provides the list of Security Policies in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of security zone policies (SecurityPolicySummary resources),
    identified by compartmentId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policies = oci.CloudGuard.get_security_policies(compartment_id=compartment_id,
        display_name=security_policy_display_name,
        id=security_policy_id,
        state=security_policy_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: The unique identifier of the security zone policy. (`SecurityPolicy`)
    :param builtins.str state: The field lifecycle state. Only one state can be provided. Default value for state is active. If no value is specified state is active.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudGuard/getSecurityPolicies:getSecurityPolicies', __args__, opts=opts, typ=GetSecurityPoliciesResult)
    return __ret__.apply(lambda __response__: GetSecurityPoliciesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        security_policy_collections=pulumi.get(__response__, 'security_policy_collections'),
        state=pulumi.get(__response__, 'state')))
