# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DrgAttachmentsListArgs', 'DrgAttachmentsList']

@pulumi.input_type
class DrgAttachmentsListArgs:
    def __init__(__self__, *,
                 drg_id: pulumi.Input[builtins.str],
                 attachment_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_cross_tenancy: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a DrgAttachmentsList resource.
        :param pulumi.Input[builtins.str] drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        :param pulumi.Input[builtins.str] attachment_type: The type for the network resource attached to the DRG.
        :param pulumi.Input[builtins.bool] is_cross_tenancy: Whether the DRG attachment lives in a different tenancy than the DRG.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "drg_id", drg_id)
        if attachment_type is not None:
            pulumi.set(__self__, "attachment_type", attachment_type)
        if is_cross_tenancy is not None:
            pulumi.set(__self__, "is_cross_tenancy", is_cross_tenancy)

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        """
        return pulumi.get(self, "drg_id")

    @drg_id.setter
    def drg_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "drg_id", value)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type for the network resource attached to the DRG.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attachment_type", value)

    @property
    @pulumi.getter(name="isCrossTenancy")
    def is_cross_tenancy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the DRG attachment lives in a different tenancy than the DRG.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_cross_tenancy")

    @is_cross_tenancy.setter
    def is_cross_tenancy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_cross_tenancy", value)


@pulumi.input_type
class _DrgAttachmentsListState:
    def __init__(__self__, *,
                 attachment_type: Optional[pulumi.Input[builtins.str]] = None,
                 drg_all_attachments: Optional[pulumi.Input[Sequence[pulumi.Input['DrgAttachmentsListDrgAllAttachmentArgs']]]] = None,
                 drg_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_cross_tenancy: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering DrgAttachmentsList resources.
        :param pulumi.Input[builtins.str] attachment_type: The type for the network resource attached to the DRG.
        :param pulumi.Input[Sequence[pulumi.Input['DrgAttachmentsListDrgAllAttachmentArgs']]] drg_all_attachments: The list of drg_attachments.
        :param pulumi.Input[builtins.str] drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        :param pulumi.Input[builtins.bool] is_cross_tenancy: Whether the DRG attachment lives in a different tenancy than the DRG.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if attachment_type is not None:
            pulumi.set(__self__, "attachment_type", attachment_type)
        if drg_all_attachments is not None:
            pulumi.set(__self__, "drg_all_attachments", drg_all_attachments)
        if drg_id is not None:
            pulumi.set(__self__, "drg_id", drg_id)
        if is_cross_tenancy is not None:
            pulumi.set(__self__, "is_cross_tenancy", is_cross_tenancy)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type for the network resource attached to the DRG.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attachment_type", value)

    @property
    @pulumi.getter(name="drgAllAttachments")
    def drg_all_attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrgAttachmentsListDrgAllAttachmentArgs']]]]:
        """
        The list of drg_attachments.
        """
        return pulumi.get(self, "drg_all_attachments")

    @drg_all_attachments.setter
    def drg_all_attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrgAttachmentsListDrgAllAttachmentArgs']]]]):
        pulumi.set(self, "drg_all_attachments", value)

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        """
        return pulumi.get(self, "drg_id")

    @drg_id.setter
    def drg_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "drg_id", value)

    @property
    @pulumi.getter(name="isCrossTenancy")
    def is_cross_tenancy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the DRG attachment lives in a different tenancy than the DRG.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_cross_tenancy")

    @is_cross_tenancy.setter
    def is_cross_tenancy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_cross_tenancy", value)


@pulumi.type_token("oci:Core/drgAttachmentsList:DrgAttachmentsList")
class DrgAttachmentsList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_type: Optional[pulumi.Input[builtins.str]] = None,
                 drg_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_cross_tenancy: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        This resource provides the Drg Attachments List resource in Oracle Cloud Infrastructure Core service.

        Returns a complete list of DRG attachments that belong to a particular DRG.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_drg_attachments_list = oci.core.DrgAttachmentsList("test_drg_attachments_list",
            drg_id=test_drg["id"],
            attachment_type=drg_attachments_list_attachment_type,
            is_cross_tenancy=drg_attachments_list_is_cross_tenancy)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] attachment_type: The type for the network resource attached to the DRG.
        :param pulumi.Input[builtins.str] drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        :param pulumi.Input[builtins.bool] is_cross_tenancy: Whether the DRG attachment lives in a different tenancy than the DRG.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DrgAttachmentsListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Drg Attachments List resource in Oracle Cloud Infrastructure Core service.

        Returns a complete list of DRG attachments that belong to a particular DRG.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_drg_attachments_list = oci.core.DrgAttachmentsList("test_drg_attachments_list",
            drg_id=test_drg["id"],
            attachment_type=drg_attachments_list_attachment_type,
            is_cross_tenancy=drg_attachments_list_is_cross_tenancy)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param DrgAttachmentsListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DrgAttachmentsListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_type: Optional[pulumi.Input[builtins.str]] = None,
                 drg_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_cross_tenancy: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DrgAttachmentsListArgs.__new__(DrgAttachmentsListArgs)

            __props__.__dict__["attachment_type"] = attachment_type
            if drg_id is None and not opts.urn:
                raise TypeError("Missing required property 'drg_id'")
            __props__.__dict__["drg_id"] = drg_id
            __props__.__dict__["is_cross_tenancy"] = is_cross_tenancy
            __props__.__dict__["drg_all_attachments"] = None
        super(DrgAttachmentsList, __self__).__init__(
            'oci:Core/drgAttachmentsList:DrgAttachmentsList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachment_type: Optional[pulumi.Input[builtins.str]] = None,
            drg_all_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DrgAttachmentsListDrgAllAttachmentArgs', 'DrgAttachmentsListDrgAllAttachmentArgsDict']]]]] = None,
            drg_id: Optional[pulumi.Input[builtins.str]] = None,
            is_cross_tenancy: Optional[pulumi.Input[builtins.bool]] = None) -> 'DrgAttachmentsList':
        """
        Get an existing DrgAttachmentsList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] attachment_type: The type for the network resource attached to the DRG.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DrgAttachmentsListDrgAllAttachmentArgs', 'DrgAttachmentsListDrgAllAttachmentArgsDict']]]] drg_all_attachments: The list of drg_attachments.
        :param pulumi.Input[builtins.str] drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        :param pulumi.Input[builtins.bool] is_cross_tenancy: Whether the DRG attachment lives in a different tenancy than the DRG.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DrgAttachmentsListState.__new__(_DrgAttachmentsListState)

        __props__.__dict__["attachment_type"] = attachment_type
        __props__.__dict__["drg_all_attachments"] = drg_all_attachments
        __props__.__dict__["drg_id"] = drg_id
        __props__.__dict__["is_cross_tenancy"] = is_cross_tenancy
        return DrgAttachmentsList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type for the network resource attached to the DRG.
        """
        return pulumi.get(self, "attachment_type")

    @property
    @pulumi.getter(name="drgAllAttachments")
    def drg_all_attachments(self) -> pulumi.Output[Sequence['outputs.DrgAttachmentsListDrgAllAttachment']]:
        """
        The list of drg_attachments.
        """
        return pulumi.get(self, "drg_all_attachments")

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        """
        return pulumi.get(self, "drg_id")

    @property
    @pulumi.getter(name="isCrossTenancy")
    def is_cross_tenancy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the DRG attachment lives in a different tenancy than the DRG.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_cross_tenancy")

