# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetComputeCapacityTopologyComputeBareMetalHostsResult',
    'AwaitableGetComputeCapacityTopologyComputeBareMetalHostsResult',
    'get_compute_capacity_topology_compute_bare_metal_hosts',
    'get_compute_capacity_topology_compute_bare_metal_hosts_output',
]

@pulumi.output_type
class GetComputeCapacityTopologyComputeBareMetalHostsResult:
    """
    A collection of values returned by getComputeCapacityTopologyComputeBareMetalHosts.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, compute_bare_metal_host_collections=None, compute_capacity_topology_id=None, compute_hpc_island_id=None, compute_local_block_id=None, compute_network_block_id=None, filters=None, id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_bare_metal_host_collections and not isinstance(compute_bare_metal_host_collections, list):
            raise TypeError("Expected argument 'compute_bare_metal_host_collections' to be a list")
        pulumi.set(__self__, "compute_bare_metal_host_collections", compute_bare_metal_host_collections)
        if compute_capacity_topology_id and not isinstance(compute_capacity_topology_id, str):
            raise TypeError("Expected argument 'compute_capacity_topology_id' to be a str")
        pulumi.set(__self__, "compute_capacity_topology_id", compute_capacity_topology_id)
        if compute_hpc_island_id and not isinstance(compute_hpc_island_id, str):
            raise TypeError("Expected argument 'compute_hpc_island_id' to be a str")
        pulumi.set(__self__, "compute_hpc_island_id", compute_hpc_island_id)
        if compute_local_block_id and not isinstance(compute_local_block_id, str):
            raise TypeError("Expected argument 'compute_local_block_id' to be a str")
        pulumi.set(__self__, "compute_local_block_id", compute_local_block_id)
        if compute_network_block_id and not isinstance(compute_network_block_id, str):
            raise TypeError("Expected argument 'compute_network_block_id' to be a str")
        pulumi.set(__self__, "compute_network_block_id", compute_network_block_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[builtins.str]:
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeBareMetalHostCollections")
    def compute_bare_metal_host_collections(self) -> Sequence['outputs.GetComputeCapacityTopologyComputeBareMetalHostsComputeBareMetalHostCollectionResult']:
        """
        The list of compute_bare_metal_host_collection.
        """
        return pulumi.get(self, "compute_bare_metal_host_collections")

    @property
    @pulumi.getter(name="computeCapacityTopologyId")
    def compute_capacity_topology_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute capacity topology.
        """
        return pulumi.get(self, "compute_capacity_topology_id")

    @property
    @pulumi.getter(name="computeHpcIslandId")
    def compute_hpc_island_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute HPC island.
        """
        return pulumi.get(self, "compute_hpc_island_id")

    @property
    @pulumi.getter(name="computeLocalBlockId")
    def compute_local_block_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute network block.
        """
        return pulumi.get(self, "compute_local_block_id")

    @property
    @pulumi.getter(name="computeNetworkBlockId")
    def compute_network_block_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute local block.
        """
        return pulumi.get(self, "compute_network_block_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetComputeCapacityTopologyComputeBareMetalHostsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetComputeCapacityTopologyComputeBareMetalHostsResult(GetComputeCapacityTopologyComputeBareMetalHostsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeCapacityTopologyComputeBareMetalHostsResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            compute_bare_metal_host_collections=self.compute_bare_metal_host_collections,
            compute_capacity_topology_id=self.compute_capacity_topology_id,
            compute_hpc_island_id=self.compute_hpc_island_id,
            compute_local_block_id=self.compute_local_block_id,
            compute_network_block_id=self.compute_network_block_id,
            filters=self.filters,
            id=self.id)


def get_compute_capacity_topology_compute_bare_metal_hosts(availability_domain: Optional[builtins.str] = None,
                                                           compartment_id: Optional[builtins.str] = None,
                                                           compute_capacity_topology_id: Optional[builtins.str] = None,
                                                           compute_hpc_island_id: Optional[builtins.str] = None,
                                                           compute_local_block_id: Optional[builtins.str] = None,
                                                           compute_network_block_id: Optional[builtins.str] = None,
                                                           filters: Optional[Sequence[Union['GetComputeCapacityTopologyComputeBareMetalHostsFilterArgs', 'GetComputeCapacityTopologyComputeBareMetalHostsFilterArgsDict']]] = None,
                                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeCapacityTopologyComputeBareMetalHostsResult:
    """
    This data source provides the list of Compute Capacity Topology Compute Bare Metal Hosts in Oracle Cloud Infrastructure Core service.

    Lists compute bare metal hosts in the specified compute capacity topology.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_capacity_topology_compute_bare_metal_hosts = oci.Core.get_compute_capacity_topology_compute_bare_metal_hosts(compute_capacity_topology_id=test_compute_capacity_topology["id"],
        availability_domain=compute_capacity_topology_compute_bare_metal_host_availability_domain,
        compartment_id=compartment_id,
        compute_hpc_island_id=test_compute_hpc_island["id"],
        compute_local_block_id=test_compute_local_block["id"],
        compute_network_block_id=test_compute_network_block["id"])
    ```


    :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str compute_capacity_topology_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute capacity topology.
    :param builtins.str compute_hpc_island_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute HPC island.
    :param builtins.str compute_local_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute local block.
    :param builtins.str compute_network_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute network block.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['computeCapacityTopologyId'] = compute_capacity_topology_id
    __args__['computeHpcIslandId'] = compute_hpc_island_id
    __args__['computeLocalBlockId'] = compute_local_block_id
    __args__['computeNetworkBlockId'] = compute_network_block_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getComputeCapacityTopologyComputeBareMetalHosts:getComputeCapacityTopologyComputeBareMetalHosts', __args__, opts=opts, typ=GetComputeCapacityTopologyComputeBareMetalHostsResult).value

    return AwaitableGetComputeCapacityTopologyComputeBareMetalHostsResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_bare_metal_host_collections=pulumi.get(__ret__, 'compute_bare_metal_host_collections'),
        compute_capacity_topology_id=pulumi.get(__ret__, 'compute_capacity_topology_id'),
        compute_hpc_island_id=pulumi.get(__ret__, 'compute_hpc_island_id'),
        compute_local_block_id=pulumi.get(__ret__, 'compute_local_block_id'),
        compute_network_block_id=pulumi.get(__ret__, 'compute_network_block_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_compute_capacity_topology_compute_bare_metal_hosts_output(availability_domain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                                  compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                                  compute_capacity_topology_id: Optional[pulumi.Input[builtins.str]] = None,
                                                                  compute_hpc_island_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                                  compute_local_block_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                                  compute_network_block_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetComputeCapacityTopologyComputeBareMetalHostsFilterArgs', 'GetComputeCapacityTopologyComputeBareMetalHostsFilterArgsDict']]]]] = None,
                                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeCapacityTopologyComputeBareMetalHostsResult]:
    """
    This data source provides the list of Compute Capacity Topology Compute Bare Metal Hosts in Oracle Cloud Infrastructure Core service.

    Lists compute bare metal hosts in the specified compute capacity topology.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_capacity_topology_compute_bare_metal_hosts = oci.Core.get_compute_capacity_topology_compute_bare_metal_hosts(compute_capacity_topology_id=test_compute_capacity_topology["id"],
        availability_domain=compute_capacity_topology_compute_bare_metal_host_availability_domain,
        compartment_id=compartment_id,
        compute_hpc_island_id=test_compute_hpc_island["id"],
        compute_local_block_id=test_compute_local_block["id"],
        compute_network_block_id=test_compute_network_block["id"])
    ```


    :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str compute_capacity_topology_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute capacity topology.
    :param builtins.str compute_hpc_island_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute HPC island.
    :param builtins.str compute_local_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute local block.
    :param builtins.str compute_network_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute network block.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['computeCapacityTopologyId'] = compute_capacity_topology_id
    __args__['computeHpcIslandId'] = compute_hpc_island_id
    __args__['computeLocalBlockId'] = compute_local_block_id
    __args__['computeNetworkBlockId'] = compute_network_block_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getComputeCapacityTopologyComputeBareMetalHosts:getComputeCapacityTopologyComputeBareMetalHosts', __args__, opts=opts, typ=GetComputeCapacityTopologyComputeBareMetalHostsResult)
    return __ret__.apply(lambda __response__: GetComputeCapacityTopologyComputeBareMetalHostsResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compute_bare_metal_host_collections=pulumi.get(__response__, 'compute_bare_metal_host_collections'),
        compute_capacity_topology_id=pulumi.get(__response__, 'compute_capacity_topology_id'),
        compute_hpc_island_id=pulumi.get(__response__, 'compute_hpc_island_id'),
        compute_local_block_id=pulumi.get(__response__, 'compute_local_block_id'),
        compute_network_block_id=pulumi.get(__response__, 'compute_network_block_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
