# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupArgs', 'Backup']

@pulumi.input_type
class BackupArgs:
    def __init__(__self__, *,
                 database_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 retention_period_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 retention_period_in_years: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a Backup resource.
        :param pulumi.Input[builtins.str] database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the backup. The name does not have to be unique.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "display_name", display_name)
        if retention_period_in_days is not None:
            pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if retention_period_in_years is not None:
            pulumi.set(__self__, "retention_period_in_years", retention_period_in_years)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The user-friendly name for the backup. The name does not have to be unique.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "retention_period_in_days")

    @retention_period_in_days.setter
    def retention_period_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_period_in_days", value)

    @property
    @pulumi.getter(name="retentionPeriodInYears")
    def retention_period_in_years(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "retention_period_in_years")

    @retention_period_in_years.setter
    def retention_period_in_years(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_period_in_years", value)


@pulumi.input_type
class _BackupState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 backup_destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_edition: Optional[pulumi.Input[builtins.str]] = None,
                 database_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_size_in_gbs: Optional[pulumi.Input[builtins.float]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_key_location_details: Optional[pulumi.Input[Sequence[pulumi.Input['BackupEncryptionKeyLocationDetailArgs']]]] = None,
                 is_using_oracle_managed_keys: Optional[pulumi.Input[builtins.bool]] = None,
                 key_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_store_wallet_name: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_version_id: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 retention_period_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 retention_period_in_years: Optional[pulumi.Input[builtins.int]] = None,
                 secondary_kms_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 shape: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_ended: Optional[pulumi.Input[builtins.str]] = None,
                 time_expiry_scheduled: Optional[pulumi.Input[builtins.str]] = None,
                 time_started: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Backup resources.
        :param pulumi.Input[builtins.str] availability_domain: The name of the availability domain where the database backup is stored.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] database_edition: The Oracle Database Edition that applies to all the databases on the DB system. Exadata DB systems and 2-node RAC DB systems require ENTERPRISE_EDITION_EXTREME_PERFORMANCE.
        :param pulumi.Input[builtins.str] database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        :param pulumi.Input[builtins.float] database_size_in_gbs: The size of the database in gigabytes at the time the backup was taken.
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the backup. The name does not have to be unique.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['BackupEncryptionKeyLocationDetailArgs']]] encryption_key_location_details: Types of providers supported for managing database encryption keys
        :param pulumi.Input[builtins.str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        :param pulumi.Input[builtins.str] key_store_wallet_name: The wallet name for Oracle Key Vault.
        :param pulumi.Input[builtins.str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[builtins.str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[builtins.str] shape: Shape of the backup's source database.
        :param pulumi.Input[builtins.str] state: The current state of the backup.
        :param pulumi.Input[builtins.str] time_ended: The date and time the backup was completed.
        :param pulumi.Input[builtins.str] time_started: The date and time the backup started.
        :param pulumi.Input[builtins.str] type: The type of backup.
        :param pulumi.Input[builtins.str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        :param pulumi.Input[builtins.str] version: Version of the backup's source database
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_destination_type is not None:
            pulumi.set(__self__, "backup_destination_type", backup_destination_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if database_edition is not None:
            pulumi.set(__self__, "database_edition", database_edition)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_size_in_gbs is not None:
            pulumi.set(__self__, "database_size_in_gbs", database_size_in_gbs)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encryption_key_location_details is not None:
            pulumi.set(__self__, "encryption_key_location_details", encryption_key_location_details)
        if is_using_oracle_managed_keys is not None:
            pulumi.set(__self__, "is_using_oracle_managed_keys", is_using_oracle_managed_keys)
        if key_store_id is not None:
            pulumi.set(__self__, "key_store_id", key_store_id)
        if key_store_wallet_name is not None:
            pulumi.set(__self__, "key_store_wallet_name", key_store_wallet_name)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if retention_period_in_days is not None:
            pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if retention_period_in_years is not None:
            pulumi.set(__self__, "retention_period_in_years", retention_period_in_years)
        if secondary_kms_key_ids is not None:
            pulumi.set(__self__, "secondary_kms_key_ids", secondary_kms_key_ids)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_ended is not None:
            pulumi.set(__self__, "time_ended", time_ended)
        if time_expiry_scheduled is not None:
            pulumi.set(__self__, "time_expiry_scheduled", time_expiry_scheduled)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the availability domain where the database backup is stored.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="backupDestinationType")
    def backup_destination_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "backup_destination_type")

    @backup_destination_type.setter
    def backup_destination_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_destination_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Oracle Database Edition that applies to all the databases on the DB system. Exadata DB systems and 2-node RAC DB systems require ENTERPRISE_EDITION_EXTREME_PERFORMANCE.
        """
        return pulumi.get(self, "database_edition")

    @database_edition.setter
    def database_edition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_edition", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="databaseSizeInGbs")
    def database_size_in_gbs(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The size of the database in gigabytes at the time the backup was taken.
        """
        return pulumi.get(self, "database_size_in_gbs")

    @database_size_in_gbs.setter
    def database_size_in_gbs(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "database_size_in_gbs", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-friendly name for the backup. The name does not have to be unique.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="encryptionKeyLocationDetails")
    def encryption_key_location_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupEncryptionKeyLocationDetailArgs']]]]:
        """
        Types of providers supported for managing database encryption keys
        """
        return pulumi.get(self, "encryption_key_location_details")

    @encryption_key_location_details.setter
    def encryption_key_location_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupEncryptionKeyLocationDetailArgs']]]]):
        pulumi.set(self, "encryption_key_location_details", value)

    @property
    @pulumi.getter(name="isUsingOracleManagedKeys")
    def is_using_oracle_managed_keys(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "is_using_oracle_managed_keys")

    @is_using_oracle_managed_keys.setter
    def is_using_oracle_managed_keys(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_using_oracle_managed_keys", value)

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        """
        return pulumi.get(self, "key_store_id")

    @key_store_id.setter
    def key_store_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_store_id", value)

    @property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @key_store_wallet_name.setter
    def key_store_wallet_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_store_wallet_name", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @kms_key_version_id.setter
    def kms_key_version_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_version_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "retention_period_in_days")

    @retention_period_in_days.setter
    def retention_period_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_period_in_days", value)

    @property
    @pulumi.getter(name="retentionPeriodInYears")
    def retention_period_in_years(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "retention_period_in_years")

    @retention_period_in_years.setter
    def retention_period_in_years(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_period_in_years", value)

    @property
    @pulumi.getter(name="secondaryKmsKeyIds")
    def secondary_kms_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "secondary_kms_key_ids")

    @secondary_kms_key_ids.setter
    def secondary_kms_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "secondary_kms_key_ids", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Shape of the backup's source database.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the backup was completed.
        """
        return pulumi.get(self, "time_ended")

    @time_ended.setter
    def time_ended(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_ended", value)

    @property
    @pulumi.getter(name="timeExpiryScheduled")
    def time_expiry_scheduled(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "time_expiry_scheduled")

    @time_expiry_scheduled.setter
    def time_expiry_scheduled(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_expiry_scheduled", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the backup started.
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_started", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of backup.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Version of the backup's source database
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("oci:Database/backup:Backup")
class Backup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_period_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 retention_period_in_years: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        This resource provides the Backup resource in Oracle Cloud Infrastructure Database service.

        Creates a new backup in the specified database based on the request parameters you provide. If you previously used RMAN or dbcli to configure backups and then you switch to using the Console or the API for backups, a new backup configuration is created and associated with your database. This means that you can no longer rely on your previously configured unmanaged backups to work.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_backup = oci.database.Backup("test_backup",
            database_id=test_database["id"],
            display_name=backup_display_name)
        ```

        ## Import

        Backups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/backup:Backup test_backup "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the backup. The name does not have to be unique.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Backup resource in Oracle Cloud Infrastructure Database service.

        Creates a new backup in the specified database based on the request parameters you provide. If you previously used RMAN or dbcli to configure backups and then you switch to using the Console or the API for backups, a new backup configuration is created and associated with your database. This means that you can no longer rely on your previously configured unmanaged backups to work.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_backup = oci.database.Backup("test_backup",
            database_id=test_database["id"],
            display_name=backup_display_name)
        ```

        ## Import

        Backups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/backup:Backup test_backup "id"
        ```

        :param str resource_name: The name of the resource.
        :param BackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_period_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 retention_period_in_years: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupArgs.__new__(BackupArgs)

            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["retention_period_in_days"] = retention_period_in_days
            __props__.__dict__["retention_period_in_years"] = retention_period_in_years
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["backup_destination_type"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["database_edition"] = None
            __props__.__dict__["database_size_in_gbs"] = None
            __props__.__dict__["encryption_key_location_details"] = None
            __props__.__dict__["is_using_oracle_managed_keys"] = None
            __props__.__dict__["key_store_id"] = None
            __props__.__dict__["key_store_wallet_name"] = None
            __props__.__dict__["kms_key_id"] = None
            __props__.__dict__["kms_key_version_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["secondary_kms_key_ids"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_ended"] = None
            __props__.__dict__["time_expiry_scheduled"] = None
            __props__.__dict__["time_started"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["vault_id"] = None
            __props__.__dict__["version"] = None
        super(Backup, __self__).__init__(
            'oci:Database/backup:Backup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[builtins.str]] = None,
            backup_destination_type: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            database_edition: Optional[pulumi.Input[builtins.str]] = None,
            database_id: Optional[pulumi.Input[builtins.str]] = None,
            database_size_in_gbs: Optional[pulumi.Input[builtins.float]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            encryption_key_location_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupEncryptionKeyLocationDetailArgs', 'BackupEncryptionKeyLocationDetailArgsDict']]]]] = None,
            is_using_oracle_managed_keys: Optional[pulumi.Input[builtins.bool]] = None,
            key_store_id: Optional[pulumi.Input[builtins.str]] = None,
            key_store_wallet_name: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_version_id: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            retention_period_in_days: Optional[pulumi.Input[builtins.int]] = None,
            retention_period_in_years: Optional[pulumi.Input[builtins.int]] = None,
            secondary_kms_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            shape: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_ended: Optional[pulumi.Input[builtins.str]] = None,
            time_expiry_scheduled: Optional[pulumi.Input[builtins.str]] = None,
            time_started: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            vault_id: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'Backup':
        """
        Get an existing Backup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] availability_domain: The name of the availability domain where the database backup is stored.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] database_edition: The Oracle Database Edition that applies to all the databases on the DB system. Exadata DB systems and 2-node RAC DB systems require ENTERPRISE_EDITION_EXTREME_PERFORMANCE.
        :param pulumi.Input[builtins.str] database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        :param pulumi.Input[builtins.float] database_size_in_gbs: The size of the database in gigabytes at the time the backup was taken.
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the backup. The name does not have to be unique.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupEncryptionKeyLocationDetailArgs', 'BackupEncryptionKeyLocationDetailArgsDict']]]] encryption_key_location_details: Types of providers supported for managing database encryption keys
        :param pulumi.Input[builtins.str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        :param pulumi.Input[builtins.str] key_store_wallet_name: The wallet name for Oracle Key Vault.
        :param pulumi.Input[builtins.str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[builtins.str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[builtins.str] shape: Shape of the backup's source database.
        :param pulumi.Input[builtins.str] state: The current state of the backup.
        :param pulumi.Input[builtins.str] time_ended: The date and time the backup was completed.
        :param pulumi.Input[builtins.str] time_started: The date and time the backup started.
        :param pulumi.Input[builtins.str] type: The type of backup.
        :param pulumi.Input[builtins.str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        :param pulumi.Input[builtins.str] version: Version of the backup's source database
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupState.__new__(_BackupState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["backup_destination_type"] = backup_destination_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["database_edition"] = database_edition
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["database_size_in_gbs"] = database_size_in_gbs
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["encryption_key_location_details"] = encryption_key_location_details
        __props__.__dict__["is_using_oracle_managed_keys"] = is_using_oracle_managed_keys
        __props__.__dict__["key_store_id"] = key_store_id
        __props__.__dict__["key_store_wallet_name"] = key_store_wallet_name
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["kms_key_version_id"] = kms_key_version_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["retention_period_in_days"] = retention_period_in_days
        __props__.__dict__["retention_period_in_years"] = retention_period_in_years
        __props__.__dict__["secondary_kms_key_ids"] = secondary_kms_key_ids
        __props__.__dict__["shape"] = shape
        __props__.__dict__["state"] = state
        __props__.__dict__["time_ended"] = time_ended
        __props__.__dict__["time_expiry_scheduled"] = time_expiry_scheduled
        __props__.__dict__["time_started"] = time_started
        __props__.__dict__["type"] = type
        __props__.__dict__["vault_id"] = vault_id
        __props__.__dict__["version"] = version
        return Backup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[builtins.str]:
        """
        The name of the availability domain where the database backup is stored.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="backupDestinationType")
    def backup_destination_type(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "backup_destination_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> pulumi.Output[builtins.str]:
        """
        The Oracle Database Edition that applies to all the databases on the DB system. Exadata DB systems and 2-node RAC DB systems require ENTERPRISE_EDITION_EXTREME_PERFORMANCE.
        """
        return pulumi.get(self, "database_edition")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseSizeInGbs")
    def database_size_in_gbs(self) -> pulumi.Output[builtins.float]:
        """
        The size of the database in gigabytes at the time the backup was taken.
        """
        return pulumi.get(self, "database_size_in_gbs")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The user-friendly name for the backup. The name does not have to be unique.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="encryptionKeyLocationDetails")
    def encryption_key_location_details(self) -> pulumi.Output[Sequence['outputs.BackupEncryptionKeyLocationDetail']]:
        """
        Types of providers supported for managing database encryption keys
        """
        return pulumi.get(self, "encryption_key_location_details")

    @property
    @pulumi.getter(name="isUsingOracleManagedKeys")
    def is_using_oracle_managed_keys(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "is_using_oracle_managed_keys")

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        """
        return pulumi.get(self, "key_store_id")

    @property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> pulumi.Output[builtins.str]:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "retention_period_in_days")

    @property
    @pulumi.getter(name="retentionPeriodInYears")
    def retention_period_in_years(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "retention_period_in_years")

    @property
    @pulumi.getter(name="secondaryKmsKeyIds")
    def secondary_kms_key_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        return pulumi.get(self, "secondary_kms_key_ids")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[builtins.str]:
        """
        Shape of the backup's source database.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the backup was completed.
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeExpiryScheduled")
    def time_expiry_scheduled(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "time_expiry_scheduled")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the backup started.
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of backup.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        Version of the backup's source database
        """
        return pulumi.get(self, "version")

