# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DbNodeArgs', 'DbNode']

@pulumi.input_type
class DbNodeArgs:
    def __init__(__self__, *,
                 db_node_id: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a DbNode resource.
        :param pulumi.Input[builtins.str] db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "db_node_id", db_node_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> pulumi.Input[builtins.str]:
        """
        The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_node_id")

    @db_node_id.setter
    def db_node_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_node_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _DbNodeState:
    def __init__(__self__, *,
                 additional_details: Optional[pulumi.Input[builtins.str]] = None,
                 backup_ip_id: Optional[pulumi.Input[builtins.str]] = None,
                 backup_ipv6id: Optional[pulumi.Input[builtins.str]] = None,
                 backup_vnic2id: Optional[pulumi.Input[builtins.str]] = None,
                 backup_vnic_id: Optional[pulumi.Input[builtins.str]] = None,
                 cpu_core_count: Optional[pulumi.Input[builtins.int]] = None,
                 db_node_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
                 db_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 fault_domain: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 host_ip_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_ipv6id: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_type: Optional[pulumi.Input[builtins.str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
                 software_storage_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_maintenance_window_end: Optional[pulumi.Input[builtins.str]] = None,
                 time_maintenance_window_start: Optional[pulumi.Input[builtins.str]] = None,
                 total_cpu_core_count: Optional[pulumi.Input[builtins.int]] = None,
                 vnic2id: Optional[pulumi.Input[builtins.str]] = None,
                 vnic_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbNode resources.
        :param pulumi.Input[builtins.str] additional_details: Additional information about the planned maintenance.
        :param pulumi.Input[builtins.str] backup_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup IPv4 address associated with the database node. Use this OCID with either the [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/GetPrivateIp) or the [GetPublicIpByPrivateIpId](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByPrivateIpId) API to get the IPv4 address needed to make a database connection.
        :param pulumi.Input[builtins.str] backup_ipv6id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup IPv6 address associated with the database node. Use this OCID with the [GetIpv6](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/Ipv6/GetIpv6) API to get the IPv6 address needed to make a database connection.
        :param pulumi.Input[builtins.str] backup_vnic2id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second backup VNIC.
        :param pulumi.Input[builtins.str] backup_vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup VNIC.
        :param pulumi.Input[builtins.int] cpu_core_count: The number of CPU cores enabled on the Db node.
        :param pulumi.Input[builtins.str] db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.int] db_node_storage_size_in_gbs: The allocated local node storage in GBs on the Db node.
        :param pulumi.Input[builtins.str] db_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exacc Db server associated with the database node.
        :param pulumi.Input[builtins.str] db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] fault_domain: The name of the Fault Domain the instance is contained in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] host_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the host IPv4 address associated with the database node. Use this OCID with either the [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/GetPrivateIp) or the [GetPublicIpByPrivateIpId](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByPrivateIpId) API to get the IPv4 address needed to make a database connection.
        :param pulumi.Input[builtins.str] host_ipv6id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the host IPv6 address associated with the database node. Use this OCID with the [GetIpv6](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/Ipv6/GetIpv6) API to get the IPv6 address needed to make a database connection.
        :param pulumi.Input[builtins.str] hostname: The host name for the database node.
        :param pulumi.Input[builtins.str] lifecycle_details: Information about the current lifecycle state.
        :param pulumi.Input[builtins.str] maintenance_type: The type of database node maintenance.
        :param pulumi.Input[builtins.int] memory_size_in_gbs: The allocated memory in GBs on the Db node.
        :param pulumi.Input[builtins.int] software_storage_size_in_gb: The size (in GB) of the block storage volume allocation for the DB system. This attribute applies only for virtual machine DB systems.
        :param pulumi.Input[builtins.str] state: The current state of the database node.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] time_created: The date and time that the database node was created.
        :param pulumi.Input[builtins.str] time_maintenance_window_end: End date and time of maintenance window.
        :param pulumi.Input[builtins.str] time_maintenance_window_start: Start date and time of maintenance window.
        :param pulumi.Input[builtins.int] total_cpu_core_count: The total number of CPU cores reserved on the Db node.
        :param pulumi.Input[builtins.str] vnic2id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second VNIC.
        :param pulumi.Input[builtins.str] vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC.
        """
        if additional_details is not None:
            pulumi.set(__self__, "additional_details", additional_details)
        if backup_ip_id is not None:
            pulumi.set(__self__, "backup_ip_id", backup_ip_id)
        if backup_ipv6id is not None:
            pulumi.set(__self__, "backup_ipv6id", backup_ipv6id)
        if backup_vnic2id is not None:
            pulumi.set(__self__, "backup_vnic2id", backup_vnic2id)
        if backup_vnic_id is not None:
            pulumi.set(__self__, "backup_vnic_id", backup_vnic_id)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if db_node_id is not None:
            pulumi.set(__self__, "db_node_id", db_node_id)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_server_id is not None:
            pulumi.set(__self__, "db_server_id", db_server_id)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_ip_id is not None:
            pulumi.set(__self__, "host_ip_id", host_ip_id)
        if host_ipv6id is not None:
            pulumi.set(__self__, "host_ipv6id", host_ipv6id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_type is not None:
            pulumi.set(__self__, "maintenance_type", maintenance_type)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if software_storage_size_in_gb is not None:
            pulumi.set(__self__, "software_storage_size_in_gb", software_storage_size_in_gb)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_maintenance_window_end is not None:
            pulumi.set(__self__, "time_maintenance_window_end", time_maintenance_window_end)
        if time_maintenance_window_start is not None:
            pulumi.set(__self__, "time_maintenance_window_start", time_maintenance_window_start)
        if total_cpu_core_count is not None:
            pulumi.set(__self__, "total_cpu_core_count", total_cpu_core_count)
        if vnic2id is not None:
            pulumi.set(__self__, "vnic2id", vnic2id)
        if vnic_id is not None:
            pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the planned maintenance.
        """
        return pulumi.get(self, "additional_details")

    @additional_details.setter
    def additional_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "additional_details", value)

    @property
    @pulumi.getter(name="backupIpId")
    def backup_ip_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup IPv4 address associated with the database node. Use this OCID with either the [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/GetPrivateIp) or the [GetPublicIpByPrivateIpId](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByPrivateIpId) API to get the IPv4 address needed to make a database connection.
        """
        return pulumi.get(self, "backup_ip_id")

    @backup_ip_id.setter
    def backup_ip_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_ip_id", value)

    @property
    @pulumi.getter(name="backupIpv6id")
    def backup_ipv6id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup IPv6 address associated with the database node. Use this OCID with the [GetIpv6](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/Ipv6/GetIpv6) API to get the IPv6 address needed to make a database connection.
        """
        return pulumi.get(self, "backup_ipv6id")

    @backup_ipv6id.setter
    def backup_ipv6id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_ipv6id", value)

    @property
    @pulumi.getter(name="backupVnic2id")
    def backup_vnic2id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second backup VNIC.
        """
        return pulumi.get(self, "backup_vnic2id")

    @backup_vnic2id.setter
    def backup_vnic2id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_vnic2id", value)

    @property
    @pulumi.getter(name="backupVnicId")
    def backup_vnic_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup VNIC.
        """
        return pulumi.get(self, "backup_vnic_id")

    @backup_vnic_id.setter
    def backup_vnic_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_vnic_id", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of CPU cores enabled on the Db node.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_node_id")

    @db_node_id.setter
    def db_node_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_node_id", value)

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The allocated local node storage in GBs on the Db node.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="dbServerId")
    def db_server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exacc Db server associated with the database node.
        """
        return pulumi.get(self, "db_server_id")

    @db_server_id.setter
    def db_server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_server_id", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Fault Domain the instance is contained in.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostIpId")
    def host_ip_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the host IPv4 address associated with the database node. Use this OCID with either the [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/GetPrivateIp) or the [GetPublicIpByPrivateIpId](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByPrivateIpId) API to get the IPv4 address needed to make a database connection.
        """
        return pulumi.get(self, "host_ip_id")

    @host_ip_id.setter
    def host_ip_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_ip_id", value)

    @property
    @pulumi.getter(name="hostIpv6id")
    def host_ipv6id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the host IPv6 address associated with the database node. Use this OCID with the [GetIpv6](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/Ipv6/GetIpv6) API to get the IPv6 address needed to make a database connection.
        """
        return pulumi.get(self, "host_ipv6id")

    @host_ipv6id.setter
    def host_ipv6id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_ipv6id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The host name for the database node.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maintenanceType")
    def maintenance_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of database node maintenance.
        """
        return pulumi.get(self, "maintenance_type")

    @maintenance_type.setter
    def maintenance_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_type", value)

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The allocated memory in GBs on the Db node.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @property
    @pulumi.getter(name="softwareStorageSizeInGb")
    def software_storage_size_in_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size (in GB) of the block storage volume allocation for the DB system. This attribute applies only for virtual machine DB systems.
        """
        return pulumi.get(self, "software_storage_size_in_gb")

    @software_storage_size_in_gb.setter
    def software_storage_size_in_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "software_storage_size_in_gb", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the database node.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time that the database node was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeMaintenanceWindowEnd")
    def time_maintenance_window_end(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        End date and time of maintenance window.
        """
        return pulumi.get(self, "time_maintenance_window_end")

    @time_maintenance_window_end.setter
    def time_maintenance_window_end(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_maintenance_window_end", value)

    @property
    @pulumi.getter(name="timeMaintenanceWindowStart")
    def time_maintenance_window_start(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Start date and time of maintenance window.
        """
        return pulumi.get(self, "time_maintenance_window_start")

    @time_maintenance_window_start.setter
    def time_maintenance_window_start(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_maintenance_window_start", value)

    @property
    @pulumi.getter(name="totalCpuCoreCount")
    def total_cpu_core_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The total number of CPU cores reserved on the Db node.
        """
        return pulumi.get(self, "total_cpu_core_count")

    @total_cpu_core_count.setter
    def total_cpu_core_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_cpu_core_count", value)

    @property
    @pulumi.getter
    def vnic2id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second VNIC.
        """
        return pulumi.get(self, "vnic2id")

    @vnic2id.setter
    def vnic2id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vnic2id", value)

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC.
        """
        return pulumi.get(self, "vnic_id")

    @vnic_id.setter
    def vnic_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vnic_id", value)


@pulumi.type_token("oci:Database/dbNode:DbNode")
class DbNode(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_node_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Db Node resource in Oracle Cloud Infrastructure Database service.

        Updates the specified database node.

        ## Import

        DbNodes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/dbNode:DbNode test_db_node "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbNodeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Db Node resource in Oracle Cloud Infrastructure Database service.

        Updates the specified database node.

        ## Import

        DbNodes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/dbNode:DbNode test_db_node "id"
        ```

        :param str resource_name: The name of the resource.
        :param DbNodeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbNodeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_node_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbNodeArgs.__new__(DbNodeArgs)

            if db_node_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_node_id'")
            __props__.__dict__["db_node_id"] = db_node_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["additional_details"] = None
            __props__.__dict__["backup_ip_id"] = None
            __props__.__dict__["backup_ipv6id"] = None
            __props__.__dict__["backup_vnic2id"] = None
            __props__.__dict__["backup_vnic_id"] = None
            __props__.__dict__["cpu_core_count"] = None
            __props__.__dict__["db_node_storage_size_in_gbs"] = None
            __props__.__dict__["db_server_id"] = None
            __props__.__dict__["db_system_id"] = None
            __props__.__dict__["fault_domain"] = None
            __props__.__dict__["host_ip_id"] = None
            __props__.__dict__["host_ipv6id"] = None
            __props__.__dict__["hostname"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["maintenance_type"] = None
            __props__.__dict__["memory_size_in_gbs"] = None
            __props__.__dict__["software_storage_size_in_gb"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_maintenance_window_end"] = None
            __props__.__dict__["time_maintenance_window_start"] = None
            __props__.__dict__["total_cpu_core_count"] = None
            __props__.__dict__["vnic2id"] = None
            __props__.__dict__["vnic_id"] = None
        super(DbNode, __self__).__init__(
            'oci:Database/dbNode:DbNode',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_details: Optional[pulumi.Input[builtins.str]] = None,
            backup_ip_id: Optional[pulumi.Input[builtins.str]] = None,
            backup_ipv6id: Optional[pulumi.Input[builtins.str]] = None,
            backup_vnic2id: Optional[pulumi.Input[builtins.str]] = None,
            backup_vnic_id: Optional[pulumi.Input[builtins.str]] = None,
            cpu_core_count: Optional[pulumi.Input[builtins.int]] = None,
            db_node_id: Optional[pulumi.Input[builtins.str]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
            db_server_id: Optional[pulumi.Input[builtins.str]] = None,
            db_system_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            fault_domain: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            host_ip_id: Optional[pulumi.Input[builtins.str]] = None,
            host_ipv6id: Optional[pulumi.Input[builtins.str]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            maintenance_type: Optional[pulumi.Input[builtins.str]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
            software_storage_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_maintenance_window_end: Optional[pulumi.Input[builtins.str]] = None,
            time_maintenance_window_start: Optional[pulumi.Input[builtins.str]] = None,
            total_cpu_core_count: Optional[pulumi.Input[builtins.int]] = None,
            vnic2id: Optional[pulumi.Input[builtins.str]] = None,
            vnic_id: Optional[pulumi.Input[builtins.str]] = None) -> 'DbNode':
        """
        Get an existing DbNode resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] additional_details: Additional information about the planned maintenance.
        :param pulumi.Input[builtins.str] backup_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup IPv4 address associated with the database node. Use this OCID with either the [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/GetPrivateIp) or the [GetPublicIpByPrivateIpId](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByPrivateIpId) API to get the IPv4 address needed to make a database connection.
        :param pulumi.Input[builtins.str] backup_ipv6id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup IPv6 address associated with the database node. Use this OCID with the [GetIpv6](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/Ipv6/GetIpv6) API to get the IPv6 address needed to make a database connection.
        :param pulumi.Input[builtins.str] backup_vnic2id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second backup VNIC.
        :param pulumi.Input[builtins.str] backup_vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup VNIC.
        :param pulumi.Input[builtins.int] cpu_core_count: The number of CPU cores enabled on the Db node.
        :param pulumi.Input[builtins.str] db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.int] db_node_storage_size_in_gbs: The allocated local node storage in GBs on the Db node.
        :param pulumi.Input[builtins.str] db_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exacc Db server associated with the database node.
        :param pulumi.Input[builtins.str] db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] fault_domain: The name of the Fault Domain the instance is contained in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] host_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the host IPv4 address associated with the database node. Use this OCID with either the [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/GetPrivateIp) or the [GetPublicIpByPrivateIpId](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByPrivateIpId) API to get the IPv4 address needed to make a database connection.
        :param pulumi.Input[builtins.str] host_ipv6id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the host IPv6 address associated with the database node. Use this OCID with the [GetIpv6](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/Ipv6/GetIpv6) API to get the IPv6 address needed to make a database connection.
        :param pulumi.Input[builtins.str] hostname: The host name for the database node.
        :param pulumi.Input[builtins.str] lifecycle_details: Information about the current lifecycle state.
        :param pulumi.Input[builtins.str] maintenance_type: The type of database node maintenance.
        :param pulumi.Input[builtins.int] memory_size_in_gbs: The allocated memory in GBs on the Db node.
        :param pulumi.Input[builtins.int] software_storage_size_in_gb: The size (in GB) of the block storage volume allocation for the DB system. This attribute applies only for virtual machine DB systems.
        :param pulumi.Input[builtins.str] state: The current state of the database node.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] time_created: The date and time that the database node was created.
        :param pulumi.Input[builtins.str] time_maintenance_window_end: End date and time of maintenance window.
        :param pulumi.Input[builtins.str] time_maintenance_window_start: Start date and time of maintenance window.
        :param pulumi.Input[builtins.int] total_cpu_core_count: The total number of CPU cores reserved on the Db node.
        :param pulumi.Input[builtins.str] vnic2id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second VNIC.
        :param pulumi.Input[builtins.str] vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbNodeState.__new__(_DbNodeState)

        __props__.__dict__["additional_details"] = additional_details
        __props__.__dict__["backup_ip_id"] = backup_ip_id
        __props__.__dict__["backup_ipv6id"] = backup_ipv6id
        __props__.__dict__["backup_vnic2id"] = backup_vnic2id
        __props__.__dict__["backup_vnic_id"] = backup_vnic_id
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["db_node_id"] = db_node_id
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_server_id"] = db_server_id
        __props__.__dict__["db_system_id"] = db_system_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["fault_domain"] = fault_domain
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["host_ip_id"] = host_ip_id
        __props__.__dict__["host_ipv6id"] = host_ipv6id
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["maintenance_type"] = maintenance_type
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["software_storage_size_in_gb"] = software_storage_size_in_gb
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_maintenance_window_end"] = time_maintenance_window_end
        __props__.__dict__["time_maintenance_window_start"] = time_maintenance_window_start
        __props__.__dict__["total_cpu_core_count"] = total_cpu_core_count
        __props__.__dict__["vnic2id"] = vnic2id
        __props__.__dict__["vnic_id"] = vnic_id
        return DbNode(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the planned maintenance.
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="backupIpId")
    def backup_ip_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup IPv4 address associated with the database node. Use this OCID with either the [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/GetPrivateIp) or the [GetPublicIpByPrivateIpId](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByPrivateIpId) API to get the IPv4 address needed to make a database connection.
        """
        return pulumi.get(self, "backup_ip_id")

    @property
    @pulumi.getter(name="backupIpv6id")
    def backup_ipv6id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup IPv6 address associated with the database node. Use this OCID with the [GetIpv6](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/Ipv6/GetIpv6) API to get the IPv6 address needed to make a database connection.
        """
        return pulumi.get(self, "backup_ipv6id")

    @property
    @pulumi.getter(name="backupVnic2id")
    def backup_vnic2id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second backup VNIC.
        """
        return pulumi.get(self, "backup_vnic2id")

    @property
    @pulumi.getter(name="backupVnicId")
    def backup_vnic_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup VNIC.
        """
        return pulumi.get(self, "backup_vnic_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of CPU cores enabled on the Db node.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> pulumi.Output[builtins.str]:
        """
        The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_node_id")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[builtins.int]:
        """
        The allocated local node storage in GBs on the Db node.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServerId")
    def db_server_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exacc Db server associated with the database node.
        """
        return pulumi.get(self, "db_server_id")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Fault Domain the instance is contained in.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostIpId")
    def host_ip_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the host IPv4 address associated with the database node. Use this OCID with either the [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PrivateIp/GetPrivateIp) or the [GetPublicIpByPrivateIpId](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/PublicIp/GetPublicIpByPrivateIpId) API to get the IPv4 address needed to make a database connection.
        """
        return pulumi.get(self, "host_ip_id")

    @property
    @pulumi.getter(name="hostIpv6id")
    def host_ipv6id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the host IPv6 address associated with the database node. Use this OCID with the [GetIpv6](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/Ipv6/GetIpv6) API to get the IPv6 address needed to make a database connection.
        """
        return pulumi.get(self, "host_ipv6id")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[builtins.str]:
        """
        The host name for the database node.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceType")
    def maintenance_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of database node maintenance.
        """
        return pulumi.get(self, "maintenance_type")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[builtins.int]:
        """
        The allocated memory in GBs on the Db node.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="softwareStorageSizeInGb")
    def software_storage_size_in_gb(self) -> pulumi.Output[builtins.int]:
        """
        The size (in GB) of the block storage volume allocation for the DB system. This attribute applies only for virtual machine DB systems.
        """
        return pulumi.get(self, "software_storage_size_in_gb")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the database node.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time that the database node was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeMaintenanceWindowEnd")
    def time_maintenance_window_end(self) -> pulumi.Output[builtins.str]:
        """
        End date and time of maintenance window.
        """
        return pulumi.get(self, "time_maintenance_window_end")

    @property
    @pulumi.getter(name="timeMaintenanceWindowStart")
    def time_maintenance_window_start(self) -> pulumi.Output[builtins.str]:
        """
        Start date and time of maintenance window.
        """
        return pulumi.get(self, "time_maintenance_window_start")

    @property
    @pulumi.getter(name="totalCpuCoreCount")
    def total_cpu_core_count(self) -> pulumi.Output[builtins.int]:
        """
        The total number of CPU cores reserved on the Db node.
        """
        return pulumi.get(self, "total_cpu_core_count")

    @property
    @pulumi.getter
    def vnic2id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second VNIC.
        """
        return pulumi.get(self, "vnic2id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC.
        """
        return pulumi.get(self, "vnic_id")

