# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAutonomousExadataInfrastructureOcpuResult',
    'AwaitableGetAutonomousExadataInfrastructureOcpuResult',
    'get_autonomous_exadata_infrastructure_ocpu',
    'get_autonomous_exadata_infrastructure_ocpu_output',
]

@pulumi.output_type
class GetAutonomousExadataInfrastructureOcpuResult:
    """
    A collection of values returned by getAutonomousExadataInfrastructureOcpu.
    """
    def __init__(__self__, autonomous_exadata_infrastructure_id=None, by_workload_types=None, consumed_cpu=None, id=None, total_cpu=None):
        if autonomous_exadata_infrastructure_id and not isinstance(autonomous_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'autonomous_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "autonomous_exadata_infrastructure_id", autonomous_exadata_infrastructure_id)
        if by_workload_types and not isinstance(by_workload_types, list):
            raise TypeError("Expected argument 'by_workload_types' to be a list")
        pulumi.set(__self__, "by_workload_types", by_workload_types)
        if consumed_cpu and not isinstance(consumed_cpu, float):
            raise TypeError("Expected argument 'consumed_cpu' to be a float")
        pulumi.set(__self__, "consumed_cpu", consumed_cpu)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if total_cpu and not isinstance(total_cpu, float):
            raise TypeError("Expected argument 'total_cpu' to be a float")
        pulumi.set(__self__, "total_cpu", total_cpu)

    @property
    @pulumi.getter(name="autonomousExadataInfrastructureId")
    def autonomous_exadata_infrastructure_id(self) -> builtins.str:
        return pulumi.get(self, "autonomous_exadata_infrastructure_id")

    @property
    @pulumi.getter(name="byWorkloadTypes")
    def by_workload_types(self) -> Sequence['outputs.GetAutonomousExadataInfrastructureOcpuByWorkloadTypeResult']:
        """
        The number of consumed OCPUs, by database workload type.
        """
        return pulumi.get(self, "by_workload_types")

    @property
    @pulumi.getter(name="consumedCpu")
    def consumed_cpu(self) -> builtins.float:
        """
        The total number of consumed OCPUs in the Autonomous Exadata Infrastructure instance.
        """
        return pulumi.get(self, "consumed_cpu")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="totalCpu")
    def total_cpu(self) -> builtins.float:
        """
        The total number of OCPUs in the Autonomous Exadata Infrastructure instance.
        """
        return pulumi.get(self, "total_cpu")


class AwaitableGetAutonomousExadataInfrastructureOcpuResult(GetAutonomousExadataInfrastructureOcpuResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousExadataInfrastructureOcpuResult(
            autonomous_exadata_infrastructure_id=self.autonomous_exadata_infrastructure_id,
            by_workload_types=self.by_workload_types,
            consumed_cpu=self.consumed_cpu,
            id=self.id,
            total_cpu=self.total_cpu)


def get_autonomous_exadata_infrastructure_ocpu(autonomous_exadata_infrastructure_id: Optional[builtins.str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousExadataInfrastructureOcpuResult:
    """
    This data source provides details about a specific Autonomous Exadata Infrastructure Ocpu resource in Oracle Cloud Infrastructure Database service.

    Gets details of the available and consumed OCPUs for the specified Autonomous Exadata Infrastructure resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_exadata_infrastructure_ocpu = oci.Database.get_autonomous_exadata_infrastructure_ocpu(autonomous_exadata_infrastructure_id=test_autonomous_exadata_infrastructure["id"])
    ```


    :param builtins.str autonomous_exadata_infrastructure_id: The Autonomous Exadata Infrastructure  [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousExadataInfrastructureId'] = autonomous_exadata_infrastructure_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousExadataInfrastructureOcpu:getAutonomousExadataInfrastructureOcpu', __args__, opts=opts, typ=GetAutonomousExadataInfrastructureOcpuResult).value

    return AwaitableGetAutonomousExadataInfrastructureOcpuResult(
        autonomous_exadata_infrastructure_id=pulumi.get(__ret__, 'autonomous_exadata_infrastructure_id'),
        by_workload_types=pulumi.get(__ret__, 'by_workload_types'),
        consumed_cpu=pulumi.get(__ret__, 'consumed_cpu'),
        id=pulumi.get(__ret__, 'id'),
        total_cpu=pulumi.get(__ret__, 'total_cpu'))
def get_autonomous_exadata_infrastructure_ocpu_output(autonomous_exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousExadataInfrastructureOcpuResult]:
    """
    This data source provides details about a specific Autonomous Exadata Infrastructure Ocpu resource in Oracle Cloud Infrastructure Database service.

    Gets details of the available and consumed OCPUs for the specified Autonomous Exadata Infrastructure resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_exadata_infrastructure_ocpu = oci.Database.get_autonomous_exadata_infrastructure_ocpu(autonomous_exadata_infrastructure_id=test_autonomous_exadata_infrastructure["id"])
    ```


    :param builtins.str autonomous_exadata_infrastructure_id: The Autonomous Exadata Infrastructure  [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousExadataInfrastructureId'] = autonomous_exadata_infrastructure_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousExadataInfrastructureOcpu:getAutonomousExadataInfrastructureOcpu', __args__, opts=opts, typ=GetAutonomousExadataInfrastructureOcpuResult)
    return __ret__.apply(lambda __response__: GetAutonomousExadataInfrastructureOcpuResult(
        autonomous_exadata_infrastructure_id=pulumi.get(__response__, 'autonomous_exadata_infrastructure_id'),
        by_workload_types=pulumi.get(__response__, 'by_workload_types'),
        consumed_cpu=pulumi.get(__response__, 'consumed_cpu'),
        id=pulumi.get(__response__, 'id'),
        total_cpu=pulumi.get(__response__, 'total_cpu')))
