# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetOneoffPatchResult',
    'AwaitableGetOneoffPatchResult',
    'get_oneoff_patch',
    'get_oneoff_patch_output',
]

@pulumi.output_type
class GetOneoffPatchResult:
    """
    A collection of values returned by getOneoffPatch.
    """
    def __init__(__self__, compartment_id=None, db_version=None, defined_tags=None, display_name=None, download_oneoff_patch_trigger=None, freeform_tags=None, id=None, lifecycle_details=None, one_off_patches=None, oneoff_patch_id=None, release_update=None, sha256sum=None, size_in_kbs=None, state=None, system_tags=None, time_created=None, time_of_expiration=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if download_oneoff_patch_trigger and not isinstance(download_oneoff_patch_trigger, int):
            raise TypeError("Expected argument 'download_oneoff_patch_trigger' to be a int")
        pulumi.set(__self__, "download_oneoff_patch_trigger", download_oneoff_patch_trigger)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if one_off_patches and not isinstance(one_off_patches, list):
            raise TypeError("Expected argument 'one_off_patches' to be a list")
        pulumi.set(__self__, "one_off_patches", one_off_patches)
        if oneoff_patch_id and not isinstance(oneoff_patch_id, str):
            raise TypeError("Expected argument 'oneoff_patch_id' to be a str")
        pulumi.set(__self__, "oneoff_patch_id", oneoff_patch_id)
        if release_update and not isinstance(release_update, str):
            raise TypeError("Expected argument 'release_update' to be a str")
        pulumi.set(__self__, "release_update", release_update)
        if sha256sum and not isinstance(sha256sum, str):
            raise TypeError("Expected argument 'sha256sum' to be a str")
        pulumi.set(__self__, "sha256sum", sha256sum)
        if size_in_kbs and not isinstance(size_in_kbs, float):
            raise TypeError("Expected argument 'size_in_kbs' to be a float")
        pulumi.set(__self__, "size_in_kbs", size_in_kbs)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_of_expiration and not isinstance(time_of_expiration, str):
            raise TypeError("Expected argument 'time_of_expiration' to be a str")
        pulumi.set(__self__, "time_of_expiration", time_of_expiration)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> builtins.str:
        """
        A valid Oracle Database version. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        One-off patch name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="downloadOneoffPatchTrigger")
    def download_oneoff_patch_trigger(self) -> builtins.int:
        return pulumi.get(self, "download_oneoff_patch_trigger")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the one-off patch.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="oneOffPatches")
    def one_off_patches(self) -> Sequence[builtins.str]:
        """
        List of one-off patches for Database Homes.
        """
        return pulumi.get(self, "one_off_patches")

    @property
    @pulumi.getter(name="oneoffPatchId")
    def oneoff_patch_id(self) -> builtins.str:
        return pulumi.get(self, "oneoff_patch_id")

    @property
    @pulumi.getter(name="releaseUpdate")
    def release_update(self) -> builtins.str:
        """
        The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        """
        return pulumi.get(self, "release_update")

    @property
    @pulumi.getter
    def sha256sum(self) -> builtins.str:
        """
        SHA-256 checksum of the one-off patch.
        """
        return pulumi.get(self, "sha256sum")

    @property
    @pulumi.getter(name="sizeInKbs")
    def size_in_kbs(self) -> builtins.float:
        """
        The size of one-off patch in kilobytes.
        """
        return pulumi.get(self, "size_in_kbs")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the one-off patch.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time one-off patch was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfExpiration")
    def time_of_expiration(self) -> builtins.str:
        """
        The date and time until which the one-off patch will be available for download.
        """
        return pulumi.get(self, "time_of_expiration")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time one-off patch was updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetOneoffPatchResult(GetOneoffPatchResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOneoffPatchResult(
            compartment_id=self.compartment_id,
            db_version=self.db_version,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            download_oneoff_patch_trigger=self.download_oneoff_patch_trigger,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            one_off_patches=self.one_off_patches,
            oneoff_patch_id=self.oneoff_patch_id,
            release_update=self.release_update,
            sha256sum=self.sha256sum,
            size_in_kbs=self.size_in_kbs,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_of_expiration=self.time_of_expiration,
            time_updated=self.time_updated)


def get_oneoff_patch(oneoff_patch_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOneoffPatchResult:
    """
    This data source provides details about a specific Oneoff Patch resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified one-off patch.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oneoff_patch = oci.Database.get_oneoff_patch(oneoff_patch_id=test_oneoff_patch_oci_database_oneoff_patch["id"])
    ```


    :param builtins.str oneoff_patch_id: The one-off patch [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['oneoffPatchId'] = oneoff_patch_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getOneoffPatch:getOneoffPatch', __args__, opts=opts, typ=GetOneoffPatchResult).value

    return AwaitableGetOneoffPatchResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_version=pulumi.get(__ret__, 'db_version'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        download_oneoff_patch_trigger=pulumi.get(__ret__, 'download_oneoff_patch_trigger'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        one_off_patches=pulumi.get(__ret__, 'one_off_patches'),
        oneoff_patch_id=pulumi.get(__ret__, 'oneoff_patch_id'),
        release_update=pulumi.get(__ret__, 'release_update'),
        sha256sum=pulumi.get(__ret__, 'sha256sum'),
        size_in_kbs=pulumi.get(__ret__, 'size_in_kbs'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_of_expiration=pulumi.get(__ret__, 'time_of_expiration'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_oneoff_patch_output(oneoff_patch_id: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOneoffPatchResult]:
    """
    This data source provides details about a specific Oneoff Patch resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified one-off patch.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oneoff_patch = oci.Database.get_oneoff_patch(oneoff_patch_id=test_oneoff_patch_oci_database_oneoff_patch["id"])
    ```


    :param builtins.str oneoff_patch_id: The one-off patch [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['oneoffPatchId'] = oneoff_patch_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getOneoffPatch:getOneoffPatch', __args__, opts=opts, typ=GetOneoffPatchResult)
    return __ret__.apply(lambda __response__: GetOneoffPatchResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        db_version=pulumi.get(__response__, 'db_version'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        download_oneoff_patch_trigger=pulumi.get(__response__, 'download_oneoff_patch_trigger'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        one_off_patches=pulumi.get(__response__, 'one_off_patches'),
        oneoff_patch_id=pulumi.get(__response__, 'oneoff_patch_id'),
        release_update=pulumi.get(__response__, 'release_update'),
        sha256sum=pulumi.get(__response__, 'sha256sum'),
        size_in_kbs=pulumi.get(__response__, 'size_in_kbs'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_of_expiration=pulumi.get(__response__, 'time_of_expiration'),
        time_updated=pulumi.get(__response__, 'time_updated')))
