# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetScheduledActionsResult',
    'AwaitableGetScheduledActionsResult',
    'get_scheduled_actions',
    'get_scheduled_actions_output',
]

@pulumi.output_type
class GetScheduledActionsResult:
    """
    A collection of values returned by getScheduledActions.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, scheduled_action_collections=None, scheduling_plan_id=None, service_type=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if scheduled_action_collections and not isinstance(scheduled_action_collections, list):
            raise TypeError("Expected argument 'scheduled_action_collections' to be a list")
        pulumi.set(__self__, "scheduled_action_collections", scheduled_action_collections)
        if scheduling_plan_id and not isinstance(scheduling_plan_id, str):
            raise TypeError("Expected argument 'scheduling_plan_id' to be a str")
        pulumi.set(__self__, "scheduling_plan_id", scheduling_plan_id)
        if service_type and not isinstance(service_type, str):
            raise TypeError("Expected argument 'service_type' to be a str")
        pulumi.set(__self__, "service_type", service_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The display name of the Scheduled Action.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetScheduledActionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduled Action.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="scheduledActionCollections")
    def scheduled_action_collections(self) -> Sequence['outputs.GetScheduledActionsScheduledActionCollectionResult']:
        """
        The list of scheduled_action_collection.
        """
        return pulumi.get(self, "scheduled_action_collections")

    @property
    @pulumi.getter(name="schedulingPlanId")
    def scheduling_plan_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Plan.
        """
        return pulumi.get(self, "scheduling_plan_id")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Scheduled Action. Valid states are CREATING, NEEDS_ATTENTION, AVAILABLE, UPDATING, FAILED, DELETING and DELETED.
        """
        return pulumi.get(self, "state")


class AwaitableGetScheduledActionsResult(GetScheduledActionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduledActionsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            scheduled_action_collections=self.scheduled_action_collections,
            scheduling_plan_id=self.scheduling_plan_id,
            service_type=self.service_type,
            state=self.state)


def get_scheduled_actions(compartment_id: Optional[builtins.str] = None,
                          display_name: Optional[builtins.str] = None,
                          filters: Optional[Sequence[Union['GetScheduledActionsFilterArgs', 'GetScheduledActionsFilterArgsDict']]] = None,
                          id: Optional[builtins.str] = None,
                          scheduling_plan_id: Optional[builtins.str] = None,
                          service_type: Optional[builtins.str] = None,
                          state: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduledActionsResult:
    """
    This data source provides the list of Scheduled Actions in Oracle Cloud Infrastructure Database service.

    Lists the Scheduled Action resources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_actions = oci.Database.get_scheduled_actions(compartment_id=compartment_id,
        display_name=scheduled_action_display_name,
        id=scheduled_action_id,
        scheduling_plan_id=test_scheduling_plan["id"],
        service_type=scheduled_action_service_type,
        state=scheduled_action_state)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str id: A filter to return only resources that match the given Scheduled Action id exactly.
    :param builtins.str scheduling_plan_id: A filter to return only resources that match the given scheduling policy id exactly.
    :param builtins.str service_type: A filter to return only resources that match the given service type exactly.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['schedulingPlanId'] = scheduling_plan_id
    __args__['serviceType'] = service_type
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getScheduledActions:getScheduledActions', __args__, opts=opts, typ=GetScheduledActionsResult).value

    return AwaitableGetScheduledActionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        scheduled_action_collections=pulumi.get(__ret__, 'scheduled_action_collections'),
        scheduling_plan_id=pulumi.get(__ret__, 'scheduling_plan_id'),
        service_type=pulumi.get(__ret__, 'service_type'),
        state=pulumi.get(__ret__, 'state'))
def get_scheduled_actions_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                 display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetScheduledActionsFilterArgs', 'GetScheduledActionsFilterArgsDict']]]]] = None,
                                 id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 scheduling_plan_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 service_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScheduledActionsResult]:
    """
    This data source provides the list of Scheduled Actions in Oracle Cloud Infrastructure Database service.

    Lists the Scheduled Action resources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_actions = oci.Database.get_scheduled_actions(compartment_id=compartment_id,
        display_name=scheduled_action_display_name,
        id=scheduled_action_id,
        scheduling_plan_id=test_scheduling_plan["id"],
        service_type=scheduled_action_service_type,
        state=scheduled_action_state)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str id: A filter to return only resources that match the given Scheduled Action id exactly.
    :param builtins.str scheduling_plan_id: A filter to return only resources that match the given scheduling policy id exactly.
    :param builtins.str service_type: A filter to return only resources that match the given service type exactly.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['schedulingPlanId'] = scheduling_plan_id
    __args__['serviceType'] = service_type
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getScheduledActions:getScheduledActions', __args__, opts=opts, typ=GetScheduledActionsResult)
    return __ret__.apply(lambda __response__: GetScheduledActionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        scheduled_action_collections=pulumi.get(__response__, 'scheduled_action_collections'),
        scheduling_plan_id=pulumi.get(__response__, 'scheduling_plan_id'),
        service_type=pulumi.get(__response__, 'service_type'),
        state=pulumi.get(__response__, 'state')))
