# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSchedulingPolicySchedulingWindowResult',
    'AwaitableGetSchedulingPolicySchedulingWindowResult',
    'get_scheduling_policy_scheduling_window',
    'get_scheduling_policy_scheduling_window_output',
]

@pulumi.output_type
class GetSchedulingPolicySchedulingWindowResult:
    """
    A collection of values returned by getSchedulingPolicySchedulingWindow.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, scheduling_policy_id=None, scheduling_window_id=None, state=None, time_created=None, time_next_scheduling_window_starts=None, time_updated=None, window_preferences=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if scheduling_policy_id and not isinstance(scheduling_policy_id, str):
            raise TypeError("Expected argument 'scheduling_policy_id' to be a str")
        pulumi.set(__self__, "scheduling_policy_id", scheduling_policy_id)
        if scheduling_window_id and not isinstance(scheduling_window_id, str):
            raise TypeError("Expected argument 'scheduling_window_id' to be a str")
        pulumi.set(__self__, "scheduling_window_id", scheduling_window_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_next_scheduling_window_starts and not isinstance(time_next_scheduling_window_starts, str):
            raise TypeError("Expected argument 'time_next_scheduling_window_starts' to be a str")
        pulumi.set(__self__, "time_next_scheduling_window_starts", time_next_scheduling_window_starts)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if window_preferences and not isinstance(window_preferences, list):
            raise TypeError("Expected argument 'window_preferences' to be a list")
        pulumi.set(__self__, "window_preferences", window_preferences)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The user-friendly name for the Scheduling Window. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Window.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="schedulingPolicyId")
    def scheduling_policy_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Policy.
        """
        return pulumi.get(self, "scheduling_policy_id")

    @property
    @pulumi.getter(name="schedulingWindowId")
    def scheduling_window_id(self) -> builtins.str:
        return pulumi.get(self, "scheduling_window_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the Scheduling Window. Valid states are CREATING, ACTIVE, UPDATING, FAILED, DELETING and DELETED.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the Scheduling Window was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeNextSchedulingWindowStarts")
    def time_next_scheduling_window_starts(self) -> builtins.str:
        """
        The date and time of the next upcoming window associated within the schedulingWindow is planned to start.
        """
        return pulumi.get(self, "time_next_scheduling_window_starts")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The last date and time that the Scheduling Window was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="windowPreferences")
    def window_preferences(self) -> Sequence['outputs.GetSchedulingPolicySchedulingWindowWindowPreferenceResult']:
        """
        The Single Scheduling Window details.
        """
        return pulumi.get(self, "window_preferences")


class AwaitableGetSchedulingPolicySchedulingWindowResult(GetSchedulingPolicySchedulingWindowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchedulingPolicySchedulingWindowResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            scheduling_policy_id=self.scheduling_policy_id,
            scheduling_window_id=self.scheduling_window_id,
            state=self.state,
            time_created=self.time_created,
            time_next_scheduling_window_starts=self.time_next_scheduling_window_starts,
            time_updated=self.time_updated,
            window_preferences=self.window_preferences)


def get_scheduling_policy_scheduling_window(scheduling_policy_id: Optional[builtins.str] = None,
                                            scheduling_window_id: Optional[builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchedulingPolicySchedulingWindowResult:
    """
    This data source provides details about a specific Scheduling Policy Scheduling Window resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Scheduling Window.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduling_policy_scheduling_window = oci.Database.get_scheduling_policy_scheduling_window(scheduling_policy_id=test_scheduling_policy["id"],
        scheduling_window_id=test_scheduling_window["id"])
    ```


    :param builtins.str scheduling_policy_id: The Scheduling Policy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str scheduling_window_id: The Scheduling Window [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['schedulingPolicyId'] = scheduling_policy_id
    __args__['schedulingWindowId'] = scheduling_window_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getSchedulingPolicySchedulingWindow:getSchedulingPolicySchedulingWindow', __args__, opts=opts, typ=GetSchedulingPolicySchedulingWindowResult).value

    return AwaitableGetSchedulingPolicySchedulingWindowResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        scheduling_policy_id=pulumi.get(__ret__, 'scheduling_policy_id'),
        scheduling_window_id=pulumi.get(__ret__, 'scheduling_window_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_next_scheduling_window_starts=pulumi.get(__ret__, 'time_next_scheduling_window_starts'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        window_preferences=pulumi.get(__ret__, 'window_preferences'))
def get_scheduling_policy_scheduling_window_output(scheduling_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                                                   scheduling_window_id: Optional[pulumi.Input[builtins.str]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchedulingPolicySchedulingWindowResult]:
    """
    This data source provides details about a specific Scheduling Policy Scheduling Window resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Scheduling Window.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduling_policy_scheduling_window = oci.Database.get_scheduling_policy_scheduling_window(scheduling_policy_id=test_scheduling_policy["id"],
        scheduling_window_id=test_scheduling_window["id"])
    ```


    :param builtins.str scheduling_policy_id: The Scheduling Policy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str scheduling_window_id: The Scheduling Window [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['schedulingPolicyId'] = scheduling_policy_id
    __args__['schedulingWindowId'] = scheduling_window_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getSchedulingPolicySchedulingWindow:getSchedulingPolicySchedulingWindow', __args__, opts=opts, typ=GetSchedulingPolicySchedulingWindowResult)
    return __ret__.apply(lambda __response__: GetSchedulingPolicySchedulingWindowResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        scheduling_policy_id=pulumi.get(__response__, 'scheduling_policy_id'),
        scheduling_window_id=pulumi.get(__response__, 'scheduling_window_id'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_next_scheduling_window_starts=pulumi.get(__response__, 'time_next_scheduling_window_starts'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        window_preferences=pulumi.get(__response__, 'window_preferences')))
